/* Generated by re2c 0.9.10.dev on Thu Nov 17 13:55:10 2005 */
/*
   +----------------------------------------------------------------------+
   | PHP Version 5                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2005 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.0 of the PHP license,       |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_0.txt.                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Derick Rethans <derick@derickrethans.nl>                    |
   +----------------------------------------------------------------------+
 */

/* $Id: parse_date.c,v 1.29.2.10 2005/11/17 13:04:25 derick Exp $ */

#include "timelib.h"

#include <stdio.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; s->time->relative.weekday_behavior = 0; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_weekday_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { return TIMELIB_ERROR; } else { s->time.have_zone = 1; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x) { \
	if ((x) == -1) {         \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	int           errors;

	struct timelib_time *time;
	timelib_tzdb        *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

#define HOUR(a) (int)(a * 60)

/* The timezone table. */
static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },

	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		*ptr += 3;
	} else {
		++*ptr;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = -1;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	free(str);
	return tmp_nr;
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = -1;
	int len = 0;

	while ((**ptr != '.') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtod(str, NULL);
	free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
	} else if (**ptr == '-') {
		dir = -1;
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static long timelib_parse_tz_cor(char **ptr)
{
	char *begin = *ptr, *end;
	long  tmp;

	while (**ptr != '\0') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1:
		case 2:
			return HOUR(strtol(begin, NULL, 10));
			break;
		case 3:
		case 4:
			tmp = strtol(begin, NULL, 10);
			return HOUR(tmp / 100) + tmp % 100;
		case 5:
			tmp = HOUR(strtol(begin, NULL, 10)) +
				strtol(begin + 3, NULL, 10);
			return tmp;
	}
	return 0;
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	free(word);
	return value;
}

static long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ') {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	relunit = timelib_lookup_relunit(ptr);
	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;
	}
}

static timelib_tz_lookup_table* zone_search(const char *word, long gmtoffset, int isdst)
{
	int first_found = 0;
	timelib_tz_lookup_table  *tp, *first_found_elem;
	timelib_tz_lookup_table  *fmp;
	
	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}
	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 3600) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static long timelib_lookup_zone(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = zone_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

static long timelib_get_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, timelib_tzdb *tzdb)
{
	timelib_tzinfo *res;
	long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '(') {
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		long offset;
		char *tz_abbr;

		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_ABBR;

		offset = timelib_lookup_zone(ptr, dst, &tz_abbr, &found);
#if 0
		/* If we found a TimeZone identifier, use it */
		if (tz_name) {
			t->tz_info = timelib_parse_tzfile(tz_name);
			t->zone_type = TIMELIB_ZONETYPE_ID;
		}
#endif
		/* If we have a TimeZone identifier to start with, use it */
		if (strstr(tz_abbr, "/")) {
			if ((res = timelib_parse_tzfile(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		if (t->zone_type != TIMELIB_ZONETYPE_ID) {
			timelib_time_tz_abbr_update(t, tz_abbr);
		}
		free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		free(arg.v[i]);            \
	}                              \
	if (arg.v) {                   \
		free(arg.v);               \
	}                              \
}

static int scan(Scanner *s)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;
		
std:
	s->tok = cursor;
	s->len = 0;


{
	static unsigned char yybm[] = {
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	208,  64,  64,  64,  64,  64,  64,  64, 
	 64,  64,  64,  64, 192,  64, 192,   0, 
	 32,  32,  32,  32,  32,  32,  32,  32, 
	 32,  32,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   8,   8,   8, 136,   8,   8,   8, 
	136,   8,   8,   8,   8,   8, 136,   8, 
	  8,   8, 136, 136, 136,   8,   8,   8, 
	  8,   8,   8,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	};

{
	YYCTYPE yych;
	unsigned int yyaccept;
	goto yy0;

	YYDEBUG(1, *YYCURSOR);
	++YYCURSOR;
yy0:
	if((YYLIMIT - YYCURSOR) < 26) YYFILL(26);
	yych = *YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case 0x00:	case 0x0A:	goto yy46;
	case ' ':	case ',':	case '.':	goto yy44;
	case '(':	goto yy41;
	case '+':	case '-':	goto yy40;
	case '0':	goto yy9;
	case '1':	goto yy10;
	case '2':	goto yy11;
	case '3':	goto yy12;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy13;
	case '@':	goto yy7;
	case 'A':	goto yy22;
	case 'B':
	case 'C':	case 'G':
	case 'H':	case 'K':	case 'Q':
	case 'R':	case 'U':	case 'Y':
	case 'Z':	goto yy42;
	case 'D':	goto yy29;
	case 'E':	goto yy32;
	case 'F':	goto yy19;
	case 'I':	goto yy14;
	case 'J':	goto yy17;
	case 'L':	goto yy34;
	case 'M':	goto yy21;
	case 'N':	goto yy28;
	case 'O':	goto yy26;
	case 'P':	goto yy36;
	case 'S':	goto yy24;
	case 'T':	goto yy31;
	case 'V':	goto yy15;
	case 'W':	goto yy38;
	case 'X':	goto yy16;
	case 'a':	goto yy23;
	case 'b':
	case 'c':	case 'g':
	case 'h':
	case 'i':	case 'k':	case 'q':
	case 'r':	case 'u':
	case 'v':	case 'x':	case 'z':	goto yy43;
	case 'd':	goto yy30;
	case 'e':	goto yy33;
	case 'f':	goto yy20;
	case 'j':	goto yy18;
	case 'l':	goto yy35;
	case 'm':	goto yy5;
	case 'n':	goto yy4;
	case 'o':	goto yy27;
	case 'p':	goto yy37;
	case 's':	goto yy25;
	case 't':	goto yy6;
	case 'w':	goto yy39;
	case 'y':	goto yy2;
	default:	goto yy48;
	}
yy2:
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= 'Z'){
		if(yych == ')')	goto yy49;
		if(yych >= 'A')	goto yy50;
		goto yy3;
	} else {
		if(yych <= 'd'){
			if(yych >= 'a')	goto yy50;
			goto yy3;
		} else {
			if(yych <= 'e')	goto yy1333;
			if(yych <= 'z')	goto yy50;
			goto yy3;
		}
	}
yy3:
	YYDEBUG(3, *YYCURSOR);

{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		s->errors += tz_not_found;
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
yy4:
	YYDEBUG(4, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'D'){
			if(yych == ')')	goto yy49;
			if(yych <= '@')	goto yy3;
			goto yy50;
		} else {
			if(yych <= 'H'){
				if(yych <= 'E')	goto yy610;
				goto yy50;
			} else {
				if(yych <= 'I')	goto yy611;
				if(yych <= 'N')	goto yy50;
				goto yy606;
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy50;
				goto yy3;
			} else {
				if(yych == 'e')	goto yy610;
				goto yy50;
			}
		} else {
			if(yych <= 'n'){
				if(yych <= 'i')	goto yy611;
				goto yy50;
			} else {
				if(yych <= 'o')	goto yy1327;
				if(yych <= 'z')	goto yy50;
				goto yy3;
			}
		}
	}
yy5:
	YYDEBUG(5, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Z'){
		if(yych <= '@'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= 'A')	goto yy705;
			if(yych == 'O')	goto yy708;
			goto yy50;
		}
	} else {
		if(yych <= 'i'){
			if(yych <= '`')	goto yy3;
			if(yych <= 'a')	goto yy705;
			if(yych <= 'h')	goto yy50;
			goto yy1321;
		} else {
			if(yych == 'o')	goto yy708;
			if(yych <= 'z')	goto yy50;
			goto yy3;
		}
	}
yy6:
	YYDEBUG(6, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Z'){
		if(yych <= 'G'){
			if(yych <= '@'){
				if(yych == ')')	goto yy49;
				goto yy3;
			} else {
				if(yych == 'E')	goto yy472;
				goto yy50;
			}
		} else {
			if(yych <= 'U'){
				if(yych <= 'H')	goto yy473;
				if(yych <= 'T')	goto yy50;
				goto yy474;
			} else {
				if(yych == 'W')	goto yy475;
				goto yy50;
			}
		}
	} else {
		if(yych <= 'n'){
			if(yych <= 'e'){
				if(yych <= '`')	goto yy3;
				if(yych <= 'd')	goto yy50;
				goto yy472;
			} else {
				if(yych == 'h')	goto yy473;
				goto yy50;
			}
		} else {
			if(yych <= 'u'){
				if(yych <= 'o')	goto yy1309;
				if(yych <= 't')	goto yy50;
				goto yy474;
			} else {
				if(yych == 'w')	goto yy475;
				if(yych <= 'z')	goto yy50;
				goto yy3;
			}
		}
	}
yy7:
	YYDEBUG(7, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '-')	goto yy1305;
	if(yych <= '0')	goto yy8;
	if(yych <= '9')	goto yy1306;
	goto yy8;
yy8:
	YYDEBUG(8, *YYCURSOR);

{
/*		printf("unexpected character: #%d, %c ", *s->tok, *s->tok); */
		s->errors++;
		goto std;
	}
yy9:
	YYDEBUG(9, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':	case 'A':	case 'D':	case 'F':	case 'H':
	case 'I':
	case 'J':	case 'M':
	case 'N':
	case 'O':	case 'S':
	case 'T':	case 'V':
	case 'W':
	case 'X':
	case 'Y':	case 'a':	case 'd':	case 'f':	case 'h':	case 'j':	case 'm':
	case 'n':
	case 'o':	case 's':
	case 't':	case 'w':	case 'y':	goto yy1262;
	case '-':	goto yy789;
	case '.':	goto yy1271;
	case '/':	goto yy788;
	case '0':	goto yy1304;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1303;
	case ':':	goto yy1272;
	default:	goto yy8;
	}
yy10:
	YYDEBUG(10, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':	case 'A':	case 'D':	case 'F':	case 'H':
	case 'I':
	case 'J':	case 'M':
	case 'N':
	case 'O':
	case 'P':	case 'S':
	case 'T':	case 'V':
	case 'W':
	case 'X':
	case 'Y':	case 'a':	case 'd':	case 'f':	case 'h':	case 'j':	case 'm':
	case 'n':
	case 'o':
	case 'p':	case 's':
	case 't':	case 'w':	case 'y':	goto yy782;
	case '-':	goto yy789;
	case '.':	goto yy792;
	case '/':	goto yy788;
	case '0':
	case '1':
	case '2':	goto yy1303;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1270;
	case ':':	goto yy801;
	default:	goto yy8;
	}
yy11:
	YYDEBUG(11, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':	case 'A':	case 'D':	case 'F':	case 'H':
	case 'I':
	case 'J':	case 'M':
	case 'N':
	case 'O':
	case 'P':	case 'S':
	case 'T':	case 'V':
	case 'W':
	case 'X':
	case 'Y':	case 'a':	case 'd':	case 'f':	case 'h':	case 'j':	case 'm':
	case 'n':
	case 'o':
	case 'p':	case 's':
	case 't':	case 'w':	case 'y':	goto yy782;
	case '-':	goto yy789;
	case '.':	goto yy792;
	case '/':	goto yy788;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy1270;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1260;
	case ':':	goto yy801;
	default:	goto yy8;
	}
yy12:
	YYDEBUG(12, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':	case 'A':	case 'D':	case 'F':	case 'H':
	case 'I':
	case 'J':	case 'M':
	case 'N':
	case 'O':
	case 'P':	case 'S':
	case 'T':	case 'V':
	case 'W':
	case 'X':
	case 'Y':	case 'a':	case 'd':	case 'f':	case 'h':	case 'j':	case 'm':
	case 'n':
	case 'o':
	case 'p':	case 's':
	case 't':	case 'w':	case 'y':	goto yy782;
	case '-':	goto yy789;
	case '.':	goto yy792;
	case '/':	goto yy788;
	case '0':
	case '1':	goto yy1260;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy787;
	case ':':	goto yy801;
	default:	goto yy8;
	}
yy13:
	YYDEBUG(13, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':	case 'A':	case 'D':	case 'F':	case 'H':
	case 'I':
	case 'J':	case 'M':
	case 'N':
	case 'O':
	case 'P':	case 'S':
	case 'T':	case 'V':
	case 'W':
	case 'X':
	case 'Y':	case 'a':	case 'd':	case 'f':	case 'h':	case 'j':	case 'm':
	case 'n':
	case 'o':
	case 'p':	case 's':
	case 't':	case 'w':	case 'y':	goto yy782;
	case '-':	goto yy789;
	case '.':	goto yy792;
	case '/':	goto yy788;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy787;
	case ':':	goto yy801;
	default:	goto yy8;
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '/')	goto yy3;
			if(yych <= '9')	goto yy509;
			if(yych <= '@')	goto yy3;
			goto yy50;
		}
	} else {
		if(yych <= 'W'){
			if(yych <= 'I')	goto yy780;
			if(yych == 'V')	goto yy779;
			goto yy50;
		} else {
			if(yych <= 'Z'){
				if(yych <= 'X')	goto yy779;
				goto yy50;
			} else {
				if(yych <= '`')	goto yy3;
				if(yych <= 'z')	goto yy53;
				goto yy3;
			}
		}
	}
yy15:
	YYDEBUG(15, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ')'){
			if(yych <= 0x1F)	goto yy3;
			if(yych <= '(')	goto yy509;
			goto yy510;
		} else {
			if(yych == '/')	goto yy3;
			goto yy509;
		}
	} else {
		if(yych <= 'I'){
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy50;
			goto yy777;
		} else {
			if(yych <= 'Z')	goto yy50;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy53;
			goto yy3;
		}
	}
yy16:
	YYDEBUG(16, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ')'){
			if(yych <= 0x1F)	goto yy3;
			if(yych <= '(')	goto yy509;
			goto yy510;
		} else {
			if(yych == '/')	goto yy3;
			goto yy509;
		}
	} else {
		if(yych <= 'I'){
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy50;
			goto yy775;
		} else {
			if(yych <= 'Z')	goto yy50;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy53;
			goto yy3;
		}
	}
yy17:
	YYDEBUG(17, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= '@'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= 'A')	goto yy758;
			if(yych <= 'T')	goto yy50;
			goto yy757;
		}
	} else {
		if(yych <= 'a'){
			if(yych <= 'Z')	goto yy50;
			if(yych <= '`')	goto yy3;
			goto yy767;
		} else {
			if(yych == 'u')	goto yy766;
			if(yych <= 'z')	goto yy53;
			goto yy3;
		}
	}
yy18:
	YYDEBUG(18, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= '@'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= 'A')	goto yy758;
			if(yych <= 'T')	goto yy50;
			goto yy757;
		}
	} else {
		if(yych <= 'a'){
			if(yych <= 'Z')	goto yy50;
			if(yych <= '`')	goto yy3;
			goto yy758;
		} else {
			if(yych == 'u')	goto yy757;
			if(yych <= 'z')	goto yy50;
			goto yy3;
		}
	}
yy19:
	YYDEBUG(19, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= 'E'){
			if(yych <= ')'){
				if(yych <= '(')	goto yy3;
				goto yy49;
			} else {
				if(yych <= '@')	goto yy3;
				if(yych <= 'D')	goto yy50;
				goto yy721;
			}
		} else {
			if(yych <= 'N'){
				if(yych == 'I')	goto yy722;
				goto yy50;
			} else {
				if(yych <= 'O')	goto yy723;
				if(yych <= 'Q')	goto yy50;
				goto yy724;
			}
		}
	} else {
		if(yych <= 'i'){
			if(yych <= 'd'){
				if(yych <= 'Z')	goto yy50;
				if(yych <= '`')	goto yy3;
				goto yy53;
			} else {
				if(yych <= 'e')	goto yy739;
				if(yych <= 'h')	goto yy53;
				goto yy740;
			}
		} else {
			if(yych <= 'q'){
				if(yych == 'o')	goto yy741;
				goto yy53;
			} else {
				if(yych <= 'r')	goto yy742;
				if(yych <= 'z')	goto yy53;
				goto yy3;
			}
		}
	}
yy20:
	YYDEBUG(20, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= 'E'){
			if(yych <= ')'){
				if(yych <= '(')	goto yy3;
				goto yy49;
			} else {
				if(yych <= '@')	goto yy3;
				if(yych <= 'D')	goto yy50;
				goto yy721;
			}
		} else {
			if(yych <= 'N'){
				if(yych == 'I')	goto yy722;
				goto yy50;
			} else {
				if(yych <= 'O')	goto yy723;
				if(yych <= 'Q')	goto yy50;
				goto yy724;
			}
		}
	} else {
		if(yych <= 'i'){
			if(yych <= 'd'){
				if(yych <= 'Z')	goto yy50;
				if(yych <= '`')	goto yy3;
				goto yy50;
			} else {
				if(yych <= 'e')	goto yy721;
				if(yych <= 'h')	goto yy50;
				goto yy722;
			}
		} else {
			if(yych <= 'q'){
				if(yych == 'o')	goto yy723;
				goto yy50;
			} else {
				if(yych <= 'r')	goto yy724;
				if(yych <= 'z')	goto yy50;
				goto yy3;
			}
		}
	}
yy21:
	YYDEBUG(21, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= '@'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= 'A')	goto yy705;
			if(yych <= 'N')	goto yy50;
			goto yy708;
		}
	} else {
		if(yych <= 'a'){
			if(yych <= 'Z')	goto yy50;
			if(yych <= '`')	goto yy3;
			goto yy706;
		} else {
			if(yych == 'o')	goto yy707;
			if(yych <= 'z')	goto yy53;
			goto yy3;
		}
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'F'){
			if(yych == ')')	goto yy49;
			if(yych <= '@')	goto yy3;
			goto yy50;
		} else {
			if(yych <= 'O'){
				if(yych <= 'G')	goto yy688;
				goto yy50;
			} else {
				if(yych <= 'P')	goto yy687;
				if(yych <= 'T')	goto yy50;
				goto yy686;
			}
		}
	} else {
		if(yych <= 'o'){
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy50;
				goto yy3;
			} else {
				if(yych == 'g')	goto yy698;
				goto yy53;
			}
		} else {
			if(yych <= 't'){
				if(yych <= 'p')	goto yy697;
				goto yy53;
			} else {
				if(yych <= 'u')	goto yy696;
				if(yych <= 'z')	goto yy53;
				goto yy3;
			}
		}
	}
yy23:
	YYDEBUG(23, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'F'){
			if(yych == ')')	goto yy49;
			if(yych <= '@')	goto yy3;
			goto yy50;
		} else {
			if(yych <= 'O'){
				if(yych <= 'G')	goto yy688;
				goto yy50;
			} else {
				if(yych <= 'P')	goto yy687;
				if(yych <= 'T')	goto yy50;
				goto yy686;
			}
		}
	} else {
		if(yych <= 'o'){
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy50;
				goto yy3;
			} else {
				if(yych == 'g')	goto yy688;
				goto yy50;
			}
		} else {
			if(yych <= 't'){
				if(yych <= 'p')	goto yy687;
				goto yy50;
			} else {
				if(yych <= 'u')	goto yy686;
				if(yych <= 'z')	goto yy50;
				goto yy3;
			}
		}
	}
yy24:
	YYDEBUG(24, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'D'){
			if(yych <= ')'){
				if(yych <= '(')	goto yy3;
				goto yy49;
			} else {
				if(yych <= '@')	goto yy3;
				if(yych <= 'A')	goto yy639;
				goto yy50;
			}
		} else {
			if(yych <= 'H'){
				if(yych <= 'E')	goto yy638;
				goto yy50;
			} else {
				if(yych <= 'I')	goto yy640;
				if(yych <= 'T')	goto yy50;
				goto yy641;
			}
		}
	} else {
		if(yych <= 'e'){
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy50;
				goto yy3;
			} else {
				if(yych <= 'a')	goto yy663;
				if(yych <= 'd')	goto yy53;
				goto yy662;
			}
		} else {
			if(yych <= 't'){
				if(yych == 'i')	goto yy664;
				goto yy53;
			} else {
				if(yych <= 'u')	goto yy665;
				if(yych <= 'z')	goto yy53;
				goto yy3;
			}
		}
	}
yy25:
	YYDEBUG(25, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'D'){
			if(yych <= ')'){
				if(yych <= '(')	goto yy3;
				goto yy49;
			} else {
				if(yych <= '@')	goto yy3;
				if(yych <= 'A')	goto yy639;
				goto yy50;
			}
		} else {
			if(yych <= 'H'){
				if(yych <= 'E')	goto yy638;
				goto yy50;
			} else {
				if(yych <= 'I')	goto yy640;
				if(yych <= 'T')	goto yy50;
				goto yy641;
			}
		}
	} else {
		if(yych <= 'e'){
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy50;
				goto yy3;
			} else {
				if(yych <= 'a')	goto yy639;
				if(yych <= 'd')	goto yy50;
				goto yy638;
			}
		} else {
			if(yych <= 't'){
				if(yych == 'i')	goto yy640;
				goto yy50;
			} else {
				if(yych <= 'u')	goto yy641;
				if(yych <= 'z')	goto yy50;
				goto yy3;
			}
		}
	}
yy26:
	YYDEBUG(26, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'C'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'B')	goto yy50;
			goto yy628;
		}
	} else {
		if(yych <= 'b'){
			if(yych <= 'Z')	goto yy50;
			if(yych <= '`')	goto yy3;
			goto yy53;
		} else {
			if(yych <= 'c')	goto yy633;
			if(yych <= 'z')	goto yy53;
			goto yy3;
		}
	}
yy27:
	YYDEBUG(27, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'C'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'B')	goto yy50;
			goto yy628;
		}
	} else {
		if(yych <= 'b'){
			if(yych <= 'Z')	goto yy50;
			if(yych <= '`')	goto yy3;
			goto yy50;
		} else {
			if(yych <= 'c')	goto yy628;
			if(yych <= 'z')	goto yy50;
			goto yy3;
		}
	}
yy28:
	YYDEBUG(28, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'D'){
			if(yych == ')')	goto yy49;
			if(yych <= '@')	goto yy3;
			goto yy50;
		} else {
			if(yych <= 'H'){
				if(yych <= 'E')	goto yy610;
				goto yy50;
			} else {
				if(yych <= 'I')	goto yy611;
				if(yych <= 'N')	goto yy50;
				goto yy606;
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy50;
				goto yy3;
			} else {
				if(yych == 'e')	goto yy608;
				goto yy53;
			}
		} else {
			if(yych <= 'n'){
				if(yych <= 'i')	goto yy609;
				goto yy53;
			} else {
				if(yych <= 'o')	goto yy607;
				if(yych <= 'z')	goto yy53;
				goto yy3;
			}
		}
	}
yy29:
	YYDEBUG(29, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy50;
			goto yy506;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy50;
			if(yych <= '`')	goto yy3;
			goto yy53;
		} else {
			if(yych <= 'e')	goto yy599;
			if(yych <= 'z')	goto yy53;
			goto yy3;
		}
	}
yy30:
	YYDEBUG(30, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy50;
			goto yy506;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy50;
			if(yych <= '`')	goto yy3;
			goto yy50;
		} else {
			if(yych <= 'e')	goto yy506;
			if(yych <= 'z')	goto yy50;
			goto yy3;
		}
	}
yy31:
	YYDEBUG(31, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'E'){
			if(yych <= ')'){
				if(yych <= '(')	goto yy3;
				goto yy49;
			} else {
				if(yych <= '@')	goto yy3;
				if(yych <= 'D')	goto yy50;
				goto yy472;
			}
		} else {
			if(yych <= 'T'){
				if(yych == 'H')	goto yy473;
				goto yy50;
			} else {
				if(yych <= 'U')	goto yy474;
				if(yych <= 'V')	goto yy50;
				goto yy475;
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'd'){
				if(yych <= 'Z')	goto yy50;
				if(yych <= '`')	goto yy3;
				goto yy53;
			} else {
				if(yych <= 'e')	goto yy468;
				if(yych <= 'g')	goto yy53;
				goto yy469;
			}
		} else {
			if(yych <= 'v'){
				if(yych == 'u')	goto yy470;
				goto yy53;
			} else {
				if(yych <= 'w')	goto yy471;
				if(yych <= 'z')	goto yy53;
				goto yy3;
			}
		}
	}
yy32:
	YYDEBUG(32, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych <= '@'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych == 'I')	goto yy456;
			if(yych <= 'K')	goto yy50;
			goto yy457;
		}
	} else {
		if(yych <= 'i'){
			if(yych <= 'Z')	goto yy50;
			if(yych <= '`')	goto yy3;
			if(yych <= 'h')	goto yy53;
			goto yy462;
		} else {
			if(yych == 'l')	goto yy463;
			if(yych <= 'z')	goto yy53;
			goto yy3;
		}
	}
yy33:
	YYDEBUG(33, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych <= '@'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych == 'I')	goto yy456;
			if(yych <= 'K')	goto yy50;
			goto yy457;
		}
	} else {
		if(yych <= 'i'){
			if(yych <= 'Z')	goto yy50;
			if(yych <= '`')	goto yy3;
			if(yych <= 'h')	goto yy50;
			goto yy456;
		} else {
			if(yych == 'l')	goto yy457;
			if(yych <= 'z')	goto yy50;
			goto yy3;
		}
	}
yy34:
	YYDEBUG(34, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'A'){
		if(yych == ')')	goto yy49;
		if(yych <= '@')	goto yy3;
		goto yy450;
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy50;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy453;
			if(yych <= 'z')	goto yy53;
			goto yy3;
		}
	}
yy35:
	YYDEBUG(35, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'A'){
		if(yych == ')')	goto yy49;
		if(yych <= '@')	goto yy3;
		goto yy450;
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy50;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy450;
			if(yych <= 'z')	goto yy50;
			goto yy3;
		}
	}
yy36:
	YYDEBUG(36, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy50;
			goto yy170;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy50;
			if(yych <= '`')	goto yy3;
			goto yy53;
		} else {
			if(yych <= 'r')	goto yy311;
			if(yych <= 'z')	goto yy53;
			goto yy3;
		}
	}
yy37:
	YYDEBUG(37, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy50;
			goto yy170;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy50;
			if(yych <= '`')	goto yy3;
			goto yy50;
		} else {
			if(yych <= 'r')	goto yy170;
			if(yych <= 'z')	goto yy50;
			goto yy3;
		}
	}
yy38:
	YYDEBUG(38, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy50;
			goto yy152;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy50;
			if(yych <= '`')	goto yy3;
			goto yy53;
		} else {
			if(yych <= 'e')	goto yy162;
			if(yych <= 'z')	goto yy53;
			goto yy3;
		}
	}
yy39:
	YYDEBUG(39, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy50;
			goto yy152;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy50;
			if(yych <= '`')	goto yy3;
			goto yy50;
		} else {
			if(yych <= 'e')	goto yy152;
			if(yych <= 'z')	goto yy50;
			goto yy3;
		}
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy8;
	if(yych <= '1')	goto yy64;
	if(yych <= '2')	goto yy65;
	if(yych <= '9')	goto yy66;
	goto yy8;
yy41:
	YYDEBUG(41, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@')	goto yy8;
	if(yych <= 'Z')	goto yy63;
	if(yych <= '`')	goto yy8;
	if(yych <= 'z')	goto yy63;
	goto yy8;
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'Z')	goto yy50;
		if(yych <= '`')	goto yy3;
		if(yych <= 'z')	goto yy53;
		goto yy3;
	}
yy43:
	YYDEBUG(43, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'Z')	goto yy50;
		if(yych <= '`')	goto yy3;
		if(yych <= 'z')	goto yy50;
		goto yy3;
	}
yy44:
	YYDEBUG(44, *YYCURSOR);
	++YYCURSOR;
	goto yy45;
yy45:
	YYDEBUG(45, *YYCURSOR);

{
		goto std;
	}
yy46:
	YYDEBUG(46, *YYCURSOR);
	++YYCURSOR;
	goto yy47;
yy47:
	YYDEBUG(47, *YYCURSOR);

{
		s->pos = cursor; s->line++;
		goto std;
	}
yy48:
	YYDEBUG(48, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy8;
yy49:
	YYDEBUG(49, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy3;
yy50:
	YYDEBUG(50, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'Z')	goto yy51;
		if(yych <= '`')	goto yy3;
		if(yych >= '{')	goto yy3;
		goto yy51;
	}
yy51:
	YYDEBUG(51, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'Z')	goto yy52;
		if(yych <= '`')	goto yy3;
		if(yych >= '{')	goto yy3;
		goto yy52;
	}
yy52:
	YYDEBUG(52, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == ')')	goto yy49;
	goto yy3;
yy53:
	YYDEBUG(53, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych == '/')	goto yy55;
			goto yy3;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '^')	goto yy3;
			goto yy55;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych >= '{')	goto yy3;
			goto yy54;
		}
	}
yy54:
	YYDEBUG(54, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych != '/')	goto yy3;
			goto yy55;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '^')	goto yy3;
			goto yy55;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy60;
			goto yy3;
		}
	}
yy55:
	YYDEBUG(55, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '@')	goto yy56;
	if(yych <= 'Z')	goto yy57;
	goto yy56;
yy56:
	YYDEBUG(56, *YYCURSOR);
	YYCURSOR = YYMARKER;
	switch(yyaccept){
	case 11:	goto yy808;
	case 20:	goto yy1275;
	case 21:	goto yy1283;
	case 12:	goto yy953;
	case 18:	goto yy1182;
	case 8:	goto yy568;
	case 17:	goto yy1047;
	case 6:	goto yy513;
	case 10:	goto yy794;
	case 16:	goto yy1080;
	case 19:	goto yy1091;
	case 15:	goto yy1073;
	case 13:	goto yy986;
	case 14:	goto yy1038;
	case 9:	goto yy690;
	case 5:	goto yy193;
	case 4:	goto yy161;
	case 3:	goto yy154;
	case 1:	goto yy3;
	case 7:	goto yy531;
	case 2:	goto yy88;
	case 0:	goto yy8;
	}
yy57:
	YYDEBUG(57, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yybm[0+yych] & 8) {
		goto yy58;
	}
	goto yy56;
yy58:
	YYDEBUG(58, *YYCURSOR);
	yyaccept = 1;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy59;
yy59:
	YYDEBUG(59, *YYCURSOR);
	if(yybm[0+yych] & 8) {
		goto yy58;
	}
	if(yych == '/')	goto yy55;
	if(yych == '_')	goto yy55;
	goto yy3;
yy60:
	YYDEBUG(60, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == ')')	goto yy49;
		if(yych <= '.')	goto yy3;
		goto yy55;
	} else {
		if(yych <= '_'){
			if(yych <= '^')	goto yy3;
			goto yy55;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych >= '{')	goto yy3;
			goto yy61;
		}
	}
yy61:
	YYDEBUG(61, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy62;
yy62:
	YYDEBUG(62, *YYCURSOR);
	if(yych <= '^'){
		if(yych == '/')	goto yy55;
		goto yy56;
	} else {
		if(yych <= '_')	goto yy55;
		if(yych <= '`')	goto yy56;
		if(yych <= 'z')	goto yy61;
		goto yy56;
	}
yy63:
	YYDEBUG(63, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'Z')	goto yy50;
		if(yych <= '`')	goto yy3;
		if(yych <= 'z')	goto yy50;
		goto yy3;
	}
yy64:
	YYDEBUG(64, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy70;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy150;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy66;
	case ':':	goto yy67;
	default:	goto yy3;
	}
yy65:
	YYDEBUG(65, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy70;
	case '0':
	case '1':
	case '2':
	case '3':	goto yy150;
	case '4':
	case '5':	goto yy68;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy79;
	case ':':	goto yy67;
	default:	goto yy3;
	}
yy66:
	YYDEBUG(66, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy70;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy68;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy79;
	case ':':	goto yy67;
	default:	goto yy3;
	}
yy67:
	YYDEBUG(67, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/')	goto yy3;
	if(yych <= '5')	goto yy149;
	goto yy3;
yy68:
	YYDEBUG(68, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy70;
	if(yych <= '9')	goto yy148;
	goto yy70;
yy69:
	YYDEBUG(69, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy70;
yy70:
	YYDEBUG(70, *YYCURSOR);
	if(yybm[0+yych] & 16) {
		goto yy69;
	}
	YYDEBUG(-1, yych);
	switch(yych){
	case 'D':	case 'd':	goto yy74;
	case 'F':	case 'f':	goto yy76;
	case 'H':	case 'h':	goto yy73;
	case 'M':	case 'm':	goto yy72;
	case 'S':	case 's':	goto yy71;
	case 'T':	case 't':	goto yy78;
	case 'W':	case 'w':	goto yy75;
	case 'Y':	case 'y':	goto yy77;
	default:	goto yy56;
	}
yy71:
	YYDEBUG(71, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'D'){
			if(yych == 'A')	goto yy134;
			goto yy56;
		} else {
			if(yych <= 'E')	goto yy136;
			if(yych <= 'T')	goto yy56;
			goto yy135;
		}
	} else {
		if(yych <= 'd'){
			if(yych == 'a')	goto yy134;
			goto yy56;
		} else {
			if(yych <= 'e')	goto yy136;
			if(yych == 'u')	goto yy135;
			goto yy56;
		}
	}
yy72:
	YYDEBUG(72, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'O'){
		if(yych == 'I')	goto yy126;
		if(yych <= 'N')	goto yy56;
		goto yy125;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy56;
			goto yy126;
		} else {
			if(yych == 'o')	goto yy125;
			goto yy56;
		}
	}
yy73:
	YYDEBUG(73, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'O')	goto yy123;
	if(yych == 'o')	goto yy123;
	goto yy56;
yy74:
	YYDEBUG(74, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'A')	goto yy122;
	if(yych == 'a')	goto yy122;
	goto yy56;
yy75:
	YYDEBUG(75, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'E')	goto yy114;
	if(yych == 'e')	goto yy114;
	goto yy56;
yy76:
	YYDEBUG(76, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'R'){
		if(yych == 'O')	goto yy99;
		if(yych <= 'Q')	goto yy56;
		goto yy98;
	} else {
		if(yych <= 'o'){
			if(yych <= 'n')	goto yy56;
			goto yy99;
		} else {
			if(yych == 'r')	goto yy98;
			goto yy56;
		}
	}
yy77:
	YYDEBUG(77, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'E')	goto yy95;
	if(yych == 'e')	goto yy95;
	goto yy56;
yy78:
	YYDEBUG(78, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'H')	goto yy81;
		if(yych <= 'T')	goto yy56;
		goto yy82;
	} else {
		if(yych <= 'h'){
			if(yych <= 'g')	goto yy56;
			goto yy81;
		} else {
			if(yych == 'u')	goto yy82;
			goto yy56;
		}
	}
yy79:
	YYDEBUG(79, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy80;
yy80:
	YYDEBUG(80, *YYCURSOR);
	if(yybm[0+yych] & 16) {
		goto yy69;
	}
	YYDEBUG(-1, yych);
	switch(yych){
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy79;
	case 'D':	case 'd':	goto yy74;
	case 'F':	case 'f':	goto yy76;
	case 'H':	case 'h':	goto yy73;
	case 'M':	case 'm':	goto yy72;
	case 'S':	case 's':	goto yy71;
	case 'T':	case 't':	goto yy78;
	case 'W':	case 'w':	goto yy75;
	case 'Y':	case 'y':	goto yy77;
	default:	goto yy56;
	}
yy81:
	YYDEBUG(81, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'U')	goto yy90;
	if(yych == 'u')	goto yy90;
	goto yy56;
yy82:
	YYDEBUG(82, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'E')	goto yy83;
	if(yych != 'e')	goto yy56;
	goto yy83;
yy83:
	YYDEBUG(83, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'S')	goto yy84;
	if(yych != 's')	goto yy56;
	goto yy84;
yy84:
	YYDEBUG(84, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'D')	goto yy85;
	if(yych != 'd')	goto yy56;
	goto yy85;
yy85:
	YYDEBUG(85, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'A')	goto yy86;
	if(yych != 'a')	goto yy56;
	goto yy86;
yy86:
	YYDEBUG(86, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'Y')	goto yy87;
	if(yych != 'y')	goto yy56;
	goto yy87;
yy87:
	YYDEBUG(87, *YYCURSOR);
	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yybm[0+yych] & 32) {
		goto yy79;
	}
	if(yych == '+')	goto yy89;
	if(yych == '-')	goto yy89;
	goto yy88;
yy88:
	YYDEBUG(88, *YYCURSOR);

{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 0, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy89:
	YYDEBUG(89, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yybm[0+yych] & 32) {
		goto yy79;
	}
	goto yy56;
yy90:
	YYDEBUG(90, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'R')	goto yy91;
	if(yych != 'r')	goto yy56;
	goto yy91;
yy91:
	YYDEBUG(91, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'S')	goto yy92;
	if(yych != 's')	goto yy56;
	goto yy92;
yy92:
	YYDEBUG(92, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'D')	goto yy93;
	if(yych != 'd')	goto yy56;
	goto yy93;
yy93:
	YYDEBUG(93, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'A')	goto yy94;
	if(yych != 'a')	goto yy56;
	goto yy94;
yy94:
	YYDEBUG(94, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'Y')	goto yy87;
	if(yych == 'y')	goto yy87;
	goto yy56;
yy95:
	YYDEBUG(95, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'A')	goto yy96;
	if(yych != 'a')	goto yy56;
	goto yy96;
yy96:
	YYDEBUG(96, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'R')	goto yy97;
	if(yych != 'r')	goto yy56;
	goto yy97;
yy97:
	YYDEBUG(97, *YYCURSOR);
	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yybm[0+yych] & 32) {
		goto yy79;
	}
	if(yych <= '-'){
		if(yych == '+')	goto yy89;
		if(yych <= ',')	goto yy88;
		goto yy89;
	} else {
		if(yych <= 'S'){
			if(yych <= 'R')	goto yy88;
			goto yy87;
		} else {
			if(yych == 's')	goto yy87;
			goto yy88;
		}
	}
yy98:
	YYDEBUG(98, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'I')	goto yy111;
	if(yych == 'i')	goto yy111;
	goto yy56;
yy99:
	YYDEBUG(99, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'R')	goto yy100;
	if(yych != 'r')	goto yy56;
	goto yy100;
yy100:
	YYDEBUG(100, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy101;
	if(yych != 't')	goto yy56;
	goto yy101;
yy101:
	YYDEBUG(101, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'H')	goto yy103;
		if(yych <= 'M')	goto yy56;
		goto yy102;
	} else {
		if(yych <= 'h'){
			if(yych <= 'g')	goto yy56;
			goto yy103;
		} else {
			if(yych != 'n')	goto yy56;
			goto yy102;
		}
	}
yy102:
	YYDEBUG(102, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'I')	goto yy108;
	if(yych == 'i')	goto yy108;
	goto yy56;
yy103:
	YYDEBUG(103, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'N')	goto yy104;
	if(yych != 'n')	goto yy56;
	goto yy104;
yy104:
	YYDEBUG(104, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'I')	goto yy105;
	if(yych != 'i')	goto yy56;
	goto yy105;
yy105:
	YYDEBUG(105, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'G')	goto yy106;
	if(yych != 'g')	goto yy56;
	goto yy106;
yy106:
	YYDEBUG(106, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'H')	goto yy107;
	if(yych != 'h')	goto yy56;
	goto yy107;
yy107:
	YYDEBUG(107, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy97;
	if(yych == 't')	goto yy97;
	goto yy56;
yy108:
	YYDEBUG(108, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'G')	goto yy109;
	if(yych != 'g')	goto yy56;
	goto yy109;
yy109:
	YYDEBUG(109, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'H')	goto yy110;
	if(yych != 'h')	goto yy56;
	goto yy110;
yy110:
	YYDEBUG(110, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy97;
	if(yych == 't')	goto yy97;
	goto yy56;
yy111:
	YYDEBUG(111, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'D')	goto yy112;
	if(yych != 'd')	goto yy56;
	goto yy112;
yy112:
	YYDEBUG(112, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'A')	goto yy113;
	if(yych != 'a')	goto yy56;
	goto yy113;
yy113:
	YYDEBUG(113, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'Y')	goto yy87;
	if(yych == 'y')	goto yy87;
	goto yy56;
yy114:
	YYDEBUG(114, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'E'){
		if(yych <= 'C')	goto yy56;
		if(yych <= 'D')	goto yy116;
		goto yy115;
	} else {
		if(yych <= 'c')	goto yy56;
		if(yych <= 'd')	goto yy116;
		if(yych >= 'f')	goto yy56;
		goto yy115;
	}
yy115:
	YYDEBUG(115, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'K')	goto yy97;
	if(yych == 'k')	goto yy97;
	goto yy56;
yy116:
	YYDEBUG(116, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'N')	goto yy117;
	if(yych != 'n')	goto yy56;
	goto yy117;
yy117:
	YYDEBUG(117, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'E')	goto yy118;
	if(yych != 'e')	goto yy56;
	goto yy118;
yy118:
	YYDEBUG(118, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'S')	goto yy119;
	if(yych != 's')	goto yy56;
	goto yy119;
yy119:
	YYDEBUG(119, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'D')	goto yy120;
	if(yych != 'd')	goto yy56;
	goto yy120;
yy120:
	YYDEBUG(120, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'A')	goto yy121;
	if(yych != 'a')	goto yy56;
	goto yy121;
yy121:
	YYDEBUG(121, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'Y')	goto yy87;
	if(yych == 'y')	goto yy87;
	goto yy56;
yy122:
	YYDEBUG(122, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'Y')	goto yy97;
	if(yych == 'y')	goto yy97;
	goto yy56;
yy123:
	YYDEBUG(123, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'U')	goto yy124;
	if(yych != 'u')	goto yy56;
	goto yy124;
yy124:
	YYDEBUG(124, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'R')	goto yy97;
	if(yych == 'r')	goto yy97;
	goto yy56;
yy125:
	YYDEBUG(125, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'N')	goto yy130;
	if(yych == 'n')	goto yy130;
	goto yy56;
yy126:
	YYDEBUG(126, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'N')	goto yy127;
	if(yych != 'n')	goto yy56;
	goto yy127;
yy127:
	YYDEBUG(127, *YYCURSOR);
	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yybm[0+yych] & 32) {
		goto yy79;
	}
	if(yych <= 'S'){
		if(yych <= ','){
			if(yych == '+')	goto yy89;
			goto yy88;
		} else {
			if(yych <= '-')	goto yy89;
			if(yych <= 'R')	goto yy88;
			goto yy87;
		}
	} else {
		if(yych <= 'r'){
			if(yych != 'U')	goto yy88;
			goto yy128;
		} else {
			if(yych <= 's')	goto yy87;
			if(yych != 'u')	goto yy88;
			goto yy128;
		}
	}
yy128:
	YYDEBUG(128, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy129;
	if(yych != 't')	goto yy56;
	goto yy129;
yy129:
	YYDEBUG(129, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'E')	goto yy97;
	if(yych == 'e')	goto yy97;
	goto yy56;
yy130:
	YYDEBUG(130, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'T'){
		if(yych == 'D')	goto yy131;
		if(yych <= 'S')	goto yy56;
		goto yy132;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy56;
			goto yy131;
		} else {
			if(yych == 't')	goto yy132;
			goto yy56;
		}
	}
yy131:
	YYDEBUG(131, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'A')	goto yy133;
	if(yych == 'a')	goto yy133;
	goto yy56;
yy132:
	YYDEBUG(132, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'H')	goto yy97;
	if(yych == 'h')	goto yy97;
	goto yy56;
yy133:
	YYDEBUG(133, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'Y')	goto yy87;
	if(yych == 'y')	goto yy87;
	goto yy56;
yy134:
	YYDEBUG(134, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy143;
	if(yych == 't')	goto yy143;
	goto yy56;
yy135:
	YYDEBUG(135, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'N')	goto yy140;
	if(yych == 'n')	goto yy140;
	goto yy56;
yy136:
	YYDEBUG(136, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'C')	goto yy137;
	if(yych != 'c')	goto yy56;
	goto yy137;
yy137:
	YYDEBUG(137, *YYCURSOR);
	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yybm[0+yych] & 32) {
		goto yy79;
	}
	if(yych <= 'O'){
		if(yych <= ','){
			if(yych == '+')	goto yy89;
			goto yy88;
		} else {
			if(yych <= '-')	goto yy89;
			if(yych <= 'N')	goto yy88;
			goto yy138;
		}
	} else {
		if(yych <= 'n'){
			if(yych == 'S')	goto yy87;
			goto yy88;
		} else {
			if(yych <= 'o')	goto yy138;
			if(yych == 's')	goto yy87;
			goto yy88;
		}
	}
yy138:
	YYDEBUG(138, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'N')	goto yy139;
	if(yych != 'n')	goto yy56;
	goto yy139;
yy139:
	YYDEBUG(139, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'D')	goto yy97;
	if(yych == 'd')	goto yy97;
	goto yy56;
yy140:
	YYDEBUG(140, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'D')	goto yy141;
	if(yych != 'd')	goto yy56;
	goto yy141;
yy141:
	YYDEBUG(141, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'A')	goto yy142;
	if(yych != 'a')	goto yy56;
	goto yy142;
yy142:
	YYDEBUG(142, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'Y')	goto yy87;
	if(yych == 'y')	goto yy87;
	goto yy56;
yy143:
	YYDEBUG(143, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'U')	goto yy144;
	if(yych != 'u')	goto yy56;
	goto yy144;
yy144:
	YYDEBUG(144, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'R')	goto yy145;
	if(yych != 'r')	goto yy56;
	goto yy145;
yy145:
	YYDEBUG(145, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'D')	goto yy146;
	if(yych != 'd')	goto yy56;
	goto yy146;
yy146:
	YYDEBUG(146, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'A')	goto yy147;
	if(yych != 'a')	goto yy56;
	goto yy147;
yy147:
	YYDEBUG(147, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'Y')	goto yy87;
	if(yych == 'y')	goto yy87;
	goto yy56;
yy148:
	YYDEBUG(148, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 32) {
		goto yy79;
	}
	if(yych <= 'X'){
		if(yych <= 'G'){
			if(yych <= 'C'){
				if(yych == ' ')	goto yy70;
				goto yy3;
			} else {
				if(yych == 'E')	goto yy3;
				if(yych <= 'F')	goto yy70;
				goto yy3;
			}
		} else {
			if(yych <= 'R'){
				if(yych <= 'H')	goto yy70;
				if(yych == 'M')	goto yy70;
				goto yy3;
			} else {
				if(yych <= 'T')	goto yy70;
				if(yych == 'W')	goto yy70;
				goto yy3;
			}
		}
	} else {
		if(yych <= 'l'){
			if(yych <= 'e'){
				if(yych <= 'Y')	goto yy70;
				if(yych == 'd')	goto yy70;
				goto yy3;
			} else {
				if(yych == 'g')	goto yy3;
				if(yych <= 'h')	goto yy70;
				goto yy3;
			}
		} else {
			if(yych <= 'v'){
				if(yych <= 'm')	goto yy70;
				if(yych <= 'r')	goto yy3;
				if(yych <= 't')	goto yy70;
				goto yy3;
			} else {
				if(yych == 'x')	goto yy3;
				if(yych <= 'y')	goto yy70;
				goto yy3;
			}
		}
	}
yy149:
	YYDEBUG(149, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '9')	goto yy49;
	goto yy56;
yy150:
	YYDEBUG(150, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy70;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':	goto yy151;
	case '6':
	case '7':
	case '8':
	case '9':	goto yy148;
	case ':':	goto yy67;
	default:	goto yy3;
	}
yy151:
	YYDEBUG(151, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy70;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy148;
	default:	goto yy3;
	}
yy152:
	YYDEBUG(152, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'C')	goto yy51;
			goto yy153;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'd')	goto yy153;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy153:
	YYDEBUG(153, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= 'N'){
		if(yych <= ')'){
			if(yych >= ')')	goto yy49;
			goto yy154;
		} else {
			if(yych <= '@')	goto yy154;
			if(yych <= 'M')	goto yy52;
			goto yy155;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy52;
			if(yych >= 'a')	goto yy52;
			goto yy154;
		} else {
			if(yych <= 'n')	goto yy155;
			if(yych <= 'z')	goto yy52;
			goto yy154;
		}
	}
yy154:
	YYDEBUG(154, *YYCURSOR);

{
		DEBUG_OUTPUT("dayabbr");
		goto std;
	}
yy155:
	YYDEBUG(155, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'E')	goto yy156;
		if(yych != 'e')	goto yy3;
		goto yy156;
	}
yy156:
	YYDEBUG(156, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy157;
	if(yych != 's')	goto yy56;
	goto yy157;
yy157:
	YYDEBUG(157, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy158;
	if(yych != 'd')	goto yy56;
	goto yy158;
yy158:
	YYDEBUG(158, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy159;
	if(yych != 'a')	goto yy56;
	goto yy159;
yy159:
	YYDEBUG(159, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy160;
	if(yych != 'y')	goto yy56;
	goto yy160;
yy160:
	YYDEBUG(160, *YYCURSOR);
	++YYCURSOR;
	goto yy161;
yy161:
	YYDEBUG(161, *YYCURSOR);

{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("dayfull");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		s->time->relative.weekday_behavior = 1;
		
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy162:
	YYDEBUG(162, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'C')	goto yy51;
			goto yy153;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'd')	goto yy163;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy163:
	YYDEBUG(163, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy154;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy154;
			if(yych <= 'M')	goto yy52;
			goto yy155;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy154;
		} else {
			if(yych == 'n')	goto yy164;
			if(yych <= 'z')	goto yy60;
			goto yy154;
		}
	}
yy164:
	YYDEBUG(164, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'D')	goto yy3;
			goto yy156;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy165;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy165:
	YYDEBUG(165, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy157;
	if(yych != 's')	goto yy62;
	goto yy166;
yy166:
	YYDEBUG(166, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy158;
	if(yych != 'd')	goto yy62;
	goto yy167;
yy167:
	YYDEBUG(167, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy159;
	if(yych != 'a')	goto yy62;
	goto yy168;
yy168:
	YYDEBUG(168, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy160;
	if(yych != 'y')	goto yy62;
	goto yy169;
yy169:
	YYDEBUG(169, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '^'){
		if(yych == '/')	goto yy55;
		goto yy161;
	} else {
		if(yych <= '_')	goto yy55;
		if(yych <= '`')	goto yy161;
		if(yych <= 'z')	goto yy61;
		goto yy161;
	}
yy170:
	YYDEBUG(170, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy51;
			goto yy171;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'e')	goto yy171;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy171:
	YYDEBUG(171, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'V'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'U')	goto yy52;
			goto yy172;
		}
	} else {
		if(yych <= 'u'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy3;
			goto yy52;
		} else {
			if(yych <= 'v')	goto yy172;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy172:
	YYDEBUG(172, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'I')	goto yy173;
		if(yych != 'i')	goto yy3;
		goto yy173;
	}
yy173:
	YYDEBUG(173, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'O')	goto yy174;
	if(yych != 'o')	goto yy56;
	goto yy174;
yy174:
	YYDEBUG(174, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'U')	goto yy175;
	if(yych != 'u')	goto yy56;
	goto yy175;
yy175:
	YYDEBUG(175, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'S')	goto yy176;
	if(yych != 's')	goto yy56;
	goto yy176;
yy176:
	YYDEBUG(176, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy177;
yy177:
	YYDEBUG(177, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	goto yy176;
	case 'D':	case 'd':	goto yy181;
	case 'F':	case 'f':	goto yy183;
	case 'H':	case 'h':	goto yy180;
	case 'M':	case 'm':	goto yy179;
	case 'S':	case 's':	goto yy178;
	case 'T':	case 't':	goto yy185;
	case 'W':	case 'w':	goto yy182;
	case 'Y':	case 'y':	goto yy184;
	default:	goto yy56;
	}
yy178:
	YYDEBUG(178, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'D'){
			if(yych == 'A')	goto yy297;
			goto yy56;
		} else {
			if(yych <= 'E')	goto yy299;
			if(yych <= 'T')	goto yy56;
			goto yy298;
		}
	} else {
		if(yych <= 'd'){
			if(yych == 'a')	goto yy297;
			goto yy56;
		} else {
			if(yych <= 'e')	goto yy299;
			if(yych == 'u')	goto yy298;
			goto yy56;
		}
	}
yy179:
	YYDEBUG(179, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'O'){
		if(yych == 'I')	goto yy289;
		if(yych <= 'N')	goto yy56;
		goto yy288;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy56;
			goto yy289;
		} else {
			if(yych == 'o')	goto yy288;
			goto yy56;
		}
	}
yy180:
	YYDEBUG(180, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'O')	goto yy286;
	if(yych == 'o')	goto yy286;
	goto yy56;
yy181:
	YYDEBUG(181, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'A')	goto yy285;
	if(yych == 'a')	goto yy285;
	goto yy56;
yy182:
	YYDEBUG(182, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'E')	goto yy277;
	if(yych == 'e')	goto yy277;
	goto yy56;
yy183:
	YYDEBUG(183, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'R'){
		if(yych == 'O')	goto yy262;
		if(yych <= 'Q')	goto yy56;
		goto yy261;
	} else {
		if(yych <= 'o'){
			if(yych <= 'n')	goto yy56;
			goto yy262;
		} else {
			if(yych == 'r')	goto yy261;
			goto yy56;
		}
	}
yy184:
	YYDEBUG(184, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'E')	goto yy256;
	if(yych == 'e')	goto yy256;
	goto yy56;
yy185:
	YYDEBUG(185, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'H')	goto yy186;
		if(yych <= 'T')	goto yy56;
		goto yy187;
	} else {
		if(yych <= 'h'){
			if(yych <= 'g')	goto yy56;
			goto yy186;
		} else {
			if(yych == 'u')	goto yy187;
			goto yy56;
		}
	}
yy186:
	YYDEBUG(186, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'U')	goto yy251;
	if(yych == 'u')	goto yy251;
	goto yy56;
yy187:
	YYDEBUG(187, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'E')	goto yy188;
	if(yych != 'e')	goto yy56;
	goto yy188;
yy188:
	YYDEBUG(188, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'S')	goto yy189;
	if(yych != 's')	goto yy56;
	goto yy189;
yy189:
	YYDEBUG(189, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'D')	goto yy190;
	if(yych != 'd')	goto yy56;
	goto yy190;
yy190:
	YYDEBUG(190, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'A')	goto yy191;
	if(yych != 'a')	goto yy56;
	goto yy191;
yy191:
	YYDEBUG(191, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'Y')	goto yy192;
	if(yych != 'y')	goto yy56;
	goto yy192;
yy192:
	YYDEBUG(192, *YYCURSOR);
	yyaccept = 5;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case 'E':	case 'e':	goto yy198;
	case 'F':	case 'f':	goto yy194;
	case 'L':	case 'l':	goto yy199;
	case 'N':	case 'n':	goto yy195;
	case 'P':	case 'p':	goto yy200;
	case 'S':	case 's':	goto yy196;
	case 'T':	case 't':	goto yy197;
	default:	goto yy193;
	}
yy193:
	YYDEBUG(193, *YYCURSOR);

{
		timelib_sll i;
		int         behavior;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy194:
	YYDEBUG(194, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'O'){
		if(yych == 'I')	goto yy242;
		if(yych <= 'N')	goto yy56;
		goto yy243;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy56;
			goto yy242;
		} else {
			if(yych == 'o')	goto yy243;
			goto yy56;
		}
	}
yy195:
	YYDEBUG(195, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'I'){
		if(yych == 'E')	goto yy238;
		if(yych <= 'H')	goto yy56;
		goto yy237;
	} else {
		if(yych <= 'e'){
			if(yych <= 'd')	goto yy56;
			goto yy238;
		} else {
			if(yych == 'i')	goto yy237;
			goto yy56;
		}
	}
yy196:
	YYDEBUG(196, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'I'){
		if(yych == 'E')	goto yy226;
		if(yych <= 'H')	goto yy56;
		goto yy227;
	} else {
		if(yych <= 'e'){
			if(yych <= 'd')	goto yy56;
			goto yy226;
		} else {
			if(yych == 'i')	goto yy227;
			goto yy56;
		}
	}
yy197:
	YYDEBUG(197, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'W'){
		if(yych <= 'G'){
			if(yych == 'E')	goto yy217;
			goto yy56;
		} else {
			if(yych <= 'H')	goto yy215;
			if(yych <= 'V')	goto yy56;
			goto yy216;
		}
	} else {
		if(yych <= 'g'){
			if(yych == 'e')	goto yy217;
			goto yy56;
		} else {
			if(yych <= 'h')	goto yy215;
			if(yych == 'w')	goto yy216;
			goto yy56;
		}
	}
yy198:
	YYDEBUG(198, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'L'){
		if(yych == 'I')	goto yy207;
		if(yych <= 'K')	goto yy56;
		goto yy206;
	} else {
		if(yych <= 'i'){
			if(yych <= 'h')	goto yy56;
			goto yy207;
		} else {
			if(yych == 'l')	goto yy206;
			goto yy56;
		}
	}
yy199:
	YYDEBUG(199, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'A')	goto yy204;
	if(yych == 'a')	goto yy204;
	goto yy56;
yy200:
	YYDEBUG(200, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'R')	goto yy201;
	if(yych != 'r')	goto yy56;
	goto yy201;
yy201:
	YYDEBUG(201, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'E')	goto yy202;
	if(yych != 'e')	goto yy56;
	goto yy202;
yy202:
	YYDEBUG(202, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'V')	goto yy203;
	if(yych != 'v')	goto yy56;
	goto yy203;
yy203:
	YYDEBUG(203, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'I')	goto yy173;
	if(yych == 'i')	goto yy173;
	goto yy56;
yy204:
	YYDEBUG(204, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'S')	goto yy205;
	if(yych != 's')	goto yy56;
	goto yy205;
yy205:
	YYDEBUG(205, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy176;
	if(yych == 't')	goto yy176;
	goto yy56;
yy206:
	YYDEBUG(206, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'E')	goto yy210;
	if(yych == 'e')	goto yy210;
	goto yy56;
yy207:
	YYDEBUG(207, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'G')	goto yy208;
	if(yych != 'g')	goto yy56;
	goto yy208;
yy208:
	YYDEBUG(208, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'H')	goto yy209;
	if(yych != 'h')	goto yy56;
	goto yy209;
yy209:
	YYDEBUG(209, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy176;
	if(yych == 't')	goto yy176;
	goto yy56;
yy210:
	YYDEBUG(210, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'V')	goto yy211;
	if(yych != 'v')	goto yy56;
	goto yy211;
yy211:
	YYDEBUG(211, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'E')	goto yy212;
	if(yych != 'e')	goto yy56;
	goto yy212;
yy212:
	YYDEBUG(212, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'N')	goto yy213;
	if(yych != 'n')	goto yy56;
	goto yy213;
yy213:
	YYDEBUG(213, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy214;
	if(yych != 't')	goto yy56;
	goto yy214;
yy214:
	YYDEBUG(214, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'H')	goto yy176;
	if(yych == 'h')	goto yy176;
	goto yy56;
yy215:
	YYDEBUG(215, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'I')	goto yy224;
	if(yych == 'i')	goto yy224;
	goto yy56;
yy216:
	YYDEBUG(216, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'E')	goto yy220;
	if(yych == 'e')	goto yy220;
	goto yy56;
yy217:
	YYDEBUG(217, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'N')	goto yy218;
	if(yych != 'n')	goto yy56;
	goto yy218;
yy218:
	YYDEBUG(218, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy219;
	if(yych != 't')	goto yy56;
	goto yy219;
yy219:
	YYDEBUG(219, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'H')	goto yy176;
	if(yych == 'h')	goto yy176;
	goto yy56;
yy220:
	YYDEBUG(220, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'L')	goto yy221;
	if(yych != 'l')	goto yy56;
	goto yy221;
yy221:
	YYDEBUG(221, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'F')	goto yy222;
	if(yych != 'f')	goto yy56;
	goto yy222;
yy222:
	YYDEBUG(222, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy223;
	if(yych != 't')	goto yy56;
	goto yy223;
yy223:
	YYDEBUG(223, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'H')	goto yy176;
	if(yych == 'h')	goto yy176;
	goto yy56;
yy224:
	YYDEBUG(224, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'S'){
		if(yych <= 'Q')	goto yy56;
		if(yych >= 'S')	goto yy176;
		goto yy225;
	} else {
		if(yych <= 'q')	goto yy56;
		if(yych <= 'r')	goto yy225;
		if(yych <= 's')	goto yy176;
		goto yy56;
	}
yy225:
	YYDEBUG(225, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'D')	goto yy176;
	if(yych == 'd')	goto yy176;
	goto yy56;
yy226:
	YYDEBUG(226, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'V'){
		if(yych == 'C')	goto yy230;
		if(yych <= 'U')	goto yy56;
		goto yy231;
	} else {
		if(yych <= 'c'){
			if(yych <= 'b')	goto yy56;
			goto yy230;
		} else {
			if(yych == 'v')	goto yy231;
			goto yy56;
		}
	}
yy227:
	YYDEBUG(227, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'X')	goto yy228;
	if(yych != 'x')	goto yy56;
	goto yy228;
yy228:
	YYDEBUG(228, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy229;
	if(yych != 't')	goto yy56;
	goto yy229;
yy229:
	YYDEBUG(229, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'H')	goto yy176;
	if(yych == 'h')	goto yy176;
	goto yy56;
yy230:
	YYDEBUG(230, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'O')	goto yy235;
	if(yych == 'o')	goto yy235;
	goto yy56;
yy231:
	YYDEBUG(231, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'E')	goto yy232;
	if(yych != 'e')	goto yy56;
	goto yy232;
yy232:
	YYDEBUG(232, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'N')	goto yy233;
	if(yych != 'n')	goto yy56;
	goto yy233;
yy233:
	YYDEBUG(233, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy234;
	if(yych != 't')	goto yy56;
	goto yy234;
yy234:
	YYDEBUG(234, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'H')	goto yy176;
	if(yych == 'h')	goto yy176;
	goto yy56;
yy235:
	YYDEBUG(235, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'N')	goto yy236;
	if(yych != 'n')	goto yy56;
	goto yy236;
yy236:
	YYDEBUG(236, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'D')	goto yy176;
	if(yych == 'd')	goto yy176;
	goto yy56;
yy237:
	YYDEBUG(237, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'N')	goto yy240;
	if(yych == 'n')	goto yy240;
	goto yy56;
yy238:
	YYDEBUG(238, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'X')	goto yy239;
	if(yych != 'x')	goto yy56;
	goto yy239;
yy239:
	YYDEBUG(239, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy176;
	if(yych == 't')	goto yy176;
	goto yy56;
yy240:
	YYDEBUG(240, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy241;
	if(yych != 't')	goto yy56;
	goto yy241;
yy241:
	YYDEBUG(241, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'H')	goto yy176;
	if(yych == 'h')	goto yy176;
	goto yy56;
yy242:
	YYDEBUG(242, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'R'){
		if(yych == 'F')	goto yy248;
		if(yych <= 'Q')	goto yy56;
		goto yy247;
	} else {
		if(yych <= 'f'){
			if(yych <= 'e')	goto yy56;
			goto yy248;
		} else {
			if(yych == 'r')	goto yy247;
			goto yy56;
		}
	}
yy243:
	YYDEBUG(243, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'U')	goto yy244;
	if(yych != 'u')	goto yy56;
	goto yy244;
yy244:
	YYDEBUG(244, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'R')	goto yy245;
	if(yych != 'r')	goto yy56;
	goto yy245;
yy245:
	YYDEBUG(245, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy246;
	if(yych != 't')	goto yy56;
	goto yy246;
yy246:
	YYDEBUG(246, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'H')	goto yy176;
	if(yych == 'h')	goto yy176;
	goto yy56;
yy247:
	YYDEBUG(247, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'S')	goto yy250;
	if(yych == 's')	goto yy250;
	goto yy56;
yy248:
	YYDEBUG(248, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy249;
	if(yych != 't')	goto yy56;
	goto yy249;
yy249:
	YYDEBUG(249, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'H')	goto yy176;
	if(yych == 'h')	goto yy176;
	goto yy56;
yy250:
	YYDEBUG(250, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy176;
	if(yych == 't')	goto yy176;
	goto yy56;
yy251:
	YYDEBUG(251, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'R')	goto yy252;
	if(yych != 'r')	goto yy56;
	goto yy252;
yy252:
	YYDEBUG(252, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'S')	goto yy253;
	if(yych != 's')	goto yy56;
	goto yy253;
yy253:
	YYDEBUG(253, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'D')	goto yy254;
	if(yych != 'd')	goto yy56;
	goto yy254;
yy254:
	YYDEBUG(254, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'A')	goto yy255;
	if(yych != 'a')	goto yy56;
	goto yy255;
yy255:
	YYDEBUG(255, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'Y')	goto yy192;
	if(yych == 'y')	goto yy192;
	goto yy56;
yy256:
	YYDEBUG(256, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'A')	goto yy257;
	if(yych != 'a')	goto yy56;
	goto yy257;
yy257:
	YYDEBUG(257, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'R')	goto yy258;
	if(yych != 'r')	goto yy56;
	goto yy258;
yy258:
	YYDEBUG(258, *YYCURSOR);
	yyaccept = 5;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case 'E':	case 'e':	goto yy198;
	case 'F':	case 'f':	goto yy194;
	case 'L':	case 'l':	goto yy199;
	case 'N':	case 'n':	goto yy195;
	case 'P':	case 'p':	goto yy200;
	case 'S':	case 's':	goto yy259;
	case 'T':	case 't':	goto yy197;
	default:	goto yy193;
	}
yy259:
	YYDEBUG(259, *YYCURSOR);
	yyaccept = 5;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case 'E':	case 'e':	goto yy260;
	case 'F':	case 'f':	goto yy194;
	case 'I':	case 'i':	goto yy227;
	case 'L':	case 'l':	goto yy199;
	case 'N':	case 'n':	goto yy195;
	case 'P':	case 'p':	goto yy200;
	case 'S':	case 's':	goto yy196;
	case 'T':	case 't':	goto yy197;
	default:	goto yy193;
	}
yy260:
	YYDEBUG(260, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'V'){
		if(yych <= 'I'){
			if(yych == 'C')	goto yy230;
			if(yych <= 'H')	goto yy56;
			goto yy207;
		} else {
			if(yych == 'L')	goto yy206;
			if(yych <= 'U')	goto yy56;
			goto yy231;
		}
	} else {
		if(yych <= 'i'){
			if(yych == 'c')	goto yy230;
			if(yych <= 'h')	goto yy56;
			goto yy207;
		} else {
			if(yych <= 'l'){
				if(yych <= 'k')	goto yy56;
				goto yy206;
			} else {
				if(yych == 'v')	goto yy231;
				goto yy56;
			}
		}
	}
yy261:
	YYDEBUG(261, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'I')	goto yy274;
	if(yych == 'i')	goto yy274;
	goto yy56;
yy262:
	YYDEBUG(262, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'R')	goto yy263;
	if(yych != 'r')	goto yy56;
	goto yy263;
yy263:
	YYDEBUG(263, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy264;
	if(yych != 't')	goto yy56;
	goto yy264;
yy264:
	YYDEBUG(264, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'H')	goto yy266;
		if(yych <= 'M')	goto yy56;
		goto yy265;
	} else {
		if(yych <= 'h'){
			if(yych <= 'g')	goto yy56;
			goto yy266;
		} else {
			if(yych != 'n')	goto yy56;
			goto yy265;
		}
	}
yy265:
	YYDEBUG(265, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'I')	goto yy271;
	if(yych == 'i')	goto yy271;
	goto yy56;
yy266:
	YYDEBUG(266, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'N')	goto yy267;
	if(yych != 'n')	goto yy56;
	goto yy267;
yy267:
	YYDEBUG(267, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'I')	goto yy268;
	if(yych != 'i')	goto yy56;
	goto yy268;
yy268:
	YYDEBUG(268, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'G')	goto yy269;
	if(yych != 'g')	goto yy56;
	goto yy269;
yy269:
	YYDEBUG(269, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'H')	goto yy270;
	if(yych != 'h')	goto yy56;
	goto yy270;
yy270:
	YYDEBUG(270, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy258;
	if(yych == 't')	goto yy258;
	goto yy56;
yy271:
	YYDEBUG(271, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'G')	goto yy272;
	if(yych != 'g')	goto yy56;
	goto yy272;
yy272:
	YYDEBUG(272, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'H')	goto yy273;
	if(yych != 'h')	goto yy56;
	goto yy273;
yy273:
	YYDEBUG(273, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy258;
	if(yych == 't')	goto yy258;
	goto yy56;
yy274:
	YYDEBUG(274, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'D')	goto yy275;
	if(yych != 'd')	goto yy56;
	goto yy275;
yy275:
	YYDEBUG(275, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'A')	goto yy276;
	if(yych != 'a')	goto yy56;
	goto yy276;
yy276:
	YYDEBUG(276, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'Y')	goto yy192;
	if(yych == 'y')	goto yy192;
	goto yy56;
yy277:
	YYDEBUG(277, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'E'){
		if(yych <= 'C')	goto yy56;
		if(yych <= 'D')	goto yy279;
		goto yy278;
	} else {
		if(yych <= 'c')	goto yy56;
		if(yych <= 'd')	goto yy279;
		if(yych >= 'f')	goto yy56;
		goto yy278;
	}
yy278:
	YYDEBUG(278, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'K')	goto yy258;
	if(yych == 'k')	goto yy258;
	goto yy56;
yy279:
	YYDEBUG(279, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'N')	goto yy280;
	if(yych != 'n')	goto yy56;
	goto yy280;
yy280:
	YYDEBUG(280, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'E')	goto yy281;
	if(yych != 'e')	goto yy56;
	goto yy281;
yy281:
	YYDEBUG(281, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'S')	goto yy282;
	if(yych != 's')	goto yy56;
	goto yy282;
yy282:
	YYDEBUG(282, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'D')	goto yy283;
	if(yych != 'd')	goto yy56;
	goto yy283;
yy283:
	YYDEBUG(283, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'A')	goto yy284;
	if(yych != 'a')	goto yy56;
	goto yy284;
yy284:
	YYDEBUG(284, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'Y')	goto yy192;
	if(yych == 'y')	goto yy192;
	goto yy56;
yy285:
	YYDEBUG(285, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'Y')	goto yy258;
	if(yych == 'y')	goto yy258;
	goto yy56;
yy286:
	YYDEBUG(286, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'U')	goto yy287;
	if(yych != 'u')	goto yy56;
	goto yy287;
yy287:
	YYDEBUG(287, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'R')	goto yy258;
	if(yych == 'r')	goto yy258;
	goto yy56;
yy288:
	YYDEBUG(288, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'N')	goto yy293;
	if(yych == 'n')	goto yy293;
	goto yy56;
yy289:
	YYDEBUG(289, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'N')	goto yy290;
	if(yych != 'n')	goto yy56;
	goto yy290;
yy290:
	YYDEBUG(290, *YYCURSOR);
	yyaccept = 5;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case 'E':	case 'e':	goto yy198;
	case 'F':	case 'f':	goto yy194;
	case 'L':	case 'l':	goto yy199;
	case 'N':	case 'n':	goto yy195;
	case 'P':	case 'p':	goto yy200;
	case 'S':	case 's':	goto yy259;
	case 'T':	case 't':	goto yy197;
	case 'U':	case 'u':	goto yy291;
	default:	goto yy193;
	}
yy291:
	YYDEBUG(291, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy292;
	if(yych != 't')	goto yy56;
	goto yy292;
yy292:
	YYDEBUG(292, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'E')	goto yy258;
	if(yych == 'e')	goto yy258;
	goto yy56;
yy293:
	YYDEBUG(293, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'T'){
		if(yych == 'D')	goto yy294;
		if(yych <= 'S')	goto yy56;
		goto yy295;
	} else {
		if(yych <= 'd'){
			if(yych <= 'c')	goto yy56;
			goto yy294;
		} else {
			if(yych == 't')	goto yy295;
			goto yy56;
		}
	}
yy294:
	YYDEBUG(294, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'A')	goto yy296;
	if(yych == 'a')	goto yy296;
	goto yy56;
yy295:
	YYDEBUG(295, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'H')	goto yy258;
	if(yych == 'h')	goto yy258;
	goto yy56;
yy296:
	YYDEBUG(296, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'Y')	goto yy192;
	if(yych == 'y')	goto yy192;
	goto yy56;
yy297:
	YYDEBUG(297, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'T')	goto yy306;
	if(yych == 't')	goto yy306;
	goto yy56;
yy298:
	YYDEBUG(298, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'N')	goto yy303;
	if(yych == 'n')	goto yy303;
	goto yy56;
yy299:
	YYDEBUG(299, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'C')	goto yy300;
	if(yych != 'c')	goto yy56;
	goto yy300;
yy300:
	YYDEBUG(300, *YYCURSOR);
	yyaccept = 5;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case 'E':	case 'e':	goto yy198;
	case 'F':	case 'f':	goto yy194;
	case 'L':	case 'l':	goto yy199;
	case 'N':	case 'n':	goto yy195;
	case 'O':	case 'o':	goto yy301;
	case 'P':	case 'p':	goto yy200;
	case 'S':	case 's':	goto yy259;
	case 'T':	case 't':	goto yy197;
	default:	goto yy193;
	}
yy301:
	YYDEBUG(301, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'N')	goto yy302;
	if(yych != 'n')	goto yy56;
	goto yy302;
yy302:
	YYDEBUG(302, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'D')	goto yy258;
	if(yych == 'd')	goto yy258;
	goto yy56;
yy303:
	YYDEBUG(303, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'D')	goto yy304;
	if(yych != 'd')	goto yy56;
	goto yy304;
yy304:
	YYDEBUG(304, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'A')	goto yy305;
	if(yych != 'a')	goto yy56;
	goto yy305;
yy305:
	YYDEBUG(305, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'Y')	goto yy192;
	if(yych == 'y')	goto yy192;
	goto yy56;
yy306:
	YYDEBUG(306, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'U')	goto yy307;
	if(yych != 'u')	goto yy56;
	goto yy307;
yy307:
	YYDEBUG(307, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'R')	goto yy308;
	if(yych != 'r')	goto yy56;
	goto yy308;
yy308:
	YYDEBUG(308, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'D')	goto yy309;
	if(yych != 'd')	goto yy56;
	goto yy309;
yy309:
	YYDEBUG(309, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'A')	goto yy310;
	if(yych != 'a')	goto yy56;
	goto yy310;
yy310:
	YYDEBUG(310, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 'Y')	goto yy192;
	if(yych == 'y')	goto yy192;
	goto yy56;
yy311:
	YYDEBUG(311, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy51;
			goto yy171;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy312;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy312:
	YYDEBUG(312, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'V'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'U')	goto yy52;
			goto yy172;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'v')	goto yy313;
			if(yych <= 'z')	goto yy60;
			goto yy3;
		}
	}
yy313:
	YYDEBUG(313, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'I'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'H')	goto yy3;
			goto yy173;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'i')	goto yy314;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy314:
	YYDEBUG(314, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'O')	goto yy174;
			goto yy56;
		}
	} else {
		if(yych <= 'n'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'o')	goto yy315;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy315:
	YYDEBUG(315, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'U')	goto yy175;
			goto yy56;
		}
	} else {
		if(yych <= 't'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'u')	goto yy316;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy316:
	YYDEBUG(316, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'S')	goto yy176;
			goto yy56;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 's')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy317:
	YYDEBUG(317, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	goto yy176;
	case '/':	case '_':	goto yy55;
	case 'D':	goto yy181;
	case 'F':	goto yy183;
	case 'H':	goto yy180;
	case 'M':	goto yy179;
	case 'S':	goto yy178;
	case 'T':	goto yy185;
	case 'W':	goto yy182;
	case 'Y':	goto yy184;
	case 'a':
	case 'b':
	case 'c':	case 'e':	case 'g':	case 'i':
	case 'j':
	case 'k':
	case 'l':	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':	case 'u':
	case 'v':	case 'x':	case 'z':	goto yy61;
	case 'd':	goto yy321;
	case 'f':	goto yy323;
	case 'h':	goto yy320;
	case 'm':	goto yy319;
	case 's':	goto yy318;
	case 't':	goto yy325;
	case 'w':	goto yy322;
	case 'y':	goto yy324;
	default:	goto yy56;
	}
yy318:
	YYDEBUG(318, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= 'A'){
			if(yych == '/')	goto yy55;
			if(yych <= '@')	goto yy56;
			goto yy297;
		} else {
			if(yych <= 'E'){
				if(yych <= 'D')	goto yy56;
				goto yy299;
			} else {
				if(yych == 'U')	goto yy298;
				goto yy56;
			}
		}
	} else {
		if(yych <= 'd'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			if(yych <= 'a')	goto yy436;
			goto yy61;
		} else {
			if(yych <= 't'){
				if(yych <= 'e')	goto yy437;
				goto yy61;
			} else {
				if(yych <= 'u')	goto yy438;
				if(yych <= 'z')	goto yy61;
				goto yy56;
			}
		}
	}
yy319:
	YYDEBUG(319, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= 'H'){
			if(yych == '/')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'I')	goto yy289;
			if(yych == 'O')	goto yy288;
			goto yy56;
		}
	} else {
		if(yych <= 'i'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			if(yych <= 'h')	goto yy61;
			goto yy427;
		} else {
			if(yych == 'o')	goto yy428;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy320:
	YYDEBUG(320, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'O')	goto yy286;
			goto yy56;
		}
	} else {
		if(yych <= 'n'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'o')	goto yy425;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy321:
	YYDEBUG(321, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'A')	goto yy285;
			goto yy56;
		}
	} else {
		if(yych <= '`'){
			if(yych <= '_')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'a')	goto yy424;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy322:
	YYDEBUG(322, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'E')	goto yy277;
			goto yy56;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'e')	goto yy416;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy323:
	YYDEBUG(323, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= 'N'){
			if(yych == '/')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'O')	goto yy262;
			if(yych == 'R')	goto yy261;
			goto yy56;
		}
	} else {
		if(yych <= 'o'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			if(yych <= 'n')	goto yy61;
			goto yy400;
		} else {
			if(yych == 'r')	goto yy401;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy324:
	YYDEBUG(324, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'E')	goto yy256;
			goto yy56;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'e')	goto yy395;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy325:
	YYDEBUG(325, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= 'G'){
			if(yych == '/')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'H')	goto yy186;
			if(yych == 'U')	goto yy187;
			goto yy56;
		}
	} else {
		if(yych <= 'h'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			if(yych <= 'g')	goto yy61;
			goto yy326;
		} else {
			if(yych == 'u')	goto yy327;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy326:
	YYDEBUG(326, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'U')	goto yy251;
			goto yy56;
		}
	} else {
		if(yych <= 't'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'u')	goto yy390;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy327:
	YYDEBUG(327, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'E')	goto yy188;
			goto yy56;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'e')	goto yy328;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy328:
	YYDEBUG(328, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'S')	goto yy189;
			goto yy56;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 's')	goto yy329;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy329:
	YYDEBUG(329, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'D')	goto yy190;
			goto yy56;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'd')	goto yy330;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy330:
	YYDEBUG(330, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'A')	goto yy191;
			goto yy56;
		}
	} else {
		if(yych <= '`'){
			if(yych <= '_')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'a')	goto yy331;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy331:
	YYDEBUG(331, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'Y')	goto yy192;
			goto yy56;
		}
	} else {
		if(yych <= 'x'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'y')	goto yy332;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy332:
	YYDEBUG(332, *YYCURSOR);
	yyaccept = 5;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case '/':	case '_':	goto yy55;
	case 'E':	goto yy198;
	case 'F':	goto yy194;
	case 'L':	goto yy199;
	case 'N':	goto yy195;
	case 'P':	goto yy200;
	case 'S':	goto yy196;
	case 'T':	goto yy197;
	case 'a':
	case 'b':
	case 'c':
	case 'd':	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':	case 'm':	case 'o':	case 'q':
	case 'r':	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy61;
	case 'e':	goto yy333;
	case 'f':	goto yy334;
	case 'l':	goto yy335;
	case 'n':	goto yy336;
	case 'p':	goto yy337;
	case 's':	goto yy338;
	case 't':	goto yy339;
	default:	goto yy193;
	}
yy333:
	YYDEBUG(333, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= 'H'){
			if(yych == '/')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'I')	goto yy207;
			if(yych == 'L')	goto yy206;
			goto yy56;
		}
	} else {
		if(yych <= 'i'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			if(yych <= 'h')	goto yy61;
			goto yy382;
		} else {
			if(yych == 'l')	goto yy381;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy334:
	YYDEBUG(334, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= 'H'){
			if(yych == '/')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'I')	goto yy242;
			if(yych == 'O')	goto yy243;
			goto yy56;
		}
	} else {
		if(yych <= 'i'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			if(yych <= 'h')	goto yy61;
			goto yy372;
		} else {
			if(yych == 'o')	goto yy373;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy335:
	YYDEBUG(335, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'A')	goto yy204;
			goto yy56;
		}
	} else {
		if(yych <= '`'){
			if(yych <= '_')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'a')	goto yy370;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy336:
	YYDEBUG(336, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= 'D'){
			if(yych == '/')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'E')	goto yy238;
			if(yych == 'I')	goto yy237;
			goto yy56;
		}
	} else {
		if(yych <= 'e'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			if(yych <= 'd')	goto yy61;
			goto yy366;
		} else {
			if(yych == 'i')	goto yy365;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy337:
	YYDEBUG(337, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'R')	goto yy201;
			goto yy56;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'r')	goto yy362;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy338:
	YYDEBUG(338, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= 'D'){
			if(yych == '/')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'E')	goto yy226;
			if(yych == 'I')	goto yy227;
			goto yy56;
		}
	} else {
		if(yych <= 'e'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			if(yych <= 'd')	goto yy61;
			goto yy351;
		} else {
			if(yych == 'i')	goto yy352;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy339:
	YYDEBUG(339, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= 'E'){
			if(yych == '/')	goto yy55;
			if(yych <= 'D')	goto yy56;
			goto yy217;
		} else {
			if(yych <= 'H'){
				if(yych <= 'G')	goto yy56;
				goto yy215;
			} else {
				if(yych == 'W')	goto yy216;
				goto yy56;
			}
		}
	} else {
		if(yych <= 'g'){
			if(yych <= '`'){
				if(yych <= '_')	goto yy55;
				goto yy56;
			} else {
				if(yych == 'e')	goto yy342;
				goto yy61;
			}
		} else {
			if(yych <= 'v'){
				if(yych >= 'i')	goto yy61;
				goto yy340;
			} else {
				if(yych <= 'w')	goto yy341;
				if(yych <= 'z')	goto yy61;
				goto yy56;
			}
		}
	}
yy340:
	YYDEBUG(340, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'I')	goto yy224;
			goto yy56;
		}
	} else {
		if(yych <= 'h'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'i')	goto yy349;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy341:
	YYDEBUG(341, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'E')	goto yy220;
			goto yy56;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'e')	goto yy345;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy342:
	YYDEBUG(342, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'N')	goto yy218;
			goto yy56;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'n')	goto yy343;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy343:
	YYDEBUG(343, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'T')	goto yy219;
			goto yy56;
		}
	} else {
		if(yych <= 's'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 't')	goto yy344;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy344:
	YYDEBUG(344, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'H')	goto yy176;
			goto yy56;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'h')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy345:
	YYDEBUG(345, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'L')	goto yy221;
			goto yy56;
		}
	} else {
		if(yych <= 'k'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'l')	goto yy346;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy346:
	YYDEBUG(346, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'F')	goto yy222;
			goto yy56;
		}
	} else {
		if(yych <= 'e'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'f')	goto yy347;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy347:
	YYDEBUG(347, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'T')	goto yy223;
			goto yy56;
		}
	} else {
		if(yych <= 's'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 't')	goto yy348;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy348:
	YYDEBUG(348, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'H')	goto yy176;
			goto yy56;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'h')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy349:
	YYDEBUG(349, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= 'Q'){
			if(yych == '/')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'R')	goto yy225;
			if(yych <= 'S')	goto yy176;
			goto yy56;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'r')	goto yy350;
			if(yych <= 's')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy350:
	YYDEBUG(350, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'D')	goto yy176;
			goto yy56;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'd')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy351:
	YYDEBUG(351, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= 'B'){
			if(yych == '/')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'C')	goto yy230;
			if(yych == 'V')	goto yy231;
			goto yy56;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			if(yych <= 'b')	goto yy61;
			goto yy355;
		} else {
			if(yych == 'v')	goto yy356;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy352:
	YYDEBUG(352, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'X')	goto yy228;
			goto yy56;
		}
	} else {
		if(yych <= 'w'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'x')	goto yy353;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy353:
	YYDEBUG(353, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'T')	goto yy229;
			goto yy56;
		}
	} else {
		if(yych <= 's'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 't')	goto yy354;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy354:
	YYDEBUG(354, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'H')	goto yy176;
			goto yy56;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'h')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy355:
	YYDEBUG(355, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'O')	goto yy235;
			goto yy56;
		}
	} else {
		if(yych <= 'n'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'o')	goto yy360;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy356:
	YYDEBUG(356, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'E')	goto yy232;
			goto yy56;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'e')	goto yy357;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy357:
	YYDEBUG(357, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'N')	goto yy233;
			goto yy56;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'n')	goto yy358;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy358:
	YYDEBUG(358, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'T')	goto yy234;
			goto yy56;
		}
	} else {
		if(yych <= 's'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 't')	goto yy359;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy359:
	YYDEBUG(359, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'H')	goto yy176;
			goto yy56;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'h')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy360:
	YYDEBUG(360, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'N')	goto yy236;
			goto yy56;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'n')	goto yy361;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy361:
	YYDEBUG(361, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'D')	goto yy176;
			goto yy56;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'd')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy362:
	YYDEBUG(362, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'E')	goto yy202;
			goto yy56;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'e')	goto yy363;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy363:
	YYDEBUG(363, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'V')	goto yy203;
			goto yy56;
		}
	} else {
		if(yych <= 'u'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'v')	goto yy364;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy364:
	YYDEBUG(364, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'I')	goto yy173;
			goto yy56;
		}
	} else {
		if(yych <= 'h'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'i')	goto yy314;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy365:
	YYDEBUG(365, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'N')	goto yy240;
			goto yy56;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'n')	goto yy368;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy366:
	YYDEBUG(366, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'X')	goto yy239;
			goto yy56;
		}
	} else {
		if(yych <= 'w'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'x')	goto yy367;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy367:
	YYDEBUG(367, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'T')	goto yy176;
			goto yy56;
		}
	} else {
		if(yych <= 's'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 't')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy368:
	YYDEBUG(368, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'T')	goto yy241;
			goto yy56;
		}
	} else {
		if(yych <= 's'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 't')	goto yy369;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy369:
	YYDEBUG(369, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'H')	goto yy176;
			goto yy56;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'h')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy370:
	YYDEBUG(370, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'S')	goto yy205;
			goto yy56;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 's')	goto yy371;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy371:
	YYDEBUG(371, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'T')	goto yy176;
			goto yy56;
		}
	} else {
		if(yych <= 's'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 't')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy372:
	YYDEBUG(372, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= 'E'){
			if(yych == '/')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'F')	goto yy248;
			if(yych == 'R')	goto yy247;
			goto yy56;
		}
	} else {
		if(yych <= 'f'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			if(yych <= 'e')	goto yy61;
			goto yy377;
		} else {
			if(yych == 'r')	goto yy378;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy373:
	YYDEBUG(373, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'U')	goto yy244;
			goto yy56;
		}
	} else {
		if(yych <= 't'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'u')	goto yy374;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy374:
	YYDEBUG(374, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'R')	goto yy245;
			goto yy56;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'r')	goto yy375;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy375:
	YYDEBUG(375, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'T')	goto yy246;
			goto yy56;
		}
	} else {
		if(yych <= 's'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 't')	goto yy376;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy376:
	YYDEBUG(376, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'H')	goto yy176;
			goto yy56;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'h')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy377:
	YYDEBUG(377, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'T')	goto yy249;
			goto yy56;
		}
	} else {
		if(yych <= 's'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 't')	goto yy380;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy378:
	YYDEBUG(378, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'S')	goto yy250;
			goto yy56;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 's')	goto yy379;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy379:
	YYDEBUG(379, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'T')	goto yy176;
			goto yy56;
		}
	} else {
		if(yych <= 's'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 't')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy380:
	YYDEBUG(380, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'H')	goto yy176;
			goto yy56;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'h')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy381:
	YYDEBUG(381, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'E')	goto yy210;
			goto yy56;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'e')	goto yy385;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy382:
	YYDEBUG(382, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'G')	goto yy208;
			goto yy56;
		}
	} else {
		if(yych <= 'f'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'g')	goto yy383;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy383:
	YYDEBUG(383, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'H')	goto yy209;
			goto yy56;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'h')	goto yy384;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy384:
	YYDEBUG(384, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'T')	goto yy176;
			goto yy56;
		}
	} else {
		if(yych <= 's'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 't')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy385:
	YYDEBUG(385, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'V')	goto yy211;
			goto yy56;
		}
	} else {
		if(yych <= 'u'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'v')	goto yy386;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy386:
	YYDEBUG(386, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'E')	goto yy212;
			goto yy56;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'e')	goto yy387;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy387:
	YYDEBUG(387, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'N')	goto yy213;
			goto yy56;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'n')	goto yy388;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy388:
	YYDEBUG(388, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'T')	goto yy214;
			goto yy56;
		}
	} else {
		if(yych <= 's'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 't')	goto yy389;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy389:
	YYDEBUG(389, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'H')	goto yy176;
			goto yy56;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'h')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy390:
	YYDEBUG(390, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'R')	goto yy252;
			goto yy56;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'r')	goto yy391;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy391:
	YYDEBUG(391, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'S')	goto yy253;
			goto yy56;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 's')	goto yy392;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy392:
	YYDEBUG(392, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'D')	goto yy254;
			goto yy56;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'd')	goto yy393;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy393:
	YYDEBUG(393, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'A')	goto yy255;
			goto yy56;
		}
	} else {
		if(yych <= '`'){
			if(yych <= '_')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'a')	goto yy394;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy394:
	YYDEBUG(394, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'Y')	goto yy192;
			goto yy56;
		}
	} else {
		if(yych <= 'x'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'y')	goto yy332;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy395:
	YYDEBUG(395, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'A')	goto yy257;
			goto yy56;
		}
	} else {
		if(yych <= '`'){
			if(yych <= '_')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'a')	goto yy396;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy396:
	YYDEBUG(396, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'R')	goto yy258;
			goto yy56;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'r')	goto yy397;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy397:
	YYDEBUG(397, *YYCURSOR);
	yyaccept = 5;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case '/':	case '_':	goto yy55;
	case 'E':	goto yy198;
	case 'F':	goto yy194;
	case 'L':	goto yy199;
	case 'N':	goto yy195;
	case 'P':	goto yy200;
	case 'S':	goto yy259;
	case 'T':	goto yy197;
	case 'a':
	case 'b':
	case 'c':
	case 'd':	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':	case 'm':	case 'o':	case 'q':
	case 'r':	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy61;
	case 'e':	goto yy333;
	case 'f':	goto yy334;
	case 'l':	goto yy335;
	case 'n':	goto yy336;
	case 'p':	goto yy337;
	case 's':	goto yy398;
	case 't':	goto yy339;
	default:	goto yy193;
	}
yy398:
	YYDEBUG(398, *YYCURSOR);
	yyaccept = 5;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case '/':	case '_':	goto yy55;
	case 'E':	goto yy260;
	case 'F':	goto yy194;
	case 'I':	goto yy227;
	case 'L':	goto yy199;
	case 'N':	goto yy195;
	case 'P':	goto yy200;
	case 'S':	goto yy196;
	case 'T':	goto yy197;
	case 'a':
	case 'b':
	case 'c':
	case 'd':	case 'g':
	case 'h':	case 'j':
	case 'k':	case 'm':	case 'o':	case 'q':
	case 'r':	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy61;
	case 'e':	goto yy399;
	case 'f':	goto yy334;
	case 'i':	goto yy352;
	case 'l':	goto yy335;
	case 'n':	goto yy336;
	case 'p':	goto yy337;
	case 's':	goto yy338;
	case 't':	goto yy339;
	default:	goto yy193;
	}
yy399:
	YYDEBUG(399, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= 'H'){
			if(yych <= '/'){
				if(yych <= '.')	goto yy56;
				goto yy55;
			} else {
				if(yych == 'C')	goto yy230;
				goto yy56;
			}
		} else {
			if(yych <= 'L'){
				if(yych <= 'I')	goto yy207;
				if(yych <= 'K')	goto yy56;
				goto yy206;
			} else {
				if(yych == 'V')	goto yy231;
				goto yy56;
			}
		}
	} else {
		if(yych <= 'i'){
			if(yych <= 'b'){
				if(yych <= '_')	goto yy55;
				if(yych <= '`')	goto yy56;
				goto yy61;
			} else {
				if(yych <= 'c')	goto yy355;
				if(yych <= 'h')	goto yy61;
				goto yy382;
			}
		} else {
			if(yych <= 'u'){
				if(yych == 'l')	goto yy381;
				goto yy61;
			} else {
				if(yych <= 'v')	goto yy356;
				if(yych <= 'z')	goto yy61;
				goto yy56;
			}
		}
	}
yy400:
	YYDEBUG(400, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'R')	goto yy263;
			goto yy56;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'r')	goto yy405;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy401:
	YYDEBUG(401, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'I')	goto yy274;
			goto yy56;
		}
	} else {
		if(yych <= 'h'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'i')	goto yy402;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy402:
	YYDEBUG(402, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'D')	goto yy275;
			goto yy56;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'd')	goto yy403;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy403:
	YYDEBUG(403, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'A')	goto yy276;
			goto yy56;
		}
	} else {
		if(yych <= '`'){
			if(yych <= '_')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'a')	goto yy404;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy404:
	YYDEBUG(404, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'Y')	goto yy192;
			goto yy56;
		}
	} else {
		if(yych <= 'x'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'y')	goto yy332;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy405:
	YYDEBUG(405, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'T')	goto yy264;
			goto yy56;
		}
	} else {
		if(yych <= 's'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 't')	goto yy406;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy406:
	YYDEBUG(406, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= 'G'){
			if(yych == '/')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'H')	goto yy266;
			if(yych == 'N')	goto yy265;
			goto yy56;
		}
	} else {
		if(yych <= 'h'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			if(yych <= 'g')	goto yy61;
			goto yy408;
		} else {
			if(yych == 'n')	goto yy407;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy407:
	YYDEBUG(407, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'I')	goto yy271;
			goto yy56;
		}
	} else {
		if(yych <= 'h'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'i')	goto yy413;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy408:
	YYDEBUG(408, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'N')	goto yy267;
			goto yy56;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'n')	goto yy409;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy409:
	YYDEBUG(409, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'I')	goto yy268;
			goto yy56;
		}
	} else {
		if(yych <= 'h'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'i')	goto yy410;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy410:
	YYDEBUG(410, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'G')	goto yy269;
			goto yy56;
		}
	} else {
		if(yych <= 'f'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'g')	goto yy411;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy411:
	YYDEBUG(411, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'H')	goto yy270;
			goto yy56;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'h')	goto yy412;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy412:
	YYDEBUG(412, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'T')	goto yy258;
			goto yy56;
		}
	} else {
		if(yych <= 's'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 't')	goto yy397;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy413:
	YYDEBUG(413, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'G')	goto yy272;
			goto yy56;
		}
	} else {
		if(yych <= 'f'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'g')	goto yy414;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy414:
	YYDEBUG(414, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'H')	goto yy273;
			goto yy56;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'h')	goto yy415;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy415:
	YYDEBUG(415, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'T')	goto yy258;
			goto yy56;
		}
	} else {
		if(yych <= 's'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 't')	goto yy397;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy416:
	YYDEBUG(416, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= 'C'){
			if(yych == '/')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'D')	goto yy279;
			if(yych <= 'E')	goto yy278;
			goto yy56;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'd')	goto yy418;
			if(yych <= 'e')	goto yy417;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy417:
	YYDEBUG(417, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'K')	goto yy258;
			goto yy56;
		}
	} else {
		if(yych <= 'j'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'k')	goto yy397;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy418:
	YYDEBUG(418, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'N')	goto yy280;
			goto yy56;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'n')	goto yy419;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy419:
	YYDEBUG(419, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'E')	goto yy281;
			goto yy56;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'e')	goto yy420;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy420:
	YYDEBUG(420, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'S')	goto yy282;
			goto yy56;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 's')	goto yy421;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy421:
	YYDEBUG(421, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'D')	goto yy283;
			goto yy56;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'd')	goto yy422;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy422:
	YYDEBUG(422, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'A')	goto yy284;
			goto yy56;
		}
	} else {
		if(yych <= '`'){
			if(yych <= '_')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'a')	goto yy423;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy423:
	YYDEBUG(423, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'Y')	goto yy192;
			goto yy56;
		}
	} else {
		if(yych <= 'x'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'y')	goto yy332;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy424:
	YYDEBUG(424, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'Y')	goto yy258;
			goto yy56;
		}
	} else {
		if(yych <= 'x'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'y')	goto yy397;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy425:
	YYDEBUG(425, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'U')	goto yy287;
			goto yy56;
		}
	} else {
		if(yych <= 't'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'u')	goto yy426;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy426:
	YYDEBUG(426, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'R')	goto yy258;
			goto yy56;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'r')	goto yy397;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy427:
	YYDEBUG(427, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'N')	goto yy290;
			goto yy56;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'n')	goto yy433;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy428:
	YYDEBUG(428, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'N')	goto yy293;
			goto yy56;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'n')	goto yy429;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy429:
	YYDEBUG(429, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= 'C'){
			if(yych == '/')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'D')	goto yy294;
			if(yych == 'T')	goto yy295;
			goto yy56;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			if(yych <= 'c')	goto yy61;
			goto yy430;
		} else {
			if(yych == 't')	goto yy431;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy430:
	YYDEBUG(430, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'A')	goto yy296;
			goto yy56;
		}
	} else {
		if(yych <= '`'){
			if(yych <= '_')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'a')	goto yy432;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy431:
	YYDEBUG(431, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'H')	goto yy258;
			goto yy56;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'h')	goto yy397;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy432:
	YYDEBUG(432, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'Y')	goto yy192;
			goto yy56;
		}
	} else {
		if(yych <= 'x'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'y')	goto yy332;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy433:
	YYDEBUG(433, *YYCURSOR);
	yyaccept = 5;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case '/':	case '_':	goto yy55;
	case 'E':	goto yy198;
	case 'F':	goto yy194;
	case 'L':	goto yy199;
	case 'N':	goto yy195;
	case 'P':	goto yy200;
	case 'S':	goto yy259;
	case 'T':	goto yy197;
	case 'U':	goto yy291;
	case 'a':
	case 'b':
	case 'c':
	case 'd':	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':	case 'm':	case 'o':	case 'q':
	case 'r':	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy61;
	case 'e':	goto yy333;
	case 'f':	goto yy334;
	case 'l':	goto yy335;
	case 'n':	goto yy336;
	case 'p':	goto yy337;
	case 's':	goto yy398;
	case 't':	goto yy339;
	case 'u':	goto yy434;
	default:	goto yy193;
	}
yy434:
	YYDEBUG(434, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'T')	goto yy292;
			goto yy56;
		}
	} else {
		if(yych <= 's'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 't')	goto yy435;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy435:
	YYDEBUG(435, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'E')	goto yy258;
			goto yy56;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'e')	goto yy397;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy436:
	YYDEBUG(436, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'T')	goto yy306;
			goto yy56;
		}
	} else {
		if(yych <= 's'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 't')	goto yy445;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy437:
	YYDEBUG(437, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'C')	goto yy300;
			goto yy56;
		}
	} else {
		if(yych <= 'b'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'c')	goto yy442;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy438:
	YYDEBUG(438, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'N')	goto yy303;
			goto yy56;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'n')	goto yy439;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy439:
	YYDEBUG(439, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'D')	goto yy304;
			goto yy56;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'd')	goto yy440;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy440:
	YYDEBUG(440, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'A')	goto yy305;
			goto yy56;
		}
	} else {
		if(yych <= '`'){
			if(yych <= '_')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'a')	goto yy441;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy441:
	YYDEBUG(441, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'Y')	goto yy192;
			goto yy56;
		}
	} else {
		if(yych <= 'x'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'y')	goto yy332;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy442:
	YYDEBUG(442, *YYCURSOR);
	yyaccept = 5;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case '/':	case '_':	goto yy55;
	case 'E':	goto yy198;
	case 'F':	goto yy194;
	case 'L':	goto yy199;
	case 'N':	goto yy195;
	case 'O':	goto yy301;
	case 'P':	goto yy200;
	case 'S':	goto yy259;
	case 'T':	goto yy197;
	case 'a':
	case 'b':
	case 'c':
	case 'd':	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':	case 'm':	case 'q':
	case 'r':	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy61;
	case 'e':	goto yy333;
	case 'f':	goto yy334;
	case 'l':	goto yy335;
	case 'n':	goto yy336;
	case 'o':	goto yy443;
	case 'p':	goto yy337;
	case 's':	goto yy398;
	case 't':	goto yy339;
	default:	goto yy193;
	}
yy443:
	YYDEBUG(443, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'N')	goto yy302;
			goto yy56;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'n')	goto yy444;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy444:
	YYDEBUG(444, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'D')	goto yy258;
			goto yy56;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'd')	goto yy397;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy445:
	YYDEBUG(445, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'U')	goto yy307;
			goto yy56;
		}
	} else {
		if(yych <= 't'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'u')	goto yy446;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy446:
	YYDEBUG(446, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'R')	goto yy308;
			goto yy56;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'r')	goto yy447;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy447:
	YYDEBUG(447, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'D')	goto yy309;
			goto yy56;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'd')	goto yy448;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy448:
	YYDEBUG(448, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'A')	goto yy310;
			goto yy56;
		}
	} else {
		if(yych <= '`'){
			if(yych <= '_')	goto yy55;
			goto yy56;
		} else {
			if(yych <= 'a')	goto yy449;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy449:
	YYDEBUG(449, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'Y')	goto yy192;
			goto yy56;
		}
	} else {
		if(yych <= 'x'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'y')	goto yy332;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy450:
	YYDEBUG(450, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy51;
			goto yy451;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 's')	goto yy451;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy451:
	YYDEBUG(451, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy52;
			goto yy452;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy3;
			goto yy52;
		} else {
			if(yych <= 't')	goto yy452;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy452:
	YYDEBUG(452, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy177;
	case ')':	goto yy49;
	default:	goto yy3;
	}
yy453:
	YYDEBUG(453, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy51;
			goto yy451;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 's')	goto yy454;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy454:
	YYDEBUG(454, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy52;
			goto yy452;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 't')	goto yy455;
			if(yych <= 'z')	goto yy60;
			goto yy3;
		}
	}
yy455:
	YYDEBUG(455, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	goto yy177;
	case ')':	goto yy49;
	case '/':	case '_':	goto yy55;
	case 'a':
	case 'b':
	case 'c':	case 'e':	case 'g':	case 'i':
	case 'j':
	case 'k':
	case 'l':	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':	case 'u':
	case 'v':	case 'x':	case 'z':	goto yy61;
	case 'd':	goto yy321;
	case 'f':	goto yy323;
	case 'h':	goto yy320;
	case 'm':	goto yy319;
	case 's':	goto yy318;
	case 't':	goto yy325;
	case 'w':	goto yy322;
	case 'y':	goto yy324;
	default:	goto yy3;
	}
yy456:
	YYDEBUG(456, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'G'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'F')	goto yy51;
			goto yy460;
		}
	} else {
		if(yych <= 'f'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'g')	goto yy460;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy457:
	YYDEBUG(457, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy51;
			goto yy458;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'e')	goto yy458;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy458:
	YYDEBUG(458, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'V'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'U')	goto yy52;
			goto yy459;
		}
	} else {
		if(yych <= 'u'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy3;
			goto yy52;
		} else {
			if(yych <= 'v')	goto yy459;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy459:
	YYDEBUG(459, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'E')	goto yy212;
		if(yych == 'e')	goto yy212;
		goto yy3;
	}
yy460:
	YYDEBUG(460, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'H'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'G')	goto yy52;
			goto yy461;
		}
	} else {
		if(yych <= 'g'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy3;
			goto yy52;
		} else {
			if(yych <= 'h')	goto yy461;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy461:
	YYDEBUG(461, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'T')	goto yy176;
		if(yych == 't')	goto yy176;
		goto yy3;
	}
yy462:
	YYDEBUG(462, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'G'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'F')	goto yy51;
			goto yy460;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'g')	goto yy466;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy463:
	YYDEBUG(463, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy51;
			goto yy458;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy464;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy464:
	YYDEBUG(464, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'V'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'U')	goto yy52;
			goto yy459;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'v')	goto yy465;
			if(yych <= 'z')	goto yy60;
			goto yy3;
		}
	}
yy465:
	YYDEBUG(465, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'D')	goto yy3;
			goto yy212;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy387;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy466:
	YYDEBUG(466, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'G')	goto yy52;
			goto yy461;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy467;
			if(yych <= 'z')	goto yy60;
			goto yy3;
		}
	}
yy467:
	YYDEBUG(467, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'S')	goto yy3;
			goto yy176;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 't')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy468:
	YYDEBUG(468, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy51;
			goto yy489;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy504;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy469:
	YYDEBUG(469, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'U'){
		if(yych <= '/'){
			if(yych == ')')	goto yy49;
			if(yych <= '.')	goto yy3;
			goto yy55;
		} else {
			if(yych <= 'H'){
				if(yych <= '@')	goto yy3;
				goto yy51;
			} else {
				if(yych <= 'I')	goto yy482;
				if(yych <= 'T')	goto yy51;
				goto yy483;
			}
		}
	} else {
		if(yych <= 'h'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy51;
				goto yy3;
			} else {
				if(yych <= '_')	goto yy55;
				if(yych <= '`')	goto yy3;
				goto yy54;
			}
		} else {
			if(yych <= 't'){
				if(yych <= 'i')	goto yy497;
				goto yy54;
			} else {
				if(yych <= 'u')	goto yy498;
				if(yych <= 'z')	goto yy54;
				goto yy3;
			}
		}
	}
yy470:
	YYDEBUG(470, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy51;
			goto yy478;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy493;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy471:
	YYDEBUG(471, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy51;
			goto yy476;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy491;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy472:
	YYDEBUG(472, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy51;
			goto yy489;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'n')	goto yy489;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy473:
	YYDEBUG(473, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= '@'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych == 'I')	goto yy482;
			if(yych <= 'T')	goto yy51;
			goto yy483;
		}
	} else {
		if(yych <= 'i'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			if(yych <= 'h')	goto yy51;
			goto yy482;
		} else {
			if(yych == 'u')	goto yy483;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy474:
	YYDEBUG(474, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy51;
			goto yy478;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'e')	goto yy478;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy475:
	YYDEBUG(475, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy51;
			goto yy476;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'e')	goto yy476;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy476:
	YYDEBUG(476, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'K')	goto yy52;
			goto yy477;
		}
	} else {
		if(yych <= 'k'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy3;
			goto yy52;
		} else {
			if(yych <= 'l')	goto yy477;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy477:
	YYDEBUG(477, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'F')	goto yy222;
		if(yych == 'f')	goto yy222;
		goto yy3;
	}
yy478:
	YYDEBUG(478, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy154;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy154;
			if(yych <= 'R')	goto yy52;
			goto yy479;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy154;
			goto yy52;
		} else {
			if(yych <= 's')	goto yy479;
			if(yych <= 'z')	goto yy52;
			goto yy154;
		}
	}
yy479:
	YYDEBUG(479, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'C'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'D')	goto yy480;
		if(yych != 'd')	goto yy3;
		goto yy480;
	}
yy480:
	YYDEBUG(480, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy481;
	if(yych != 'a')	goto yy56;
	goto yy481;
yy481:
	YYDEBUG(481, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy160;
	if(yych == 'y')	goto yy160;
	goto yy56;
yy482:
	YYDEBUG(482, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= '@'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= 'Q')	goto yy52;
			if(yych <= 'R')	goto yy488;
			goto yy452;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy3;
			goto yy52;
		} else {
			if(yych <= 'r')	goto yy488;
			if(yych <= 's')	goto yy452;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy483:
	YYDEBUG(483, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy154;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy154;
			if(yych <= 'Q')	goto yy52;
			goto yy484;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy154;
			goto yy52;
		} else {
			if(yych <= 'r')	goto yy484;
			if(yych <= 'z')	goto yy52;
			goto yy154;
		}
	}
yy484:
	YYDEBUG(484, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'S')	goto yy485;
		if(yych != 's')	goto yy3;
		goto yy485;
	}
yy485:
	YYDEBUG(485, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy486;
	if(yych != 'd')	goto yy56;
	goto yy486;
yy486:
	YYDEBUG(486, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy487;
	if(yych != 'a')	goto yy56;
	goto yy487;
yy487:
	YYDEBUG(487, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy160;
	if(yych == 'y')	goto yy160;
	goto yy56;
yy488:
	YYDEBUG(488, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'C'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'D')	goto yy176;
		if(yych == 'd')	goto yy176;
		goto yy3;
	}
yy489:
	YYDEBUG(489, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy52;
			goto yy490;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy3;
			goto yy52;
		} else {
			if(yych <= 't')	goto yy490;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy490:
	YYDEBUG(490, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'G'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'H')	goto yy176;
		if(yych == 'h')	goto yy176;
		goto yy3;
	}
yy491:
	YYDEBUG(491, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'L'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'K')	goto yy52;
			goto yy477;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'l')	goto yy492;
			if(yych <= 'z')	goto yy60;
			goto yy3;
		}
	}
yy492:
	YYDEBUG(492, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'F'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'E')	goto yy3;
			goto yy222;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'f')	goto yy347;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy493:
	YYDEBUG(493, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy154;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy154;
			if(yych <= 'R')	goto yy52;
			goto yy479;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy154;
		} else {
			if(yych == 's')	goto yy494;
			if(yych <= 'z')	goto yy60;
			goto yy154;
		}
	}
yy494:
	YYDEBUG(494, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'C')	goto yy3;
			goto yy480;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'd')	goto yy495;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy495:
	YYDEBUG(495, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy481;
	if(yych != 'a')	goto yy62;
	goto yy496;
yy496:
	YYDEBUG(496, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy160;
	if(yych == 'y')	goto yy169;
	goto yy62;
yy497:
	YYDEBUG(497, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych <= '/'){
			if(yych == ')')	goto yy49;
			if(yych <= '.')	goto yy3;
			goto yy55;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy52;
			if(yych <= 'R')	goto yy488;
			goto yy452;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych <= 'r'){
				if(yych <= 'q')	goto yy60;
				goto yy503;
			} else {
				if(yych <= 's')	goto yy455;
				if(yych <= 'z')	goto yy60;
				goto yy3;
			}
		}
	}
yy498:
	YYDEBUG(498, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy154;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy154;
			if(yych <= 'Q')	goto yy52;
			goto yy484;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy154;
		} else {
			if(yych == 'r')	goto yy499;
			if(yych <= 'z')	goto yy60;
			goto yy154;
		}
	}
yy499:
	YYDEBUG(499, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'R')	goto yy3;
			goto yy485;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 's')	goto yy500;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy500:
	YYDEBUG(500, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy486;
	if(yych != 'd')	goto yy62;
	goto yy501;
yy501:
	YYDEBUG(501, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy487;
	if(yych != 'a')	goto yy62;
	goto yy502;
yy502:
	YYDEBUG(502, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy160;
	if(yych == 'y')	goto yy169;
	goto yy62;
yy503:
	YYDEBUG(503, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'C')	goto yy3;
			goto yy176;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'd')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy504:
	YYDEBUG(504, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy52;
			goto yy490;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 't')	goto yy505;
			if(yych <= 'z')	goto yy60;
			goto yy3;
		}
	}
yy505:
	YYDEBUG(505, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'G')	goto yy3;
			goto yy176;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy506:
	YYDEBUG(506, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'C'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'B')	goto yy51;
			goto yy507;
		}
	} else {
		if(yych <= 'b'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'c')	goto yy507;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy507:
	YYDEBUG(507, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '-')	goto yy511;
			if(yych == '/')	goto yy3;
			goto yy509;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych == 'E')	goto yy516;
			goto yy52;
		} else {
			if(yych <= 'd'){
				if(yych <= '`')	goto yy3;
				goto yy52;
			} else {
				if(yych <= 'e')	goto yy516;
				if(yych <= 'z')	goto yy52;
				goto yy3;
			}
		}
	}
yy508:
	YYDEBUG(508, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 17) YYFILL(17);
	yych = *YYCURSOR;
	goto yy509;
yy509:
	YYDEBUG(509, *YYCURSOR);
	if(yybm[0+yych] & 64) {
		goto yy508;
	}
	if(yych <= '/')	goto yy56;
	if(yych <= '2')	goto yy512;
	if(yych <= '3')	goto yy514;
	if(yych <= '9')	goto yy515;
	goto yy56;
yy510:
	YYDEBUG(510, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 0x1F)	goto yy3;
	if(yych == '/')	goto yy3;
	if(yych <= '9')	goto yy509;
	goto yy3;
yy511:
	YYDEBUG(511, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy509;
	if(yych <= '0')	goto yy588;
	if(yych <= '2')	goto yy589;
	if(yych <= '3')	goto yy590;
	goto yy509;
yy512:
	YYDEBUG(512, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '/')	goto yy524;
	if(yych == '2')	goto yy587;
	if(yych <= '9')	goto yy570;
	goto yy524;
yy513:
	YYDEBUG(513, *YYCURSOR);

{
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy514:
	YYDEBUG(514, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy524;
	if(yych <= '1')	goto yy570;
	if(yych <= '2')	goto yy521;
	if(yych <= '9')	goto yy522;
	goto yy524;
yy515:
	YYDEBUG(515, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy524;
	if(yych <= '1')	goto yy520;
	if(yych <= '2')	goto yy521;
	if(yych <= '9')	goto yy522;
	goto yy524;
yy516:
	YYDEBUG(516, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'L'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'M')	goto yy517;
		if(yych != 'm')	goto yy3;
		goto yy517;
	}
yy517:
	YYDEBUG(517, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy518;
	if(yych != 'b')	goto yy56;
	goto yy518;
yy518:
	YYDEBUG(518, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy519;
	if(yych != 'e')	goto yy56;
	goto yy519;
yy519:
	YYDEBUG(519, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy508;
	if(yych == 'r')	goto yy508;
	goto yy56;
yy520:
	YYDEBUG(520, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy529;
		goto yy513;
	} else {
		if(yych <= '9')	goto yy569;
		if(yych <= ':')	goto yy529;
		goto yy513;
	}
yy521:
	YYDEBUG(521, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy529;
		goto yy513;
	} else {
		if(yych <= '3')	goto yy569;
		if(yych <= '9')	goto yy566;
		if(yych <= ':')	goto yy529;
		goto yy513;
	}
yy522:
	YYDEBUG(522, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy529;
		goto yy513;
	} else {
		if(yych <= '9')	goto yy566;
		if(yych <= ':')	goto yy529;
		goto yy513;
	}
yy523:
	YYDEBUG(523, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 14) YYFILL(14);
	yych = *YYCURSOR;
	goto yy524;
yy524:
	YYDEBUG(524, *YYCURSOR);
	if(yybm[0+yych] & 128) {
		goto yy523;
	}
	if(yych <= '/')	goto yy513;
	if(yych <= '1')	goto yy525;
	if(yych <= '2')	goto yy526;
	if(yych <= '9')	goto yy527;
	goto yy513;
yy525:
	YYDEBUG(525, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy529;
		goto yy513;
	} else {
		if(yych <= '9')	goto yy565;
		if(yych <= ':')	goto yy529;
		goto yy513;
	}
yy526:
	YYDEBUG(526, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy529;
		goto yy513;
	} else {
		if(yych <= '3')	goto yy565;
		if(yych <= '9')	goto yy528;
		if(yych <= ':')	goto yy529;
		goto yy513;
	}
yy527:
	YYDEBUG(527, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy529;
		goto yy513;
	} else {
		if(yych <= '9')	goto yy528;
		if(yych <= ':')	goto yy529;
		goto yy513;
	}
yy528:
	YYDEBUG(528, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy513;
	if(yych <= '9')	goto yy563;
	goto yy513;
yy529:
	YYDEBUG(529, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy530;
	if(yych <= '9')	goto yy532;
	goto yy56;
yy530:
	YYDEBUG(530, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy533;
		goto yy531;
	} else {
		if(yych <= '9')	goto yy532;
		if(yych <= ':')	goto yy533;
		goto yy531;
	}
yy531:
	YYDEBUG(531, *YYCURSOR);

{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy532:
	YYDEBUG(532, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy533;
	if(yych != ':')	goto yy531;
	goto yy533;
yy533:
	YYDEBUG(533, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy534;
	if(yych <= '6')	goto yy535;
	if(yych <= '9')	goto yy536;
	goto yy56;
yy534:
	YYDEBUG(534, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy531;
	if(yych <= '9')	goto yy537;
	goto yy531;
yy535:
	YYDEBUG(535, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '0')	goto yy537;
	goto yy531;
yy536:
	YYDEBUG(536, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy531;
yy537:
	YYDEBUG(537, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '+'){
		if(yych <= '\''){
			if(yych != ' ')	goto yy531;
			goto yy538;
		} else {
			if(yych <= '(')	goto yy541;
			if(yych <= '*')	goto yy531;
			goto yy540;
		}
	} else {
		if(yych <= '@'){
			if(yych == '-')	goto yy540;
			goto yy531;
		} else {
			if(yych <= 'Z')	goto yy542;
			if(yych <= '`')	goto yy531;
			if(yych <= 'z')	goto yy543;
			goto yy531;
		}
	}
yy538:
	YYDEBUG(538, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	goto yy539;
yy539:
	YYDEBUG(539, *YYCURSOR);
	if(yych <= '+'){
		if(yych <= '\''){
			if(yych == ' ')	goto yy538;
			goto yy56;
		} else {
			if(yych <= '(')	goto yy541;
			if(yych <= '*')	goto yy56;
			goto yy540;
		}
	} else {
		if(yych <= '@'){
			if(yych != '-')	goto yy56;
			goto yy540;
		} else {
			if(yych <= 'Z')	goto yy542;
			if(yych <= '`')	goto yy56;
			if(yych <= 'z')	goto yy543;
			goto yy56;
		}
	}
yy540:
	YYDEBUG(540, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '1')	goto yy556;
	if(yych <= '2')	goto yy557;
	if(yych <= '9')	goto yy558;
	goto yy56;
yy541:
	YYDEBUG(541, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@')	goto yy56;
	if(yych <= 'Z')	goto yy543;
	if(yych <= '`')	goto yy56;
	if(yych <= 'z')	goto yy543;
	goto yy56;
yy542:
	YYDEBUG(542, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy536;
		goto yy531;
	} else {
		if(yych <= 'Z')	goto yy544;
		if(yych <= '`')	goto yy531;
		if(yych <= 'z')	goto yy547;
		goto yy531;
	}
yy543:
	YYDEBUG(543, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy536;
		goto yy531;
	} else {
		if(yych <= 'Z')	goto yy544;
		if(yych <= '`')	goto yy531;
		if(yych >= '{')	goto yy531;
		goto yy544;
	}
yy544:
	YYDEBUG(544, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy536;
		goto yy531;
	} else {
		if(yych <= 'Z')	goto yy545;
		if(yych <= '`')	goto yy531;
		if(yych >= '{')	goto yy531;
		goto yy545;
	}
yy545:
	YYDEBUG(545, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych == ')')	goto yy536;
		goto yy531;
	} else {
		if(yych <= 'Z')	goto yy546;
		if(yych <= '`')	goto yy531;
		if(yych >= '{')	goto yy531;
		goto yy546;
	}
yy546:
	YYDEBUG(546, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == ')')	goto yy536;
	goto yy531;
yy547:
	YYDEBUG(547, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy531;
			goto yy536;
		} else {
			if(yych == '/')	goto yy549;
			goto yy531;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy545;
			if(yych <= '^')	goto yy531;
			goto yy549;
		} else {
			if(yych <= '`')	goto yy531;
			if(yych >= '{')	goto yy531;
			goto yy548;
		}
	}
yy548:
	YYDEBUG(548, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy531;
			goto yy536;
		} else {
			if(yych != '/')	goto yy531;
			goto yy549;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy546;
			if(yych <= '^')	goto yy531;
			goto yy549;
		} else {
			if(yych <= '`')	goto yy531;
			if(yych <= 'z')	goto yy553;
			goto yy531;
		}
	}
yy549:
	YYDEBUG(549, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '@')	goto yy56;
	if(yych >= '[')	goto yy56;
	goto yy550;
yy550:
	YYDEBUG(550, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '`')	goto yy56;
	if(yych >= '{')	goto yy56;
	goto yy551;
yy551:
	YYDEBUG(551, *YYCURSOR);
	yyaccept = 7;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy552;
yy552:
	YYDEBUG(552, *YYCURSOR);
	if(yych <= '^'){
		if(yych == '/')	goto yy549;
		goto yy531;
	} else {
		if(yych <= '_')	goto yy549;
		if(yych <= '`')	goto yy531;
		if(yych <= 'z')	goto yy551;
		goto yy531;
	}
yy553:
	YYDEBUG(553, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == ')')	goto yy536;
		if(yych <= '.')	goto yy531;
		goto yy549;
	} else {
		if(yych <= '_'){
			if(yych <= '^')	goto yy531;
			goto yy549;
		} else {
			if(yych <= '`')	goto yy531;
			if(yych >= '{')	goto yy531;
			goto yy554;
		}
	}
yy554:
	YYDEBUG(554, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy555;
yy555:
	YYDEBUG(555, *YYCURSOR);
	if(yych <= '^'){
		if(yych == '/')	goto yy549;
		goto yy56;
	} else {
		if(yych <= '_')	goto yy549;
		if(yych <= '`')	goto yy56;
		if(yych <= 'z')	goto yy554;
		goto yy56;
	}
yy556:
	YYDEBUG(556, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy531;
	if(yych <= '5')	goto yy561;
	if(yych <= '9')	goto yy558;
	if(yych <= ':')	goto yy559;
	goto yy531;
yy557:
	YYDEBUG(557, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '5'){
		if(yych <= '/')	goto yy531;
		if(yych <= '3')	goto yy561;
		goto yy560;
	} else {
		if(yych == ':')	goto yy559;
		goto yy531;
	}
yy558:
	YYDEBUG(558, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/')	goto yy531;
	if(yych <= '5')	goto yy560;
	if(yych != ':')	goto yy531;
	goto yy559;
yy559:
	YYDEBUG(559, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/')	goto yy531;
	if(yych >= '6')	goto yy531;
	goto yy560;
yy560:
	YYDEBUG(560, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '9')	goto yy536;
	goto yy56;
yy561:
	YYDEBUG(561, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy531;
	if(yych <= '5')	goto yy562;
	if(yych <= '9')	goto yy536;
	if(yych <= ':')	goto yy559;
	goto yy531;
yy562:
	YYDEBUG(562, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy531;
	if(yych <= '9')	goto yy536;
	goto yy531;
yy563:
	YYDEBUG(563, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy513;
	if(yych >= ':')	goto yy513;
	goto yy564;
yy564:
	YYDEBUG(564, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy513;
yy565:
	YYDEBUG(565, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy529;
		goto yy513;
	} else {
		if(yych <= '9')	goto yy563;
		if(yych <= ':')	goto yy529;
		goto yy513;
	}
yy566:
	YYDEBUG(566, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy513;
	if(yych >= ':')	goto yy513;
	goto yy567;
yy567:
	YYDEBUG(567, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '/')	goto yy568;
	if(yych <= '9')	goto yy564;
	goto yy568;
yy568:
	YYDEBUG(568, *YYCURSOR);

{
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy569:
	YYDEBUG(569, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy529;
		goto yy513;
	} else {
		if(yych <= '9')	goto yy567;
		if(yych <= ':')	goto yy529;
		goto yy513;
	}
yy570:
	YYDEBUG(570, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '1'){
		if(yych == '.')	goto yy571;
		if(yych <= '/')	goto yy524;
		goto yy572;
	} else {
		if(yych <= '2')	goto yy573;
		if(yych <= '9')	goto yy574;
		if(yych <= ':')	goto yy529;
		goto yy524;
	}
yy571:
	YYDEBUG(571, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '2'){
		if(yych <= '/')	goto yy524;
		if(yych <= '1')	goto yy577;
		goto yy578;
	} else {
		if(yych <= '5')	goto yy579;
		if(yych <= '9')	goto yy580;
		goto yy524;
	}
yy572:
	YYDEBUG(572, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy529;
		goto yy513;
	} else {
		if(yych <= '9')	goto yy576;
		if(yych <= ':')	goto yy529;
		goto yy513;
	}
yy573:
	YYDEBUG(573, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy529;
		goto yy513;
	} else {
		if(yych <= '3')	goto yy576;
		if(yych <= '9')	goto yy575;
		if(yych <= ':')	goto yy529;
		goto yy513;
	}
yy574:
	YYDEBUG(574, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy529;
		goto yy513;
	} else {
		if(yych <= '9')	goto yy575;
		if(yych <= ':')	goto yy529;
		goto yy513;
	}
yy575:
	YYDEBUG(575, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy568;
	if(yych <= '9')	goto yy563;
	goto yy568;
yy576:
	YYDEBUG(576, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy529;
		goto yy568;
	} else {
		if(yych <= '9')	goto yy563;
		if(yych <= ':')	goto yy529;
		goto yy568;
	}
yy577:
	YYDEBUG(577, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy581;
		goto yy513;
	} else {
		if(yych <= '9')	goto yy586;
		if(yych <= ':')	goto yy581;
		goto yy513;
	}
yy578:
	YYDEBUG(578, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy581;
		goto yy513;
	} else {
		if(yych <= '3')	goto yy586;
		if(yych <= '9')	goto yy585;
		if(yych <= ':')	goto yy581;
		goto yy513;
	}
yy579:
	YYDEBUG(579, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy581;
		goto yy513;
	} else {
		if(yych <= '9')	goto yy585;
		if(yych <= ':')	goto yy581;
		goto yy513;
	}
yy580:
	YYDEBUG(580, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych != '.')	goto yy513;
		goto yy581;
	} else {
		if(yych <= '9')	goto yy528;
		if(yych >= ';')	goto yy513;
		goto yy581;
	}
yy581:
	YYDEBUG(581, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy582;
	if(yych <= '6')	goto yy583;
	if(yych <= '9')	goto yy532;
	goto yy56;
yy582:
	YYDEBUG(582, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy533;
		goto yy531;
	} else {
		if(yych <= '9')	goto yy584;
		if(yych <= ':')	goto yy533;
		goto yy531;
	}
yy583:
	YYDEBUG(583, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy533;
		goto yy531;
	} else {
		if(yych <= '0')	goto yy537;
		if(yych == ':')	goto yy533;
		goto yy531;
	}
yy584:
	YYDEBUG(584, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '-'){
		if(yych <= '('){
			if(yych == ' ')	goto yy538;
			if(yych <= '\'')	goto yy531;
			goto yy541;
		} else {
			if(yych == '+')	goto yy540;
			if(yych <= ',')	goto yy531;
			goto yy540;
		}
	} else {
		if(yych <= '@'){
			if(yych <= '.')	goto yy533;
			if(yych == ':')	goto yy533;
			goto yy531;
		} else {
			if(yych <= 'Z')	goto yy542;
			if(yych <= '`')	goto yy531;
			if(yych <= 'z')	goto yy543;
			goto yy531;
		}
	}
yy585:
	YYDEBUG(585, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy533;
		goto yy513;
	} else {
		if(yych <= '9')	goto yy563;
		if(yych <= ':')	goto yy533;
		goto yy513;
	}
yy586:
	YYDEBUG(586, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy581;
		goto yy513;
	} else {
		if(yych <= '9')	goto yy563;
		if(yych <= ':')	goto yy581;
		goto yy513;
	}
yy587:
	YYDEBUG(587, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '1'){
		if(yych == '.')	goto yy571;
		if(yych <= '/')	goto yy524;
		goto yy572;
	} else {
		if(yych <= '2')	goto yy573;
		if(yych <= '9')	goto yy574;
		if(yych <= ':')	goto yy529;
		goto yy524;
	}
yy588:
	YYDEBUG(588, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '1'){
		if(yych <= '/')	goto yy524;
		if(yych <= '0')	goto yy570;
		goto yy591;
	} else {
		if(yych <= '2')	goto yy598;
		if(yych <= '9')	goto yy591;
		goto yy524;
	}
yy589:
	YYDEBUG(589, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy524;
	if(yych == '2')	goto yy598;
	if(yych <= '9')	goto yy591;
	goto yy524;
yy590:
	YYDEBUG(590, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy524;
	if(yych <= '1')	goto yy591;
	if(yych <= '2')	goto yy521;
	if(yych <= '9')	goto yy522;
	goto yy524;
yy591:
	YYDEBUG(591, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case '-':	goto yy592;
	case '.':	goto yy571;
	case '0':
	case '1':	goto yy572;
	case '2':	goto yy573;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy574;
	case ':':	goto yy529;
	default:	goto yy524;
	}
yy592:
	YYDEBUG(592, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= ':')	goto yy56;
	goto yy593;
yy593:
	YYDEBUG(593, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '/')	goto yy594;
	if(yych <= '9')	goto yy595;
	goto yy594;
yy594:
	YYDEBUG(594, *YYCURSOR);

{
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy595:
	YYDEBUG(595, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy594;
	if(yych >= ':')	goto yy594;
	goto yy596;
yy596:
	YYDEBUG(596, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy594;
	if(yych >= ':')	goto yy594;
	goto yy597;
yy597:
	YYDEBUG(597, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy594;
yy598:
	YYDEBUG(598, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case '-':	goto yy592;
	case '.':	goto yy571;
	case '0':
	case '1':	goto yy572;
	case '2':	goto yy573;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy574;
	case ':':	goto yy529;
	default:	goto yy524;
	}
yy599:
	YYDEBUG(599, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'C'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'B')	goto yy51;
			goto yy507;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'c')	goto yy600;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy600:
	YYDEBUG(600, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy511;
				goto yy509;
			} else {
				if(yych <= '/')	goto yy55;
				if(yych <= '9')	goto yy509;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'E'){
				if(yych <= 'D')	goto yy52;
				goto yy516;
			} else {
				if(yych <= 'Z')	goto yy52;
				if(yych <= '^')	goto yy3;
				goto yy55;
			}
		} else {
			if(yych <= 'd'){
				if(yych <= '`')	goto yy3;
				goto yy60;
			} else {
				if(yych <= 'e')	goto yy601;
				if(yych <= 'z')	goto yy60;
				goto yy3;
			}
		}
	}
yy601:
	YYDEBUG(601, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'M'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'L')	goto yy3;
			goto yy517;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'm')	goto yy602;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy602:
	YYDEBUG(602, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy518;
	if(yych != 'b')	goto yy62;
	goto yy603;
yy603:
	YYDEBUG(603, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy519;
	if(yych != 'e')	goto yy62;
	goto yy604;
yy604:
	YYDEBUG(604, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'R')	goto yy508;
			goto yy56;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'r')	goto yy605;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy605:
	YYDEBUG(605, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych == '/')	goto yy55;
		goto yy509;
	} else {
		if(yych <= '_')	goto yy55;
		if(yych <= '`')	goto yy509;
		if(yych <= 'z')	goto yy61;
		goto yy509;
	}
yy606:
	YYDEBUG(606, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'V'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'U')	goto yy51;
			goto yy618;
		}
	} else {
		if(yych <= 'u'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'v')	goto yy618;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy607:
	YYDEBUG(607, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'V'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'U')	goto yy51;
			goto yy618;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'v')	goto yy619;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy608:
	YYDEBUG(608, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'X'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'W')	goto yy51;
			goto yy614;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'x')	goto yy617;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy609:
	YYDEBUG(609, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy51;
			goto yy612;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy615;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy610:
	YYDEBUG(610, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'X'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'W')	goto yy51;
			goto yy614;
		}
	} else {
		if(yych <= 'w'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'x')	goto yy614;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy611:
	YYDEBUG(611, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy51;
			goto yy612;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'n')	goto yy612;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy612:
	YYDEBUG(612, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy52;
			goto yy613;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy3;
			goto yy52;
		} else {
			if(yych <= 't')	goto yy613;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy613:
	YYDEBUG(613, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'G'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'H')	goto yy176;
		if(yych == 'h')	goto yy176;
		goto yy3;
	}
yy614:
	YYDEBUG(614, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy52;
			goto yy452;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy3;
			goto yy52;
		} else {
			if(yych <= 't')	goto yy452;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy615:
	YYDEBUG(615, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy52;
			goto yy613;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 't')	goto yy616;
			if(yych <= 'z')	goto yy60;
			goto yy3;
		}
	}
yy616:
	YYDEBUG(616, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'G')	goto yy3;
			goto yy176;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy617:
	YYDEBUG(617, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy52;
			goto yy452;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 't')	goto yy455;
			if(yych <= 'z')	goto yy60;
			goto yy3;
		}
	}
yy618:
	YYDEBUG(618, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '-')	goto yy511;
			if(yych == '/')	goto yy3;
			goto yy509;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych == 'E')	goto yy620;
			goto yy52;
		} else {
			if(yych <= 'd'){
				if(yych <= '`')	goto yy3;
				goto yy52;
			} else {
				if(yych <= 'e')	goto yy620;
				if(yych <= 'z')	goto yy52;
				goto yy3;
			}
		}
	}
yy619:
	YYDEBUG(619, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy511;
				goto yy509;
			} else {
				if(yych <= '/')	goto yy55;
				if(yych <= '9')	goto yy509;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'E'){
				if(yych <= 'D')	goto yy52;
				goto yy620;
			} else {
				if(yych <= 'Z')	goto yy52;
				if(yych <= '^')	goto yy3;
				goto yy55;
			}
		} else {
			if(yych <= 'd'){
				if(yych <= '`')	goto yy3;
				goto yy60;
			} else {
				if(yych <= 'e')	goto yy621;
				if(yych <= 'z')	goto yy60;
				goto yy3;
			}
		}
	}
yy620:
	YYDEBUG(620, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'L'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'M')	goto yy622;
		if(yych == 'm')	goto yy622;
		goto yy3;
	}
yy621:
	YYDEBUG(621, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'M'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'L')	goto yy3;
			goto yy622;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'm')	goto yy623;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy622:
	YYDEBUG(622, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy624;
	if(yych == 'b')	goto yy624;
	goto yy56;
yy623:
	YYDEBUG(623, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy624;
	if(yych == 'b')	goto yy625;
	goto yy62;
yy624:
	YYDEBUG(624, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy626;
	if(yych == 'e')	goto yy626;
	goto yy56;
yy625:
	YYDEBUG(625, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy626;
	if(yych == 'e')	goto yy627;
	goto yy62;
yy626:
	YYDEBUG(626, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy508;
	if(yych == 'r')	goto yy508;
	goto yy56;
yy627:
	YYDEBUG(627, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'R')	goto yy508;
			goto yy56;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'r')	goto yy605;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy628:
	YYDEBUG(628, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy51;
			goto yy629;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 't')	goto yy629;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy629:
	YYDEBUG(629, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '-')	goto yy511;
			if(yych == '/')	goto yy3;
			goto yy509;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych != 'O')	goto yy52;
			goto yy630;
		} else {
			if(yych <= 'n'){
				if(yych <= '`')	goto yy3;
				goto yy52;
			} else {
				if(yych <= 'o')	goto yy630;
				if(yych <= 'z')	goto yy52;
				goto yy3;
			}
		}
	}
yy630:
	YYDEBUG(630, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'B')	goto yy631;
		if(yych != 'b')	goto yy3;
		goto yy631;
	}
yy631:
	YYDEBUG(631, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy632;
	if(yych != 'e')	goto yy56;
	goto yy632;
yy632:
	YYDEBUG(632, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy508;
	if(yych == 'r')	goto yy508;
	goto yy56;
yy633:
	YYDEBUG(633, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy51;
			goto yy629;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 't')	goto yy634;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy634:
	YYDEBUG(634, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy511;
				goto yy509;
			} else {
				if(yych <= '/')	goto yy55;
				if(yych <= '9')	goto yy509;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'O'){
				if(yych <= 'N')	goto yy52;
				goto yy630;
			} else {
				if(yych <= 'Z')	goto yy52;
				if(yych <= '^')	goto yy3;
				goto yy55;
			}
		} else {
			if(yych <= 'n'){
				if(yych <= '`')	goto yy3;
				goto yy60;
			} else {
				if(yych <= 'o')	goto yy635;
				if(yych <= 'z')	goto yy60;
				goto yy3;
			}
		}
	}
yy635:
	YYDEBUG(635, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'B'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'A')	goto yy3;
			goto yy631;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'b')	goto yy636;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy636:
	YYDEBUG(636, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy632;
	if(yych != 'e')	goto yy62;
	goto yy637;
yy637:
	YYDEBUG(637, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'R')	goto yy508;
			goto yy56;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'r')	goto yy605;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy638:
	YYDEBUG(638, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'V'){
		if(yych <= 'B'){
			if(yych == ')')	goto yy49;
			if(yych <= '@')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'O'){
				if(yych <= 'C')	goto yy653;
				goto yy51;
			} else {
				if(yych <= 'P')	goto yy652;
				if(yych <= 'U')	goto yy51;
				goto yy654;
			}
		}
	} else {
		if(yych <= 'o'){
			if(yych <= '`'){
				if(yych <= 'Z')	goto yy51;
				goto yy3;
			} else {
				if(yych == 'c')	goto yy653;
				goto yy51;
			}
		} else {
			if(yych <= 'u'){
				if(yych <= 'p')	goto yy652;
				goto yy51;
			} else {
				if(yych <= 'v')	goto yy654;
				if(yych <= 'z')	goto yy51;
				goto yy3;
			}
		}
	}
yy639:
	YYDEBUG(639, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy51;
			goto yy647;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 't')	goto yy647;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy640:
	YYDEBUG(640, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'X'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'W')	goto yy51;
			goto yy645;
		}
	} else {
		if(yych <= 'w'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'x')	goto yy645;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy641:
	YYDEBUG(641, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy51;
			goto yy642;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'n')	goto yy642;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy642:
	YYDEBUG(642, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy154;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy154;
			if(yych <= 'C')	goto yy52;
			goto yy643;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy154;
			goto yy52;
		} else {
			if(yych <= 'd')	goto yy643;
			if(yych <= 'z')	goto yy52;
			goto yy154;
		}
	}
yy643:
	YYDEBUG(643, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'A')	goto yy644;
		if(yych != 'a')	goto yy3;
		goto yy644;
	}
yy644:
	YYDEBUG(644, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy160;
	if(yych == 'y')	goto yy160;
	goto yy56;
yy645:
	YYDEBUG(645, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy52;
			goto yy646;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy3;
			goto yy52;
		} else {
			if(yych <= 't')	goto yy646;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy646:
	YYDEBUG(646, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'G'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'H')	goto yy176;
		if(yych == 'h')	goto yy176;
		goto yy3;
	}
yy647:
	YYDEBUG(647, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy154;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy154;
			if(yych <= 'T')	goto yy52;
			goto yy648;
		}
	} else {
		if(yych <= 't'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy154;
			goto yy52;
		} else {
			if(yych <= 'u')	goto yy648;
			if(yych <= 'z')	goto yy52;
			goto yy154;
		}
	}
yy648:
	YYDEBUG(648, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'Q'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'R')	goto yy649;
		if(yych != 'r')	goto yy3;
		goto yy649;
	}
yy649:
	YYDEBUG(649, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy650;
	if(yych != 'd')	goto yy56;
	goto yy650;
yy650:
	YYDEBUG(650, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy651;
	if(yych != 'a')	goto yy56;
	goto yy651;
yy651:
	YYDEBUG(651, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy160;
	if(yych == 'y')	goto yy160;
	goto yy56;
yy652:
	YYDEBUG(652, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '-')	goto yy511;
			if(yych == '/')	goto yy3;
			goto yy509;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych == 'T')	goto yy657;
			goto yy52;
		} else {
			if(yych <= 's'){
				if(yych <= '`')	goto yy3;
				goto yy52;
			} else {
				if(yych <= 't')	goto yy657;
				if(yych <= 'z')	goto yy52;
				goto yy3;
			}
		}
	}
yy653:
	YYDEBUG(653, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'N')	goto yy52;
			goto yy656;
		}
	} else {
		if(yych <= 'n'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy3;
			goto yy52;
		} else {
			if(yych <= 'o')	goto yy656;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy654:
	YYDEBUG(654, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy52;
			goto yy655;
		}
	} else {
		if(yych <= 'd'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy3;
			goto yy52;
		} else {
			if(yych <= 'e')	goto yy655;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy655:
	YYDEBUG(655, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'M'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'N')	goto yy233;
		if(yych == 'n')	goto yy233;
		goto yy3;
	}
yy656:
	YYDEBUG(656, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'M'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'N')	goto yy236;
		if(yych == 'n')	goto yy236;
		goto yy3;
	}
yy657:
	YYDEBUG(657, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= ')'){
			if(yych <= 0x1F)	goto yy3;
			if(yych <= '(')	goto yy509;
			goto yy510;
		} else {
			if(yych == '-')	goto yy511;
			goto yy509;
		}
	} else {
		if(yych <= 'D'){
			if(yych <= '/')	goto yy3;
			if(yych <= '9')	goto yy509;
			goto yy3;
		} else {
			if(yych <= 'E')	goto yy658;
			if(yych != 'e')	goto yy3;
			goto yy658;
		}
	}
yy658:
	YYDEBUG(658, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy659;
	if(yych != 'm')	goto yy56;
	goto yy659;
yy659:
	YYDEBUG(659, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy660;
	if(yych != 'b')	goto yy56;
	goto yy660;
yy660:
	YYDEBUG(660, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy661;
	if(yych != 'e')	goto yy56;
	goto yy661;
yy661:
	YYDEBUG(661, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy508;
	if(yych == 'r')	goto yy508;
	goto yy56;
yy662:
	YYDEBUG(662, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'V'){
		if(yych <= '@'){
			if(yych <= ')'){
				if(yych <= '(')	goto yy3;
				goto yy49;
			} else {
				if(yych == '/')	goto yy55;
				goto yy3;
			}
		} else {
			if(yych <= 'O'){
				if(yych == 'C')	goto yy653;
				goto yy51;
			} else {
				if(yych <= 'P')	goto yy652;
				if(yych <= 'U')	goto yy51;
				goto yy654;
			}
		}
	} else {
		if(yych <= 'c'){
			if(yych <= '_'){
				if(yych <= 'Z')	goto yy51;
				if(yych <= '^')	goto yy3;
				goto yy55;
			} else {
				if(yych <= '`')	goto yy3;
				if(yych <= 'b')	goto yy54;
				goto yy677;
			}
		} else {
			if(yych <= 'u'){
				if(yych == 'p')	goto yy676;
				goto yy54;
			} else {
				if(yych <= 'v')	goto yy678;
				if(yych <= 'z')	goto yy54;
				goto yy3;
			}
		}
	}
yy663:
	YYDEBUG(663, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy51;
			goto yy647;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 't')	goto yy671;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy664:
	YYDEBUG(664, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'X'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'W')	goto yy51;
			goto yy645;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'x')	goto yy669;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy665:
	YYDEBUG(665, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy51;
			goto yy642;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy666;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy666:
	YYDEBUG(666, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy154;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy154;
			if(yych <= 'C')	goto yy52;
			goto yy643;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy154;
		} else {
			if(yych == 'd')	goto yy667;
			if(yych <= 'z')	goto yy60;
			goto yy154;
		}
	}
yy667:
	YYDEBUG(667, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			goto yy644;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy668;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy668:
	YYDEBUG(668, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy160;
	if(yych == 'y')	goto yy169;
	goto yy62;
yy669:
	YYDEBUG(669, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy52;
			goto yy646;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 't')	goto yy670;
			if(yych <= 'z')	goto yy60;
			goto yy3;
		}
	}
yy670:
	YYDEBUG(670, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'G')	goto yy3;
			goto yy176;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy671:
	YYDEBUG(671, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'U'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy154;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy154;
			if(yych <= 'T')	goto yy52;
			goto yy648;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy154;
		} else {
			if(yych == 'u')	goto yy672;
			if(yych <= 'z')	goto yy60;
			goto yy154;
		}
	}
yy672:
	YYDEBUG(672, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'Q')	goto yy3;
			goto yy649;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'r')	goto yy673;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy673:
	YYDEBUG(673, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'D')	goto yy650;
	if(yych != 'd')	goto yy62;
	goto yy674;
yy674:
	YYDEBUG(674, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy651;
	if(yych != 'a')	goto yy62;
	goto yy675;
yy675:
	YYDEBUG(675, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy160;
	if(yych == 'y')	goto yy169;
	goto yy62;
yy676:
	YYDEBUG(676, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy511;
				goto yy509;
			} else {
				if(yych <= '/')	goto yy55;
				if(yych <= '9')	goto yy509;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'T'){
				if(yych <= 'S')	goto yy52;
				goto yy657;
			} else {
				if(yych <= 'Z')	goto yy52;
				if(yych <= '^')	goto yy3;
				goto yy55;
			}
		} else {
			if(yych <= 's'){
				if(yych <= '`')	goto yy3;
				goto yy60;
			} else {
				if(yych <= 't')	goto yy681;
				if(yych <= 'z')	goto yy60;
				goto yy3;
			}
		}
	}
yy677:
	YYDEBUG(677, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'O'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'N')	goto yy52;
			goto yy656;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'o')	goto yy680;
			if(yych <= 'z')	goto yy60;
			goto yy3;
		}
	}
yy678:
	YYDEBUG(678, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'E'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'D')	goto yy52;
			goto yy655;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'e')	goto yy679;
			if(yych <= 'z')	goto yy60;
			goto yy3;
		}
	}
yy679:
	YYDEBUG(679, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'M')	goto yy3;
			goto yy233;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy358;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy680:
	YYDEBUG(680, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'M')	goto yy3;
			goto yy236;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy361;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy681:
	YYDEBUG(681, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '-')	goto yy511;
			if(yych == '/')	goto yy55;
			goto yy509;
		}
	} else {
		if(yych <= '_'){
			if(yych == 'E')	goto yy658;
			if(yych <= '^')	goto yy3;
			goto yy55;
		} else {
			if(yych <= 'd'){
				if(yych <= '`')	goto yy3;
				goto yy61;
			} else {
				if(yych <= 'e')	goto yy682;
				if(yych <= 'z')	goto yy61;
				goto yy3;
			}
		}
	}
yy682:
	YYDEBUG(682, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy659;
	if(yych != 'm')	goto yy62;
	goto yy683;
yy683:
	YYDEBUG(683, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy660;
	if(yych != 'b')	goto yy62;
	goto yy684;
yy684:
	YYDEBUG(684, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy661;
	if(yych != 'e')	goto yy62;
	goto yy685;
yy685:
	YYDEBUG(685, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'R')	goto yy508;
			goto yy56;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'r')	goto yy605;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy686:
	YYDEBUG(686, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'G'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'F')	goto yy51;
			goto yy693;
		}
	} else {
		if(yych <= 'f'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'g')	goto yy693;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy687:
	YYDEBUG(687, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy51;
			goto yy691;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'r')	goto yy691;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy688:
	YYDEBUG(688, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'N')	goto yy51;
			goto yy689;
		}
	} else {
		if(yych <= 'n'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'o')	goto yy689;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy689:
	YYDEBUG(689, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '@'){
		if(yych == ')')	goto yy49;
		goto yy690;
	} else {
		if(yych <= 'Z')	goto yy52;
		if(yych <= '`')	goto yy690;
		if(yych <= 'z')	goto yy52;
		goto yy690;
	}
yy690:
	YYDEBUG(690, *YYCURSOR);

{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
yy691:
	YYDEBUG(691, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '-')	goto yy511;
			if(yych == '/')	goto yy3;
			goto yy509;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych != 'I')	goto yy52;
			goto yy692;
		} else {
			if(yych <= 'h'){
				if(yych <= '`')	goto yy3;
				goto yy52;
			} else {
				if(yych <= 'i')	goto yy692;
				if(yych <= 'z')	goto yy52;
				goto yy3;
			}
		}
	}
yy692:
	YYDEBUG(692, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'K'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'L')	goto yy508;
		if(yych == 'l')	goto yy508;
		goto yy3;
	}
yy693:
	YYDEBUG(693, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '-')	goto yy511;
			if(yych == '/')	goto yy3;
			goto yy509;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych != 'U')	goto yy52;
			goto yy694;
		} else {
			if(yych <= 't'){
				if(yych <= '`')	goto yy3;
				goto yy52;
			} else {
				if(yych <= 'u')	goto yy694;
				if(yych <= 'z')	goto yy52;
				goto yy3;
			}
		}
	}
yy694:
	YYDEBUG(694, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'S')	goto yy695;
		if(yych != 's')	goto yy3;
		goto yy695;
	}
yy695:
	YYDEBUG(695, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy508;
	if(yych == 't')	goto yy508;
	goto yy56;
yy696:
	YYDEBUG(696, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'G'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'F')	goto yy51;
			goto yy693;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'g')	goto yy702;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy697:
	YYDEBUG(697, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy51;
			goto yy691;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'r')	goto yy700;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy698:
	YYDEBUG(698, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'O'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'N')	goto yy51;
			goto yy689;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'o')	goto yy699;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy699:
	YYDEBUG(699, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy690;
			goto yy49;
		} else {
			if(yych == '/')	goto yy55;
			goto yy690;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '^')	goto yy690;
			goto yy55;
		} else {
			if(yych <= '`')	goto yy690;
			if(yych <= 'z')	goto yy60;
			goto yy690;
		}
	}
yy700:
	YYDEBUG(700, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy511;
				goto yy509;
			} else {
				if(yych <= '/')	goto yy55;
				if(yych <= '9')	goto yy509;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'I'){
				if(yych <= 'H')	goto yy52;
				goto yy692;
			} else {
				if(yych <= 'Z')	goto yy52;
				if(yych <= '^')	goto yy3;
				goto yy55;
			}
		} else {
			if(yych <= 'h'){
				if(yych <= '`')	goto yy3;
				goto yy60;
			} else {
				if(yych <= 'i')	goto yy701;
				if(yych <= 'z')	goto yy60;
				goto yy3;
			}
		}
	}
yy701:
	YYDEBUG(701, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'L'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'K')	goto yy3;
			goto yy508;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'l')	goto yy605;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy702:
	YYDEBUG(702, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy511;
				goto yy509;
			} else {
				if(yych <= '/')	goto yy55;
				if(yych <= '9')	goto yy509;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'U'){
				if(yych <= 'T')	goto yy52;
				goto yy694;
			} else {
				if(yych <= 'Z')	goto yy52;
				if(yych <= '^')	goto yy3;
				goto yy55;
			}
		} else {
			if(yych <= 't'){
				if(yych <= '`')	goto yy3;
				goto yy60;
			} else {
				if(yych <= 'u')	goto yy703;
				if(yych <= 'z')	goto yy60;
				goto yy3;
			}
		}
	}
yy703:
	YYDEBUG(703, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'R')	goto yy3;
			goto yy695;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 's')	goto yy704;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy704:
	YYDEBUG(704, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'T')	goto yy508;
			goto yy56;
		}
	} else {
		if(yych <= 's'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 't')	goto yy605;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy705:
	YYDEBUG(705, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych <= '@'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych == 'R')	goto yy715;
			if(yych <= 'X')	goto yy51;
			goto yy717;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			if(yych <= 'q')	goto yy51;
			goto yy715;
		} else {
			if(yych == 'y')	goto yy717;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy706:
	YYDEBUG(706, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'Y'){
		if(yych <= '/'){
			if(yych == ')')	goto yy49;
			if(yych <= '.')	goto yy3;
			goto yy55;
		} else {
			if(yych <= 'Q'){
				if(yych <= '@')	goto yy3;
				goto yy51;
			} else {
				if(yych <= 'R')	goto yy715;
				if(yych <= 'X')	goto yy51;
				goto yy717;
			}
		}
	} else {
		if(yych <= 'q'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy51;
				goto yy3;
			} else {
				if(yych <= '_')	goto yy55;
				if(yych <= '`')	goto yy3;
				goto yy54;
			}
		} else {
			if(yych <= 'x'){
				if(yych <= 'r')	goto yy716;
				goto yy54;
			} else {
				if(yych <= 'y')	goto yy718;
				if(yych <= 'z')	goto yy54;
				goto yy3;
			}
		}
	}
yy707:
	YYDEBUG(707, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy51;
			goto yy709;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy712;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy708:
	YYDEBUG(708, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy51;
			goto yy709;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'n')	goto yy709;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy709:
	YYDEBUG(709, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy154;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy154;
			if(yych <= 'C')	goto yy52;
			goto yy710;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy154;
			goto yy52;
		} else {
			if(yych <= 'd')	goto yy710;
			if(yych <= 'z')	goto yy52;
			goto yy154;
		}
	}
yy710:
	YYDEBUG(710, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'A')	goto yy711;
		if(yych != 'a')	goto yy3;
		goto yy711;
	}
yy711:
	YYDEBUG(711, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy160;
	if(yych == 'y')	goto yy160;
	goto yy56;
yy712:
	YYDEBUG(712, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy154;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy154;
			if(yych <= 'C')	goto yy52;
			goto yy710;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy154;
		} else {
			if(yych == 'd')	goto yy713;
			if(yych <= 'z')	goto yy60;
			goto yy154;
		}
	}
yy713:
	YYDEBUG(713, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			goto yy711;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy714;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy714:
	YYDEBUG(714, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy160;
	if(yych == 'y')	goto yy169;
	goto yy62;
yy715:
	YYDEBUG(715, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '-')	goto yy511;
			if(yych == '/')	goto yy3;
			goto yy509;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych == 'C')	goto yy719;
			goto yy52;
		} else {
			if(yych <= 'b'){
				if(yych <= '`')	goto yy3;
				goto yy52;
			} else {
				if(yych <= 'c')	goto yy719;
				if(yych <= 'z')	goto yy52;
				goto yy3;
			}
		}
	}
yy716:
	YYDEBUG(716, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy511;
				goto yy509;
			} else {
				if(yych <= '/')	goto yy55;
				if(yych <= '9')	goto yy509;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'C'){
				if(yych <= 'B')	goto yy52;
				goto yy719;
			} else {
				if(yych <= 'Z')	goto yy52;
				if(yych <= '^')	goto yy3;
				goto yy55;
			}
		} else {
			if(yych <= 'b'){
				if(yych <= '`')	goto yy3;
				goto yy60;
			} else {
				if(yych <= 'c')	goto yy720;
				if(yych <= 'z')	goto yy60;
				goto yy3;
			}
		}
	}
yy717:
	YYDEBUG(717, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.'){
		if(yych <= ')'){
			if(yych <= 0x1F)	goto yy3;
			if(yych <= '(')	goto yy509;
			goto yy510;
		} else {
			if(yych == '-')	goto yy511;
			goto yy509;
		}
	} else {
		if(yych <= '@'){
			if(yych <= '/')	goto yy3;
			if(yych <= '9')	goto yy509;
			goto yy3;
		} else {
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy718:
	YYDEBUG(718, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ')'){
			if(yych <= 0x1F)	goto yy3;
			if(yych <= '(')	goto yy509;
			goto yy510;
		} else {
			if(yych == '-')	goto yy511;
			if(yych <= '.')	goto yy509;
			goto yy55;
		}
	} else {
		if(yych <= '^'){
			if(yych <= '9')	goto yy509;
			if(yych <= '@')	goto yy3;
			if(yych <= 'Z')	goto yy52;
			goto yy3;
		} else {
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy60;
			goto yy3;
		}
	}
yy719:
	YYDEBUG(719, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'G'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'H')	goto yy508;
		if(yych == 'h')	goto yy508;
		goto yy3;
	}
yy720:
	YYDEBUG(720, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'G')	goto yy3;
			goto yy508;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy605;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy721:
	YYDEBUG(721, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'B'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'A')	goto yy51;
			goto yy734;
		}
	} else {
		if(yych <= 'a'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'b')	goto yy734;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy722:
	YYDEBUG(722, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= '@'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych == 'F')	goto yy731;
			if(yych <= 'Q')	goto yy51;
			goto yy730;
		}
	} else {
		if(yych <= 'f'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			if(yych <= 'e')	goto yy51;
			goto yy731;
		} else {
			if(yych == 'r')	goto yy730;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy723:
	YYDEBUG(723, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'T')	goto yy51;
			goto yy728;
		}
	} else {
		if(yych <= 't'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'u')	goto yy728;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy724:
	YYDEBUG(724, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'I'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy51;
			goto yy725;
		}
	} else {
		if(yych <= 'h'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'i')	goto yy725;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy725:
	YYDEBUG(725, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'D'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy154;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy154;
			if(yych <= 'C')	goto yy52;
			goto yy726;
		}
	} else {
		if(yych <= 'c'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy154;
			goto yy52;
		} else {
			if(yych <= 'd')	goto yy726;
			if(yych <= 'z')	goto yy52;
			goto yy154;
		}
	}
yy726:
	YYDEBUG(726, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'A')	goto yy727;
		if(yych != 'a')	goto yy3;
		goto yy727;
	}
yy727:
	YYDEBUG(727, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy160;
	if(yych == 'y')	goto yy160;
	goto yy56;
yy728:
	YYDEBUG(728, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy52;
			goto yy729;
		}
	} else {
		if(yych <= 'q'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy3;
			goto yy52;
		} else {
			if(yych <= 'r')	goto yy729;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy729:
	YYDEBUG(729, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'T')	goto yy246;
		if(yych == 't')	goto yy246;
		goto yy3;
	}
yy730:
	YYDEBUG(730, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy52;
			goto yy733;
		}
	} else {
		if(yych <= 'r'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy3;
			goto yy52;
		} else {
			if(yych <= 's')	goto yy733;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy731:
	YYDEBUG(731, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy52;
			goto yy732;
		}
	} else {
		if(yych <= 's'){
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy3;
			goto yy52;
		} else {
			if(yych <= 't')	goto yy732;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy732:
	YYDEBUG(732, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'G'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'H')	goto yy176;
		if(yych == 'h')	goto yy176;
		goto yy3;
	}
yy733:
	YYDEBUG(733, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'T')	goto yy176;
		if(yych == 't')	goto yy176;
		goto yy3;
	}
yy734:
	YYDEBUG(734, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '-')	goto yy511;
			if(yych == '/')	goto yy3;
			goto yy509;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych != 'R')	goto yy52;
			goto yy735;
		} else {
			if(yych <= 'q'){
				if(yych <= '`')	goto yy3;
				goto yy52;
			} else {
				if(yych <= 'r')	goto yy735;
				if(yych <= 'z')	goto yy52;
				goto yy3;
			}
		}
	}
yy735:
	YYDEBUG(735, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'U')	goto yy736;
		if(yych != 'u')	goto yy3;
		goto yy736;
	}
yy736:
	YYDEBUG(736, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy737;
	if(yych != 'a')	goto yy56;
	goto yy737;
yy737:
	YYDEBUG(737, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy738;
	if(yych != 'r')	goto yy56;
	goto yy738;
yy738:
	YYDEBUG(738, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy508;
	if(yych == 'y')	goto yy508;
	goto yy56;
yy739:
	YYDEBUG(739, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'B'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'A')	goto yy51;
			goto yy734;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'b')	goto yy752;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy740:
	YYDEBUG(740, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '/'){
			if(yych == ')')	goto yy49;
			if(yych <= '.')	goto yy3;
			goto yy55;
		} else {
			if(yych <= 'E'){
				if(yych <= '@')	goto yy3;
				goto yy51;
			} else {
				if(yych <= 'F')	goto yy731;
				if(yych <= 'Q')	goto yy51;
				goto yy730;
			}
		}
	} else {
		if(yych <= 'e'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy51;
				goto yy3;
			} else {
				if(yych <= '_')	goto yy55;
				if(yych <= '`')	goto yy3;
				goto yy54;
			}
		} else {
			if(yych <= 'q'){
				if(yych <= 'f')	goto yy749;
				goto yy54;
			} else {
				if(yych <= 'r')	goto yy748;
				if(yych <= 'z')	goto yy54;
				goto yy3;
			}
		}
	}
yy741:
	YYDEBUG(741, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'U'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'T')	goto yy51;
			goto yy728;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'u')	goto yy746;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy742:
	YYDEBUG(742, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'I'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy51;
			goto yy725;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'i')	goto yy743;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy743:
	YYDEBUG(743, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy154;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy154;
			if(yych <= 'C')	goto yy52;
			goto yy726;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy154;
		} else {
			if(yych == 'd')	goto yy744;
			if(yych <= 'z')	goto yy60;
			goto yy154;
		}
	}
yy744:
	YYDEBUG(744, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			goto yy727;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy745;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy745:
	YYDEBUG(745, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy160;
	if(yych == 'y')	goto yy169;
	goto yy62;
yy746:
	YYDEBUG(746, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'R'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'Q')	goto yy52;
			goto yy729;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'r')	goto yy747;
			if(yych <= 'z')	goto yy60;
			goto yy3;
		}
	}
yy747:
	YYDEBUG(747, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'S')	goto yy3;
			goto yy246;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 't')	goto yy376;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy748:
	YYDEBUG(748, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'R')	goto yy52;
			goto yy733;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 's')	goto yy751;
			if(yych <= 'z')	goto yy60;
			goto yy3;
		}
	}
yy749:
	YYDEBUG(749, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'S')	goto yy52;
			goto yy732;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy52;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 't')	goto yy750;
			if(yych <= 'z')	goto yy60;
			goto yy3;
		}
	}
yy750:
	YYDEBUG(750, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'G')	goto yy3;
			goto yy176;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'h')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy751:
	YYDEBUG(751, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'S')	goto yy3;
			goto yy176;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 't')	goto yy317;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy752:
	YYDEBUG(752, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy511;
				goto yy509;
			} else {
				if(yych <= '/')	goto yy55;
				if(yych <= '9')	goto yy509;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'R'){
				if(yych <= 'Q')	goto yy52;
				goto yy735;
			} else {
				if(yych <= 'Z')	goto yy52;
				if(yych <= '^')	goto yy3;
				goto yy55;
			}
		} else {
			if(yych <= 'q'){
				if(yych <= '`')	goto yy3;
				goto yy60;
			} else {
				if(yych <= 'r')	goto yy753;
				if(yych <= 'z')	goto yy60;
				goto yy3;
			}
		}
	}
yy753:
	YYDEBUG(753, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'U'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= 'T')	goto yy3;
			goto yy736;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'u')	goto yy754;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy754:
	YYDEBUG(754, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy737;
	if(yych != 'a')	goto yy62;
	goto yy755;
yy755:
	YYDEBUG(755, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy738;
	if(yych != 'r')	goto yy62;
	goto yy756;
yy756:
	YYDEBUG(756, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'Y')	goto yy508;
			goto yy56;
		}
	} else {
		if(yych <= 'x'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'y')	goto yy605;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy757:
	YYDEBUG(757, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= '@'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych == 'L')	goto yy764;
			if(yych <= 'M')	goto yy51;
			goto yy763;
		}
	} else {
		if(yych <= 'l'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			if(yych <= 'k')	goto yy51;
			goto yy764;
		} else {
			if(yych == 'n')	goto yy763;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy758:
	YYDEBUG(758, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy51;
			goto yy759;
		}
	} else {
		if(yych <= 'm'){
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'n')	goto yy759;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy759:
	YYDEBUG(759, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '-')	goto yy511;
			if(yych == '/')	goto yy3;
			goto yy509;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych != 'U')	goto yy52;
			goto yy760;
		} else {
			if(yych <= 't'){
				if(yych <= '`')	goto yy3;
				goto yy52;
			} else {
				if(yych <= 'u')	goto yy760;
				if(yych <= 'z')	goto yy52;
				goto yy3;
			}
		}
	}
yy760:
	YYDEBUG(760, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych == ')')	goto yy49;
		goto yy3;
	} else {
		if(yych <= 'A')	goto yy761;
		if(yych != 'a')	goto yy3;
		goto yy761;
	}
yy761:
	YYDEBUG(761, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy762;
	if(yych != 'r')	goto yy56;
	goto yy762;
yy762:
	YYDEBUG(762, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy508;
	if(yych == 'y')	goto yy508;
	goto yy56;
yy763:
	YYDEBUG(763, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '-')	goto yy511;
			if(yych == '/')	goto yy3;
			goto yy509;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych == 'E')	goto yy765;
			goto yy52;
		} else {
			if(yych <= 'd'){
				if(yych <= '`')	goto yy3;
				goto yy52;
			} else {
				if(yych <= 'e')	goto yy765;
				if(yych <= 'z')	goto yy52;
				goto yy3;
			}
		}
	}
yy764:
	YYDEBUG(764, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '-')	goto yy511;
			if(yych == '/')	goto yy3;
			goto yy509;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '@')	goto yy3;
			if(yych != 'Y')	goto yy52;
			goto yy765;
		} else {
			if(yych <= 'x'){
				if(yych <= '`')	goto yy3;
				goto yy52;
			} else {
				if(yych <= 'y')	goto yy765;
				if(yych <= 'z')	goto yy52;
				goto yy3;
			}
		}
	}
yy765:
	YYDEBUG(765, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= ')'){
		if(yych <= 0x1F)	goto yy3;
		if(yych <= '(')	goto yy509;
		goto yy510;
	} else {
		if(yych == '/')	goto yy3;
		if(yych <= '9')	goto yy509;
		goto yy3;
	}
yy766:
	YYDEBUG(766, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '/'){
			if(yych == ')')	goto yy49;
			if(yych <= '.')	goto yy3;
			goto yy55;
		} else {
			if(yych <= 'K'){
				if(yych <= '@')	goto yy3;
				goto yy51;
			} else {
				if(yych <= 'L')	goto yy764;
				if(yych <= 'M')	goto yy51;
				goto yy763;
			}
		}
	} else {
		if(yych <= 'k'){
			if(yych <= '^'){
				if(yych <= 'Z')	goto yy51;
				goto yy3;
			} else {
				if(yych <= '_')	goto yy55;
				if(yych <= '`')	goto yy3;
				goto yy54;
			}
		} else {
			if(yych <= 'm'){
				if(yych <= 'l')	goto yy773;
				goto yy54;
			} else {
				if(yych <= 'n')	goto yy772;
				if(yych <= 'z')	goto yy54;
				goto yy3;
			}
		}
	}
yy767:
	YYDEBUG(767, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			if(yych <= 'M')	goto yy51;
			goto yy759;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'Z')	goto yy51;
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych == 'n')	goto yy768;
			if(yych <= 'z')	goto yy54;
			goto yy3;
		}
	}
yy768:
	YYDEBUG(768, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy511;
				goto yy509;
			} else {
				if(yych <= '/')	goto yy55;
				if(yych <= '9')	goto yy509;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'U'){
				if(yych <= 'T')	goto yy52;
				goto yy760;
			} else {
				if(yych <= 'Z')	goto yy52;
				if(yych <= '^')	goto yy3;
				goto yy55;
			}
		} else {
			if(yych <= 't'){
				if(yych <= '`')	goto yy3;
				goto yy60;
			} else {
				if(yych <= 'u')	goto yy769;
				if(yych <= 'z')	goto yy60;
				goto yy3;
			}
		}
	}
yy769:
	YYDEBUG(769, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych <= '.'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych <= '/')	goto yy55;
			if(yych <= '@')	goto yy3;
			goto yy761;
		}
	} else {
		if(yych <= '`'){
			if(yych == '_')	goto yy55;
			goto yy3;
		} else {
			if(yych <= 'a')	goto yy770;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy770:
	YYDEBUG(770, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy762;
	if(yych != 'r')	goto yy62;
	goto yy771;
yy771:
	YYDEBUG(771, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '^'){
		if(yych <= '/'){
			if(yych <= '.')	goto yy56;
			goto yy55;
		} else {
			if(yych == 'Y')	goto yy508;
			goto yy56;
		}
	} else {
		if(yych <= 'x'){
			if(yych <= '_')	goto yy55;
			if(yych <= '`')	goto yy56;
			goto yy61;
		} else {
			if(yych <= 'y')	goto yy605;
			if(yych <= 'z')	goto yy61;
			goto yy56;
		}
	}
yy772:
	YYDEBUG(772, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy511;
				goto yy509;
			} else {
				if(yych <= '/')	goto yy55;
				if(yych <= '9')	goto yy509;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'E'){
				if(yych <= 'D')	goto yy52;
				goto yy765;
			} else {
				if(yych <= 'Z')	goto yy52;
				if(yych <= '^')	goto yy3;
				goto yy55;
			}
		} else {
			if(yych <= 'd'){
				if(yych <= '`')	goto yy3;
				goto yy60;
			} else {
				if(yych <= 'e')	goto yy774;
				if(yych <= 'z')	goto yy60;
				goto yy3;
			}
		}
	}
yy773:
	YYDEBUG(773, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy3;
			if(yych == ')')	goto yy510;
			goto yy509;
		} else {
			if(yych <= '.'){
				if(yych <= '-')	goto yy511;
				goto yy509;
			} else {
				if(yych <= '/')	goto yy55;
				if(yych <= '9')	goto yy509;
				goto yy3;
			}
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Y'){
				if(yych <= 'X')	goto yy52;
				goto yy765;
			} else {
				if(yych <= 'Z')	goto yy52;
				if(yych <= '^')	goto yy3;
				goto yy55;
			}
		} else {
			if(yych <= 'x'){
				if(yych <= '`')	goto yy3;
				goto yy60;
			} else {
				if(yych <= 'y')	goto yy774;
				if(yych <= 'z')	goto yy60;
				goto yy3;
			}
		}
	}
yy774:
	YYDEBUG(774, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= '('){
			if(yych <= 0x1F)	goto yy3;
			goto yy509;
		} else {
			if(yych <= ')')	goto yy510;
			if(yych <= '.')	goto yy509;
			goto yy55;
		}
	} else {
		if(yych <= '_'){
			if(yych <= '9')	goto yy509;
			if(yych <= '^')	goto yy3;
			goto yy55;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy61;
			goto yy3;
		}
	}
yy775:
	YYDEBUG(775, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ')'){
			if(yych <= 0x1F)	goto yy3;
			if(yych <= '(')	goto yy509;
			goto yy510;
		} else {
			if(yych == '/')	goto yy3;
			goto yy509;
		}
	} else {
		if(yych <= 'I'){
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy51;
			goto yy776;
		} else {
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy776:
	YYDEBUG(776, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= '('){
			if(yych <= 0x1F)	goto yy3;
			goto yy509;
		} else {
			if(yych <= ')')	goto yy510;
			if(yych <= '.')	goto yy509;
			goto yy3;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '9')	goto yy509;
			if(yych <= '@')	goto yy3;
			goto yy52;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy777:
	YYDEBUG(777, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ')'){
			if(yych <= 0x1F)	goto yy3;
			if(yych <= '(')	goto yy509;
			goto yy510;
		} else {
			if(yych == '/')	goto yy3;
			goto yy509;
		}
	} else {
		if(yych <= 'I'){
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy51;
			goto yy778;
		} else {
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy778:
	YYDEBUG(778, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ')'){
			if(yych <= 0x1F)	goto yy3;
			if(yych <= '(')	goto yy509;
			goto yy510;
		} else {
			if(yych == '/')	goto yy3;
			goto yy509;
		}
	} else {
		if(yych <= 'I'){
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy52;
			goto yy765;
		} else {
			if(yych <= 'Z')	goto yy52;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy779:
	YYDEBUG(779, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= '('){
			if(yych <= 0x1F)	goto yy3;
			goto yy509;
		} else {
			if(yych <= ')')	goto yy510;
			if(yych <= '.')	goto yy509;
			goto yy3;
		}
	} else {
		if(yych <= 'Z'){
			if(yych <= '9')	goto yy509;
			if(yych <= '@')	goto yy3;
			goto yy51;
		} else {
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy780:
	YYDEBUG(780, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= ')'){
			if(yych <= 0x1F)	goto yy3;
			if(yych <= '(')	goto yy509;
			goto yy510;
		} else {
			if(yych == '/')	goto yy3;
			goto yy509;
		}
	} else {
		if(yych <= 'I'){
			if(yych <= '@')	goto yy3;
			if(yych <= 'H')	goto yy51;
			goto yy776;
		} else {
			if(yych <= 'Z')	goto yy51;
			if(yych <= '`')	goto yy3;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy781:
	YYDEBUG(781, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
	goto yy782;
yy782:
	YYDEBUG(782, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	goto yy781;
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy790;
	case 'A':	case 'a':	goto yy798;
	case 'D':	case 'd':	goto yy785;
	case 'F':	case 'f':	goto yy786;
	case 'H':	case 'h':	goto yy73;
	case 'I':	goto yy793;
	case 'J':	case 'j':	goto yy797;
	case 'M':	case 'm':	goto yy784;
	case 'N':	case 'n':	goto yy800;
	case 'O':	case 'o':	goto yy799;
	case 'P':	case 'p':	goto yy802;
	case 'S':	case 's':	goto yy783;
	case 'T':	case 't':	goto yy78;
	case 'V':	goto yy795;
	case 'W':	case 'w':	goto yy75;
	case 'X':	goto yy796;
	case 'Y':	case 'y':	goto yy77;
	default:	goto yy56;
	}
yy783:
	YYDEBUG(783, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'D'){
			if(yych == 'A')	goto yy134;
			goto yy56;
		} else {
			if(yych <= 'E')	goto yy1259;
			if(yych <= 'T')	goto yy56;
			goto yy135;
		}
	} else {
		if(yych <= 'd'){
			if(yych == 'a')	goto yy134;
			goto yy56;
		} else {
			if(yych <= 'e')	goto yy1259;
			if(yych == 'u')	goto yy135;
			goto yy56;
		}
	}
yy784:
	YYDEBUG(784, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'H'){
			if(yych == 'A')	goto yy889;
			goto yy56;
		} else {
			if(yych <= 'I')	goto yy126;
			if(yych <= 'N')	goto yy56;
			goto yy125;
		}
	} else {
		if(yych <= 'h'){
			if(yych == 'a')	goto yy889;
			goto yy56;
		} else {
			if(yych <= 'i')	goto yy126;
			if(yych == 'o')	goto yy125;
			goto yy56;
		}
	}
yy785:
	YYDEBUG(785, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych == 'A')	goto yy122;
		if(yych <= 'D')	goto yy56;
		goto yy876;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy56;
			goto yy122;
		} else {
			if(yych == 'e')	goto yy876;
			goto yy56;
		}
	}
yy786:
	YYDEBUG(786, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= 'N'){
			if(yych == 'E')	goto yy892;
			goto yy56;
		} else {
			if(yych <= 'O')	goto yy99;
			if(yych <= 'Q')	goto yy56;
			goto yy98;
		}
	} else {
		if(yych <= 'n'){
			if(yych == 'e')	goto yy892;
			goto yy56;
		} else {
			if(yych <= 'o')	goto yy99;
			if(yych == 'r')	goto yy98;
			goto yy56;
		}
	}
yy787:
	YYDEBUG(787, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '-')	goto yy1010;
	if(yych <= '/')	goto yy70;
	if(yych <= '9')	goto yy1009;
	goto yy70;
yy788:
	YYDEBUG(788, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case '0':
	case '1':
	case '2':	goto yy952;
	case '3':	goto yy954;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy955;
	case 'A':	case 'a':	goto yy959;
	case 'D':	case 'd':	goto yy963;
	case 'F':	case 'f':	goto yy957;
	case 'J':	case 'j':	goto yy956;
	case 'M':	case 'm':	goto yy958;
	case 'N':	case 'n':	goto yy962;
	case 'O':	case 'o':	goto yy961;
	case 'S':	case 's':	goto yy960;
	default:	goto yy56;
	}
yy789:
	YYDEBUG(789, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case '0':	goto yy908;
	case '1':	goto yy909;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy910;
	case 'A':	case 'a':	goto yy914;
	case 'D':	case 'd':	goto yy918;
	case 'F':	case 'f':	goto yy912;
	case 'J':	case 'j':	goto yy911;
	case 'M':	case 'm':	goto yy913;
	case 'N':	case 'n':	goto yy917;
	case 'O':	case 'o':	goto yy916;
	case 'S':	case 's':	goto yy915;
	default:	goto yy791;
	}
yy790:
	YYDEBUG(790, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
	goto yy791;
yy791:
	YYDEBUG(791, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy790;
	case 'A':	case 'a':	goto yy873;
	case 'D':	case 'd':	goto yy875;
	case 'F':	case 'f':	goto yy871;
	case 'I':	goto yy793;
	case 'J':	case 'j':	goto yy797;
	case 'M':	case 'm':	goto yy872;
	case 'N':	case 'n':	goto yy800;
	case 'O':	case 'o':	goto yy799;
	case 'S':	case 's':	goto yy874;
	case 'V':	goto yy795;
	case 'X':	goto yy796;
	default:	goto yy56;
	}
yy792:
	YYDEBUG(792, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '1'){
		if(yych <= '/')	goto yy791;
		if(yych <= '0')	goto yy867;
		goto yy868;
	} else {
		if(yych <= '5')	goto yy869;
		if(yych <= '9')	goto yy870;
		goto yy791;
	}
yy793:
	YYDEBUG(793, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych <= '.'){
			if(yych >= ' ')	goto yy831;
			goto yy794;
		} else {
			if(yych <= '/')	goto yy794;
			if(yych <= '9')	goto yy833;
			goto yy794;
		}
	} else {
		if(yych <= 'V'){
			if(yych <= 'I')	goto yy866;
			if(yych >= 'V')	goto yy839;
			goto yy794;
		} else {
			if(yych == 'X')	goto yy839;
			goto yy794;
		}
	}
yy794:
	YYDEBUG(794, *YYCURSOR);

{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy795:
	YYDEBUG(795, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= 0x1F)	goto yy794;
		if(yych <= '.')	goto yy831;
		goto yy794;
	} else {
		if(yych <= '9')	goto yy833;
		if(yych == 'I')	goto yy864;
		goto yy794;
	}
yy796:
	YYDEBUG(796, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= 0x1F)	goto yy794;
		if(yych <= '.')	goto yy831;
		goto yy794;
	} else {
		if(yych <= '9')	goto yy833;
		if(yych == 'I')	goto yy863;
		goto yy794;
	}
yy797:
	YYDEBUG(797, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'A')	goto yy856;
		if(yych <= 'T')	goto yy56;
		goto yy855;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy56;
			goto yy856;
		} else {
			if(yych == 'u')	goto yy855;
			goto yy56;
		}
	}
yy798:
	YYDEBUG(798, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'T'){
		if(yych <= 'L'){
			if(yych == '.')	goto yy803;
			goto yy56;
		} else {
			if(yych <= 'M')	goto yy804;
			if(yych == 'P')	goto yy849;
			goto yy56;
		}
	} else {
		if(yych <= 'o'){
			if(yych <= 'U')	goto yy848;
			if(yych == 'm')	goto yy804;
			goto yy56;
		} else {
			if(yych <= 'p')	goto yy849;
			if(yych == 'u')	goto yy848;
			goto yy56;
		}
	}
yy799:
	YYDEBUG(799, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy843;
	if(yych == 'c')	goto yy843;
	goto yy56;
yy800:
	YYDEBUG(800, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy829;
	if(yych == 'o')	goto yy829;
	goto yy56;
yy801:
	YYDEBUG(801, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy807;
	if(yych <= '9')	goto yy809;
	goto yy56;
yy802:
	YYDEBUG(802, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych != '.')	goto yy56;
		goto yy803;
	} else {
		if(yych <= 'M')	goto yy804;
		if(yych == 'm')	goto yy804;
		goto yy56;
	}
yy803:
	YYDEBUG(803, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy804;
	if(yych != 'm')	goto yy56;
	goto yy804;
yy804:
	YYDEBUG(804, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) == '.')	goto yy806;
	goto yy805;
yy805:
	YYDEBUG(805, *YYCURSOR);

{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
yy806:
	YYDEBUG(806, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy805;
yy807:
	YYDEBUG(807, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy810;
		goto yy808;
	} else {
		if(yych <= '9')	goto yy823;
		if(yych <= ':')	goto yy810;
		goto yy808;
	}
yy808:
	YYDEBUG(808, *YYCURSOR);

{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
yy809:
	YYDEBUG(809, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy810;
	if(yych != ':')	goto yy808;
	goto yy810;
yy810:
	YYDEBUG(810, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy811;
	if(yych <= '6')	goto yy812;
	if(yych <= '9')	goto yy813;
	goto yy56;
yy811:
	YYDEBUG(811, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy814;
	if(yych <= '/')	goto yy808;
	if(yych <= '9')	goto yy817;
	goto yy808;
yy812:
	YYDEBUG(812, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy814;
	if(yych == '0')	goto yy817;
	goto yy808;
yy813:
	YYDEBUG(813, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych != '.')	goto yy808;
	goto yy814;
yy814:
	YYDEBUG(814, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= ':')	goto yy56;
	goto yy815;
yy815:
	YYDEBUG(815, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy816;
yy816:
	YYDEBUG(816, *YYCURSOR);
	if(yych <= '/')	goto yy808;
	if(yych <= '9')	goto yy815;
	goto yy808;
yy817:
	YYDEBUG(817, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'A'){
		if(yych <= '-'){
			if(yych != ' ')	goto yy808;
			goto yy818;
		} else {
			if(yych <= '.')	goto yy814;
			if(yych <= '@')	goto yy808;
			goto yy820;
		}
	} else {
		if(yych <= '`'){
			if(yych == 'P')	goto yy820;
			goto yy808;
		} else {
			if(yych <= 'a')	goto yy820;
			if(yych == 'p')	goto yy820;
			goto yy808;
		}
	}
yy818:
	YYDEBUG(818, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	goto yy819;
yy819:
	YYDEBUG(819, *YYCURSOR);
	if(yych <= 'O'){
		if(yych <= ' '){
			if(yych <= 0x1F)	goto yy56;
			goto yy818;
		} else {
			if(yych != 'A')	goto yy56;
			goto yy820;
		}
	} else {
		if(yych <= 'a'){
			if(yych <= 'P')	goto yy820;
			if(yych <= '`')	goto yy56;
			goto yy820;
		} else {
			if(yych != 'p')	goto yy56;
			goto yy820;
		}
	}
yy820:
	YYDEBUG(820, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych != '.')	goto yy56;
		goto yy821;
	} else {
		if(yych <= 'M')	goto yy822;
		if(yych == 'm')	goto yy822;
		goto yy56;
	}
yy821:
	YYDEBUG(821, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy822;
	if(yych != 'm')	goto yy56;
	goto yy822;
yy822:
	YYDEBUG(822, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '.')	goto yy806;
	goto yy805;
yy823:
	YYDEBUG(823, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= '-'){
			if(yych != ' ')	goto yy808;
			goto yy824;
		} else {
			if(yych <= '.')	goto yy810;
			if(yych == ':')	goto yy810;
			goto yy808;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'A')	goto yy826;
			if(yych == 'P')	goto yy826;
			goto yy808;
		} else {
			if(yych <= 'a')	goto yy826;
			if(yych == 'p')	goto yy826;
			goto yy808;
		}
	}
yy824:
	YYDEBUG(824, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	goto yy825;
yy825:
	YYDEBUG(825, *YYCURSOR);
	if(yych <= 'O'){
		if(yych <= ' '){
			if(yych <= 0x1F)	goto yy56;
			goto yy824;
		} else {
			if(yych != 'A')	goto yy56;
			goto yy826;
		}
	} else {
		if(yych <= 'a'){
			if(yych <= 'P')	goto yy826;
			if(yych <= '`')	goto yy56;
			goto yy826;
		} else {
			if(yych != 'p')	goto yy56;
			goto yy826;
		}
	}
yy826:
	YYDEBUG(826, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'L'){
		if(yych != '.')	goto yy56;
		goto yy827;
	} else {
		if(yych <= 'M')	goto yy828;
		if(yych == 'm')	goto yy828;
		goto yy56;
	}
yy827:
	YYDEBUG(827, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy828;
	if(yych != 'm')	goto yy56;
	goto yy828;
yy828:
	YYDEBUG(828, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '.')	goto yy806;
	goto yy805;
yy829:
	YYDEBUG(829, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy830;
	if(yych != 'v')	goto yy56;
	goto yy830;
yy830:
	YYDEBUG(830, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy794;
		if(yych <= '.')	goto yy831;
		if(yych <= '/')	goto yy794;
		goto yy833;
	} else {
		if(yych <= 'E'){
			if(yych <= 'D')	goto yy794;
			goto yy835;
		} else {
			if(yych == 'e')	goto yy835;
			goto yy794;
		}
	}
yy831:
	YYDEBUG(831, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	goto yy832;
yy832:
	YYDEBUG(832, *YYCURSOR);
	if(yych <= 0x1F)	goto yy56;
	if(yych <= '.')	goto yy831;
	if(yych <= '/')	goto yy56;
	if(yych >= ':')	goto yy56;
	goto yy833;
yy833:
	YYDEBUG(833, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '/')	goto yy834;
	if(yych <= '9')	goto yy840;
	goto yy834;
yy834:
	YYDEBUG(834, *YYCURSOR);

{
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
yy835:
	YYDEBUG(835, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy836;
	if(yych != 'm')	goto yy56;
	goto yy836;
yy836:
	YYDEBUG(836, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy837;
	if(yych != 'b')	goto yy56;
	goto yy837;
yy837:
	YYDEBUG(837, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy838;
	if(yych != 'e')	goto yy56;
	goto yy838;
yy838:
	YYDEBUG(838, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy839;
	if(yych != 'r')	goto yy56;
	goto yy839;
yy839:
	YYDEBUG(839, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 0x1F)	goto yy794;
	if(yych <= '.')	goto yy831;
	if(yych <= '/')	goto yy794;
	if(yych <= '9')	goto yy833;
	goto yy794;
yy840:
	YYDEBUG(840, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy834;
	if(yych >= ':')	goto yy834;
	goto yy841;
yy841:
	YYDEBUG(841, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy834;
	if(yych >= ':')	goto yy834;
	goto yy842;
yy842:
	YYDEBUG(842, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy834;
yy843:
	YYDEBUG(843, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy844;
	if(yych != 't')	goto yy56;
	goto yy844;
yy844:
	YYDEBUG(844, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy794;
		if(yych <= '.')	goto yy831;
		if(yych <= '/')	goto yy794;
		goto yy833;
	} else {
		if(yych <= 'O'){
			if(yych <= 'N')	goto yy794;
			goto yy845;
		} else {
			if(yych != 'o')	goto yy794;
			goto yy845;
		}
	}
yy845:
	YYDEBUG(845, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy846;
	if(yych != 'b')	goto yy56;
	goto yy846;
yy846:
	YYDEBUG(846, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy847;
	if(yych != 'e')	goto yy56;
	goto yy847;
yy847:
	YYDEBUG(847, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy839;
	if(yych == 'r')	goto yy839;
	goto yy56;
yy848:
	YYDEBUG(848, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy852;
	if(yych == 'g')	goto yy852;
	goto yy56;
yy849:
	YYDEBUG(849, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy850;
	if(yych != 'r')	goto yy56;
	goto yy850;
yy850:
	YYDEBUG(850, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy794;
		if(yych <= '.')	goto yy831;
		if(yych <= '/')	goto yy794;
		goto yy833;
	} else {
		if(yych <= 'I'){
			if(yych <= 'H')	goto yy794;
			goto yy851;
		} else {
			if(yych != 'i')	goto yy794;
			goto yy851;
		}
	}
yy851:
	YYDEBUG(851, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy839;
	if(yych == 'l')	goto yy839;
	goto yy56;
yy852:
	YYDEBUG(852, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy794;
		if(yych <= '.')	goto yy831;
		if(yych <= '/')	goto yy794;
		goto yy833;
	} else {
		if(yych <= 'U'){
			if(yych <= 'T')	goto yy794;
			goto yy853;
		} else {
			if(yych != 'u')	goto yy794;
			goto yy853;
		}
	}
yy853:
	YYDEBUG(853, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy854;
	if(yych != 's')	goto yy56;
	goto yy854;
yy854:
	YYDEBUG(854, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy839;
	if(yych == 't')	goto yy839;
	goto yy56;
yy855:
	YYDEBUG(855, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'L')	goto yy862;
		if(yych <= 'M')	goto yy56;
		goto yy861;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy56;
			goto yy862;
		} else {
			if(yych == 'n')	goto yy861;
			goto yy56;
		}
	}
yy856:
	YYDEBUG(856, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy857;
	if(yych != 'n')	goto yy56;
	goto yy857;
yy857:
	YYDEBUG(857, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy794;
		if(yych <= '.')	goto yy831;
		if(yych <= '/')	goto yy794;
		goto yy833;
	} else {
		if(yych <= 'U'){
			if(yych <= 'T')	goto yy794;
			goto yy858;
		} else {
			if(yych != 'u')	goto yy794;
			goto yy858;
		}
	}
yy858:
	YYDEBUG(858, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy859;
	if(yych != 'a')	goto yy56;
	goto yy859;
yy859:
	YYDEBUG(859, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy860;
	if(yych != 'r')	goto yy56;
	goto yy860;
yy860:
	YYDEBUG(860, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy839;
	if(yych == 'y')	goto yy839;
	goto yy56;
yy861:
	YYDEBUG(861, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy794;
		if(yych <= '.')	goto yy831;
		if(yych <= '/')	goto yy794;
		goto yy833;
	} else {
		if(yych <= 'E'){
			if(yych <= 'D')	goto yy794;
			goto yy839;
		} else {
			if(yych == 'e')	goto yy839;
			goto yy794;
		}
	}
yy862:
	YYDEBUG(862, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy794;
		if(yych <= '.')	goto yy831;
		if(yych <= '/')	goto yy794;
		goto yy833;
	} else {
		if(yych <= 'Y'){
			if(yych <= 'X')	goto yy794;
			goto yy839;
		} else {
			if(yych == 'y')	goto yy839;
			goto yy794;
		}
	}
yy863:
	YYDEBUG(863, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= 0x1F)	goto yy794;
		if(yych <= '.')	goto yy831;
		goto yy794;
	} else {
		if(yych <= '9')	goto yy833;
		if(yych == 'I')	goto yy839;
		goto yy794;
	}
yy864:
	YYDEBUG(864, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= 0x1F)	goto yy794;
		if(yych <= '.')	goto yy831;
		goto yy794;
	} else {
		if(yych <= '9')	goto yy833;
		if(yych != 'I')	goto yy794;
		goto yy865;
	}
yy865:
	YYDEBUG(865, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= 0x1F)	goto yy794;
		if(yych <= '.')	goto yy831;
		goto yy794;
	} else {
		if(yych <= '9')	goto yy833;
		if(yych == 'I')	goto yy839;
		goto yy794;
	}
yy866:
	YYDEBUG(866, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= 0x1F)	goto yy794;
		if(yych <= '.')	goto yy831;
		goto yy794;
	} else {
		if(yych <= '9')	goto yy833;
		if(yych == 'I')	goto yy839;
		goto yy794;
	}
yy867:
	YYDEBUG(867, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy898;
		goto yy808;
	} else {
		if(yych <= '9')	goto yy907;
		if(yych <= ':')	goto yy810;
		goto yy808;
	}
yy868:
	YYDEBUG(868, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy898;
		goto yy808;
	} else {
		if(yych <= '2')	goto yy907;
		if(yych <= '9')	goto yy823;
		if(yych <= ':')	goto yy810;
		goto yy808;
	}
yy869:
	YYDEBUG(869, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy898;
		goto yy808;
	} else {
		if(yych <= '9')	goto yy823;
		if(yych <= ':')	goto yy810;
		goto yy808;
	}
yy870:
	YYDEBUG(870, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy898;
	if(yych == ':')	goto yy810;
	goto yy808;
yy871:
	YYDEBUG(871, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy892;
	if(yych == 'e')	goto yy892;
	goto yy56;
yy872:
	YYDEBUG(872, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy889;
	if(yych == 'a')	goto yy889;
	goto yy56;
yy873:
	YYDEBUG(873, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'P')	goto yy849;
		if(yych <= 'T')	goto yy56;
		goto yy848;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy56;
			goto yy849;
		} else {
			if(yych == 'u')	goto yy848;
			goto yy56;
		}
	}
yy874:
	YYDEBUG(874, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy882;
	if(yych == 'e')	goto yy882;
	goto yy56;
yy875:
	YYDEBUG(875, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy876;
	if(yych != 'e')	goto yy56;
	goto yy876;
yy876:
	YYDEBUG(876, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy877;
	if(yych != 'c')	goto yy56;
	goto yy877;
yy877:
	YYDEBUG(877, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy794;
		if(yych <= '.')	goto yy831;
		if(yych <= '/')	goto yy794;
		goto yy833;
	} else {
		if(yych <= 'E'){
			if(yych <= 'D')	goto yy794;
			goto yy878;
		} else {
			if(yych != 'e')	goto yy794;
			goto yy878;
		}
	}
yy878:
	YYDEBUG(878, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy879;
	if(yych != 'm')	goto yy56;
	goto yy879;
yy879:
	YYDEBUG(879, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy880;
	if(yych != 'b')	goto yy56;
	goto yy880;
yy880:
	YYDEBUG(880, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy881;
	if(yych != 'e')	goto yy56;
	goto yy881;
yy881:
	YYDEBUG(881, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy839;
	if(yych == 'r')	goto yy839;
	goto yy56;
yy882:
	YYDEBUG(882, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy883;
	if(yych != 'p')	goto yy56;
	goto yy883;
yy883:
	YYDEBUG(883, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy794;
		if(yych <= '.')	goto yy831;
		if(yych <= '/')	goto yy794;
		goto yy833;
	} else {
		if(yych <= 'T'){
			if(yych <= 'S')	goto yy794;
			goto yy884;
		} else {
			if(yych != 't')	goto yy794;
			goto yy884;
		}
	}
yy884:
	YYDEBUG(884, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy794;
		if(yych <= '.')	goto yy831;
		if(yych <= '/')	goto yy794;
		goto yy833;
	} else {
		if(yych <= 'E'){
			if(yych <= 'D')	goto yy794;
			goto yy885;
		} else {
			if(yych != 'e')	goto yy794;
			goto yy885;
		}
	}
yy885:
	YYDEBUG(885, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy886;
	if(yych != 'm')	goto yy56;
	goto yy886;
yy886:
	YYDEBUG(886, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy887;
	if(yych != 'b')	goto yy56;
	goto yy887;
yy887:
	YYDEBUG(887, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy888;
	if(yych != 'e')	goto yy56;
	goto yy888;
yy888:
	YYDEBUG(888, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy839;
	if(yych == 'r')	goto yy839;
	goto yy56;
yy889:
	YYDEBUG(889, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych == 'R')	goto yy890;
		if(yych <= 'X')	goto yy56;
		goto yy839;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy56;
			goto yy890;
		} else {
			if(yych == 'y')	goto yy839;
			goto yy56;
		}
	}
yy890:
	YYDEBUG(890, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy794;
		if(yych <= '.')	goto yy831;
		if(yych <= '/')	goto yy794;
		goto yy833;
	} else {
		if(yych <= 'C'){
			if(yych <= 'B')	goto yy794;
			goto yy891;
		} else {
			if(yych != 'c')	goto yy794;
			goto yy891;
		}
	}
yy891:
	YYDEBUG(891, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy839;
	if(yych == 'h')	goto yy839;
	goto yy56;
yy892:
	YYDEBUG(892, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy893;
	if(yych != 'b')	goto yy56;
	goto yy893;
yy893:
	YYDEBUG(893, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '9'){
		if(yych <= 0x1F)	goto yy794;
		if(yych <= '.')	goto yy831;
		if(yych <= '/')	goto yy794;
		goto yy833;
	} else {
		if(yych <= 'R'){
			if(yych <= 'Q')	goto yy794;
			goto yy894;
		} else {
			if(yych != 'r')	goto yy794;
			goto yy894;
		}
	}
yy894:
	YYDEBUG(894, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy895;
	if(yych != 'u')	goto yy56;
	goto yy895;
yy895:
	YYDEBUG(895, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy896;
	if(yych != 'a')	goto yy56;
	goto yy896;
yy896:
	YYDEBUG(896, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy897;
	if(yych != 'r')	goto yy56;
	goto yy897;
yy897:
	YYDEBUG(897, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy839;
	if(yych == 'y')	goto yy839;
	goto yy56;
yy898:
	YYDEBUG(898, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy899;
	if(yych <= '6')	goto yy900;
	if(yych <= '9')	goto yy901;
	goto yy56;
yy899:
	YYDEBUG(899, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy814;
	if(yych <= '/')	goto yy808;
	if(yych <= '9')	goto yy906;
	goto yy808;
yy900:
	YYDEBUG(900, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy814;
		goto yy808;
	} else {
		if(yych <= '0')	goto yy906;
		if(yych <= '9')	goto yy902;
		goto yy808;
	}
yy901:
	YYDEBUG(901, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy814;
	if(yych <= '/')	goto yy808;
	if(yych >= ':')	goto yy808;
	goto yy902;
yy902:
	YYDEBUG(902, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '/')	goto yy903;
	if(yych <= '9')	goto yy904;
	goto yy903;
yy903:
	YYDEBUG(903, *YYCURSOR);

{
		DEBUG_OUTPUT("pointed date");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy904:
	YYDEBUG(904, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy903;
	if(yych >= ':')	goto yy903;
	goto yy905;
yy905:
	YYDEBUG(905, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy903;
yy906:
	YYDEBUG(906, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= '-'){
			if(yych == ' ')	goto yy818;
			goto yy808;
		} else {
			if(yych <= '.')	goto yy814;
			if(yych <= '/')	goto yy808;
			if(yych <= '9')	goto yy904;
			goto yy808;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'A')	goto yy820;
			if(yych == 'P')	goto yy820;
			goto yy808;
		} else {
			if(yych <= 'a')	goto yy820;
			if(yych == 'p')	goto yy820;
			goto yy808;
		}
	}
yy907:
	YYDEBUG(907, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '@'){
		if(yych <= '-'){
			if(yych == ' ')	goto yy824;
			goto yy808;
		} else {
			if(yych <= '.')	goto yy898;
			if(yych == ':')	goto yy810;
			goto yy808;
		}
	} else {
		if(yych <= '`'){
			if(yych <= 'A')	goto yy826;
			if(yych == 'P')	goto yy826;
			goto yy808;
		} else {
			if(yych <= 'a')	goto yy826;
			if(yych == 'p')	goto yy826;
			goto yy808;
		}
	}
yy908:
	YYDEBUG(908, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '-')	goto yy947;
	if(yych <= '/')	goto yy56;
	if(yych <= '9')	goto yy910;
	goto yy56;
yy909:
	YYDEBUG(909, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '-')	goto yy947;
	if(yych <= '/')	goto yy56;
	if(yych >= '3')	goto yy56;
	goto yy910;
yy910:
	YYDEBUG(910, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '-')	goto yy947;
	goto yy56;
yy911:
	YYDEBUG(911, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'A')	goto yy943;
		if(yych <= 'T')	goto yy56;
		goto yy942;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy56;
			goto yy943;
		} else {
			if(yych == 'u')	goto yy942;
			goto yy56;
		}
	}
yy912:
	YYDEBUG(912, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy940;
	if(yych == 'e')	goto yy940;
	goto yy56;
yy913:
	YYDEBUG(913, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy937;
	if(yych == 'a')	goto yy937;
	goto yy56;
yy914:
	YYDEBUG(914, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'P')	goto yy934;
		if(yych <= 'T')	goto yy56;
		goto yy933;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy56;
			goto yy934;
		} else {
			if(yych == 'u')	goto yy933;
			goto yy56;
		}
	}
yy915:
	YYDEBUG(915, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy930;
	if(yych == 'e')	goto yy930;
	goto yy56;
yy916:
	YYDEBUG(916, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy928;
	if(yych == 'c')	goto yy928;
	goto yy56;
yy917:
	YYDEBUG(917, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy926;
	if(yych == 'o')	goto yy926;
	goto yy56;
yy918:
	YYDEBUG(918, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy919;
	if(yych != 'e')	goto yy56;
	goto yy919;
yy919:
	YYDEBUG(919, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy920;
	if(yych != 'c')	goto yy56;
	goto yy920;
yy920:
	YYDEBUG(920, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy794;
			goto yy831;
		} else {
			if(yych <= '-')	goto yy921;
			if(yych <= '.')	goto yy831;
			goto yy794;
		}
	} else {
		if(yych <= 'E'){
			if(yych <= '9')	goto yy833;
			if(yych <= 'D')	goto yy794;
			goto yy878;
		} else {
			if(yych == 'e')	goto yy878;
			goto yy794;
		}
	}
yy921:
	YYDEBUG(921, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy832;
	if(yych <= '0')	goto yy922;
	if(yych <= '2')	goto yy923;
	if(yych <= '3')	goto yy924;
	goto yy832;
yy922:
	YYDEBUG(922, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy834;
	if(yych <= '0')	goto yy840;
	if(yych <= '9')	goto yy925;
	goto yy834;
yy923:
	YYDEBUG(923, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy834;
	if(yych <= '9')	goto yy925;
	goto yy834;
yy924:
	YYDEBUG(924, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy834;
	if(yych <= '1')	goto yy925;
	if(yych <= '9')	goto yy840;
	goto yy834;
yy925:
	YYDEBUG(925, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy834;
	if(yych <= '9')	goto yy841;
	goto yy834;
yy926:
	YYDEBUG(926, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy927;
	if(yych != 'v')	goto yy56;
	goto yy927;
yy927:
	YYDEBUG(927, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy794;
			goto yy831;
		} else {
			if(yych <= '-')	goto yy921;
			if(yych <= '.')	goto yy831;
			goto yy794;
		}
	} else {
		if(yych <= 'E'){
			if(yych <= '9')	goto yy833;
			if(yych <= 'D')	goto yy794;
			goto yy835;
		} else {
			if(yych == 'e')	goto yy835;
			goto yy794;
		}
	}
yy928:
	YYDEBUG(928, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy929;
	if(yych != 't')	goto yy56;
	goto yy929;
yy929:
	YYDEBUG(929, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy794;
			goto yy831;
		} else {
			if(yych <= '-')	goto yy921;
			if(yych <= '.')	goto yy831;
			goto yy794;
		}
	} else {
		if(yych <= 'O'){
			if(yych <= '9')	goto yy833;
			if(yych <= 'N')	goto yy794;
			goto yy845;
		} else {
			if(yych == 'o')	goto yy845;
			goto yy794;
		}
	}
yy930:
	YYDEBUG(930, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy931;
	if(yych != 'p')	goto yy56;
	goto yy931;
yy931:
	YYDEBUG(931, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy794;
			goto yy831;
		} else {
			if(yych <= '-')	goto yy921;
			if(yych <= '.')	goto yy831;
			goto yy794;
		}
	} else {
		if(yych <= 'T'){
			if(yych <= '9')	goto yy833;
			if(yych <= 'S')	goto yy794;
			goto yy932;
		} else {
			if(yych != 't')	goto yy794;
			goto yy932;
		}
	}
yy932:
	YYDEBUG(932, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy794;
			goto yy831;
		} else {
			if(yych <= '-')	goto yy921;
			if(yych <= '.')	goto yy831;
			goto yy794;
		}
	} else {
		if(yych <= 'E'){
			if(yych <= '9')	goto yy833;
			if(yych <= 'D')	goto yy794;
			goto yy885;
		} else {
			if(yych == 'e')	goto yy885;
			goto yy794;
		}
	}
yy933:
	YYDEBUG(933, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy936;
	if(yych == 'g')	goto yy936;
	goto yy56;
yy934:
	YYDEBUG(934, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy935;
	if(yych != 'r')	goto yy56;
	goto yy935;
yy935:
	YYDEBUG(935, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy794;
			goto yy831;
		} else {
			if(yych <= '-')	goto yy921;
			if(yych <= '.')	goto yy831;
			goto yy794;
		}
	} else {
		if(yych <= 'I'){
			if(yych <= '9')	goto yy833;
			if(yych <= 'H')	goto yy794;
			goto yy851;
		} else {
			if(yych == 'i')	goto yy851;
			goto yy794;
		}
	}
yy936:
	YYDEBUG(936, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy794;
			goto yy831;
		} else {
			if(yych <= '-')	goto yy921;
			if(yych <= '.')	goto yy831;
			goto yy794;
		}
	} else {
		if(yych <= 'U'){
			if(yych <= '9')	goto yy833;
			if(yych <= 'T')	goto yy794;
			goto yy853;
		} else {
			if(yych == 'u')	goto yy853;
			goto yy794;
		}
	}
yy937:
	YYDEBUG(937, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych == 'R')	goto yy938;
		if(yych <= 'X')	goto yy56;
		goto yy939;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy56;
			goto yy938;
		} else {
			if(yych == 'y')	goto yy939;
			goto yy56;
		}
	}
yy938:
	YYDEBUG(938, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy794;
			goto yy831;
		} else {
			if(yych <= '-')	goto yy921;
			if(yych <= '.')	goto yy831;
			goto yy794;
		}
	} else {
		if(yych <= 'C'){
			if(yych <= '9')	goto yy833;
			if(yych <= 'B')	goto yy794;
			goto yy891;
		} else {
			if(yych == 'c')	goto yy891;
			goto yy794;
		}
	}
yy939:
	YYDEBUG(939, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '-'){
		if(yych <= 0x1F)	goto yy794;
		if(yych <= ',')	goto yy831;
		goto yy921;
	} else {
		if(yych <= '.')	goto yy831;
		if(yych <= '/')	goto yy794;
		if(yych <= '9')	goto yy833;
		goto yy794;
	}
yy940:
	YYDEBUG(940, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy941;
	if(yych != 'b')	goto yy56;
	goto yy941;
yy941:
	YYDEBUG(941, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy794;
			goto yy831;
		} else {
			if(yych <= '-')	goto yy921;
			if(yych <= '.')	goto yy831;
			goto yy794;
		}
	} else {
		if(yych <= 'R'){
			if(yych <= '9')	goto yy833;
			if(yych <= 'Q')	goto yy794;
			goto yy894;
		} else {
			if(yych == 'r')	goto yy894;
			goto yy794;
		}
	}
yy942:
	YYDEBUG(942, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'L')	goto yy946;
		if(yych <= 'M')	goto yy56;
		goto yy945;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy56;
			goto yy946;
		} else {
			if(yych == 'n')	goto yy945;
			goto yy56;
		}
	}
yy943:
	YYDEBUG(943, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy944;
	if(yych != 'n')	goto yy56;
	goto yy944;
yy944:
	YYDEBUG(944, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy794;
			goto yy831;
		} else {
			if(yych <= '-')	goto yy921;
			if(yych <= '.')	goto yy831;
			goto yy794;
		}
	} else {
		if(yych <= 'U'){
			if(yych <= '9')	goto yy833;
			if(yych <= 'T')	goto yy794;
			goto yy858;
		} else {
			if(yych == 'u')	goto yy858;
			goto yy794;
		}
	}
yy945:
	YYDEBUG(945, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy794;
			goto yy831;
		} else {
			if(yych <= '-')	goto yy921;
			if(yych <= '.')	goto yy831;
			goto yy794;
		}
	} else {
		if(yych <= 'E'){
			if(yych <= '9')	goto yy833;
			if(yych <= 'D')	goto yy794;
			goto yy839;
		} else {
			if(yych == 'e')	goto yy839;
			goto yy794;
		}
	}
yy946:
	YYDEBUG(946, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych <= ','){
			if(yych <= 0x1F)	goto yy794;
			goto yy831;
		} else {
			if(yych <= '-')	goto yy921;
			if(yych <= '.')	goto yy831;
			goto yy794;
		}
	} else {
		if(yych <= 'Y'){
			if(yych <= '9')	goto yy833;
			if(yych <= 'X')	goto yy794;
			goto yy839;
		} else {
			if(yych == 'y')	goto yy839;
			goto yy794;
		}
	}
yy947:
	YYDEBUG(947, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '2')	goto yy948;
	if(yych <= '3')	goto yy950;
	if(yych <= '9')	goto yy951;
	goto yy56;
yy948:
	YYDEBUG(948, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '/')	goto yy949;
	if(yych <= '9')	goto yy951;
	goto yy949;
yy949:
	YYDEBUG(949, *YYCURSOR);

{
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy950:
	YYDEBUG(950, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy949;
	if(yych >= '2')	goto yy949;
	goto yy951;
yy951:
	YYDEBUG(951, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy949;
yy952:
	YYDEBUG(952, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.')	goto yy953;
	if(yych <= '/')	goto yy1004;
	if(yych <= '9')	goto yy955;
	goto yy953;
yy953:
	YYDEBUG(953, *YYCURSOR);

{
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr((char **) &ptr, 4);
			TIMELIB_PROCESS_YEAR(s->time->y);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
yy954:
	YYDEBUG(954, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '.')	goto yy953;
	if(yych <= '/')	goto yy1004;
	if(yych >= '2')	goto yy953;
	goto yy955;
yy955:
	YYDEBUG(955, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '/')	goto yy1004;
	goto yy953;
yy956:
	YYDEBUG(956, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'A')	goto yy1003;
		if(yych <= 'T')	goto yy56;
		goto yy1002;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy56;
			goto yy1003;
		} else {
			if(yych == 'u')	goto yy1002;
			goto yy56;
		}
	}
yy957:
	YYDEBUG(957, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1001;
	if(yych == 'e')	goto yy1001;
	goto yy56;
yy958:
	YYDEBUG(958, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1000;
	if(yych == 'a')	goto yy1000;
	goto yy56;
yy959:
	YYDEBUG(959, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'P')	goto yy999;
		if(yych <= 'T')	goto yy56;
		goto yy998;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy56;
			goto yy999;
		} else {
			if(yych == 'u')	goto yy998;
			goto yy56;
		}
	}
yy960:
	YYDEBUG(960, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy996;
	if(yych == 'e')	goto yy996;
	goto yy56;
yy961:
	YYDEBUG(961, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy995;
	if(yych == 'c')	goto yy995;
	goto yy56;
yy962:
	YYDEBUG(962, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy994;
	if(yych == 'o')	goto yy994;
	goto yy56;
yy963:
	YYDEBUG(963, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy964;
	if(yych != 'e')	goto yy56;
	goto yy964;
yy964:
	YYDEBUG(964, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy965;
	if(yych != 'c')	goto yy56;
	goto yy965;
yy965:
	YYDEBUG(965, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '/')	goto yy56;
	goto yy966;
yy966:
	YYDEBUG(966, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= ':')	goto yy56;
	goto yy967;
yy967:
	YYDEBUG(967, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= ':')	goto yy56;
	goto yy968;
yy968:
	YYDEBUG(968, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= ':')	goto yy56;
	goto yy969;
yy969:
	YYDEBUG(969, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= ':')	goto yy56;
	goto yy970;
yy970:
	YYDEBUG(970, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy56;
	goto yy971;
yy971:
	YYDEBUG(971, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '1')	goto yy972;
	if(yych <= '2')	goto yy973;
	goto yy56;
yy972:
	YYDEBUG(972, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '9')	goto yy974;
	goto yy56;
yy973:
	YYDEBUG(973, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= '4')	goto yy56;
	goto yy974;
yy974:
	YYDEBUG(974, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy56;
	goto yy975;
yy975:
	YYDEBUG(975, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= '6')	goto yy56;
	goto yy976;
yy976:
	YYDEBUG(976, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= ':')	goto yy56;
	goto yy977;
yy977:
	YYDEBUG(977, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy56;
	goto yy978;
yy978:
	YYDEBUG(978, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy979;
	if(yych <= '6')	goto yy980;
	goto yy56;
yy979:
	YYDEBUG(979, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '9')	goto yy981;
	goto yy56;
yy980:
	YYDEBUG(980, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '0')	goto yy56;
	goto yy981;
yy981:
	YYDEBUG(981, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ' ')	goto yy56;
	goto yy982;
yy982:
	YYDEBUG(982, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	goto yy983;
yy983:
	YYDEBUG(983, *YYCURSOR);
	if(yych <= '*'){
		if(yych == ' ')	goto yy982;
		goto yy56;
	} else {
		if(yych == ',')	goto yy56;
		if(yych >= '.')	goto yy56;
		goto yy984;
	}
yy984:
	YYDEBUG(984, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '1')	goto yy985;
	if(yych <= '2')	goto yy987;
	if(yych <= '9')	goto yy988;
	goto yy56;
yy985:
	YYDEBUG(985, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '/')	goto yy986;
	if(yych <= '5')	goto yy992;
	if(yych <= '9')	goto yy988;
	if(yych <= ':')	goto yy989;
	goto yy986;
yy986:
	YYDEBUG(986, *YYCURSOR);

{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		s->errors += tz_not_found;
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy987:
	YYDEBUG(987, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '5'){
		if(yych <= '/')	goto yy986;
		if(yych <= '3')	goto yy992;
		goto yy990;
	} else {
		if(yych == ':')	goto yy989;
		goto yy986;
	}
yy988:
	YYDEBUG(988, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/')	goto yy986;
	if(yych <= '5')	goto yy990;
	if(yych != ':')	goto yy986;
	goto yy989;
yy989:
	YYDEBUG(989, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/')	goto yy986;
	if(yych >= '6')	goto yy986;
	goto yy990;
yy990:
	YYDEBUG(990, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= ':')	goto yy56;
	goto yy991;
yy991:
	YYDEBUG(991, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy986;
yy992:
	YYDEBUG(992, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy986;
	if(yych <= '5')	goto yy993;
	if(yych <= '9')	goto yy991;
	if(yych <= ':')	goto yy989;
	goto yy986;
yy993:
	YYDEBUG(993, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy986;
	if(yych <= '9')	goto yy991;
	goto yy986;
yy994:
	YYDEBUG(994, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy965;
	if(yych == 'v')	goto yy965;
	goto yy56;
yy995:
	YYDEBUG(995, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy965;
	if(yych == 't')	goto yy965;
	goto yy56;
yy996:
	YYDEBUG(996, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy997;
	if(yych != 'p')	goto yy56;
	goto yy997;
yy997:
	YYDEBUG(997, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == '/')	goto yy966;
		goto yy56;
	} else {
		if(yych <= 'T')	goto yy965;
		if(yych == 't')	goto yy965;
		goto yy56;
	}
yy998:
	YYDEBUG(998, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy965;
	if(yych == 'g')	goto yy965;
	goto yy56;
yy999:
	YYDEBUG(999, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy965;
	if(yych == 'r')	goto yy965;
	goto yy56;
yy1000:
	YYDEBUG(1000, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych == 'R')	goto yy965;
		if(yych <= 'X')	goto yy56;
		goto yy965;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy56;
			goto yy965;
		} else {
			if(yych == 'y')	goto yy965;
			goto yy56;
		}
	}
yy1001:
	YYDEBUG(1001, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy965;
	if(yych == 'b')	goto yy965;
	goto yy56;
yy1002:
	YYDEBUG(1002, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'L')	goto yy965;
		if(yych <= 'M')	goto yy56;
		goto yy965;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy56;
			goto yy965;
		} else {
			if(yych == 'n')	goto yy965;
			goto yy56;
		}
	}
yy1003:
	YYDEBUG(1003, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy965;
	if(yych == 'n')	goto yy965;
	goto yy56;
yy1004:
	YYDEBUG(1004, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= ':')	goto yy56;
	goto yy1005;
yy1005:
	YYDEBUG(1005, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy953;
	if(yych >= ':')	goto yy953;
	goto yy1006;
yy1006:
	YYDEBUG(1006, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy953;
	if(yych >= ':')	goto yy953;
	goto yy1007;
yy1007:
	YYDEBUG(1007, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy953;
	if(yych >= ':')	goto yy953;
	goto yy1008;
yy1008:
	YYDEBUG(1008, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy953;
yy1009:
	YYDEBUG(1009, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '-')	goto yy1010;
	if(yych <= '/')	goto yy70;
	if(yych <= '9')	goto yy1037;
	goto yy70;
yy1010:
	YYDEBUG(1010, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case '0':	goto yy908;
	case '1':	goto yy909;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy910;
	case 'A':	case 'a':	goto yy1014;
	case 'D':	case 'd':	goto yy1018;
	case 'F':	case 'f':	goto yy1012;
	case 'J':	case 'j':	goto yy1011;
	case 'M':	case 'm':	goto yy1013;
	case 'N':	case 'n':	goto yy1017;
	case 'O':	case 'o':	goto yy1016;
	case 'S':	case 's':	goto yy1015;
	default:	goto yy56;
	}
yy1011:
	YYDEBUG(1011, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'A')	goto yy1036;
		if(yych <= 'T')	goto yy56;
		goto yy1035;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy56;
			goto yy1036;
		} else {
			if(yych == 'u')	goto yy1035;
			goto yy56;
		}
	}
yy1012:
	YYDEBUG(1012, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1034;
	if(yych == 'e')	goto yy1034;
	goto yy56;
yy1013:
	YYDEBUG(1013, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1033;
	if(yych == 'a')	goto yy1033;
	goto yy56;
yy1014:
	YYDEBUG(1014, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'P')	goto yy1032;
		if(yych <= 'T')	goto yy56;
		goto yy1031;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy56;
			goto yy1032;
		} else {
			if(yych == 'u')	goto yy1031;
			goto yy56;
		}
	}
yy1015:
	YYDEBUG(1015, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1029;
	if(yych == 'e')	goto yy1029;
	goto yy56;
yy1016:
	YYDEBUG(1016, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1028;
	if(yych == 'c')	goto yy1028;
	goto yy56;
yy1017:
	YYDEBUG(1017, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy1027;
	if(yych == 'o')	goto yy1027;
	goto yy56;
yy1018:
	YYDEBUG(1018, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1019;
	if(yych != 'e')	goto yy56;
	goto yy1019;
yy1019:
	YYDEBUG(1019, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1020;
	if(yych != 'c')	goto yy56;
	goto yy1020;
yy1020:
	YYDEBUG(1020, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '-')	goto yy56;
	goto yy1021;
yy1021:
	YYDEBUG(1021, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '0')	goto yy1022;
	if(yych <= '2')	goto yy1023;
	if(yych <= '3')	goto yy1024;
	goto yy56;
yy1022:
	YYDEBUG(1022, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '0')	goto yy56;
	if(yych <= '9')	goto yy1025;
	goto yy56;
yy1023:
	YYDEBUG(1023, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '9')	goto yy1025;
	goto yy56;
yy1024:
	YYDEBUG(1024, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= '2')	goto yy56;
	goto yy1025;
yy1025:
	YYDEBUG(1025, *YYCURSOR);
	++YYCURSOR;
	goto yy1026;
yy1026:
	YYDEBUG(1026, *YYCURSOR);

{
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy1027:
	YYDEBUG(1027, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy1020;
	if(yych == 'v')	goto yy1020;
	goto yy56;
yy1028:
	YYDEBUG(1028, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1020;
	if(yych == 't')	goto yy1020;
	goto yy56;
yy1029:
	YYDEBUG(1029, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy1030;
	if(yych != 'p')	goto yy56;
	goto yy1030;
yy1030:
	YYDEBUG(1030, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'S'){
		if(yych == '-')	goto yy1021;
		goto yy56;
	} else {
		if(yych <= 'T')	goto yy1020;
		if(yych == 't')	goto yy1020;
		goto yy56;
	}
yy1031:
	YYDEBUG(1031, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy1020;
	if(yych == 'g')	goto yy1020;
	goto yy56;
yy1032:
	YYDEBUG(1032, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1020;
	if(yych == 'r')	goto yy1020;
	goto yy56;
yy1033:
	YYDEBUG(1033, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych == 'R')	goto yy1020;
		if(yych <= 'X')	goto yy56;
		goto yy1020;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy56;
			goto yy1020;
		} else {
			if(yych == 'y')	goto yy1020;
			goto yy56;
		}
	}
yy1034:
	YYDEBUG(1034, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy1020;
	if(yych == 'b')	goto yy1020;
	goto yy56;
yy1035:
	YYDEBUG(1035, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'L')	goto yy1020;
		if(yych <= 'M')	goto yy56;
		goto yy1020;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy56;
			goto yy1020;
		} else {
			if(yych == 'n')	goto yy1020;
			goto yy56;
		}
	}
yy1036:
	YYDEBUG(1036, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy1020;
	if(yych == 'n')	goto yy1020;
	goto yy56;
yy1037:
	YYDEBUG(1037, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':	case 'A':	case 'D':	case 'F':	case 'H':
	case 'I':
	case 'J':	case 'M':
	case 'N':
	case 'O':	case 'S':
	case 'T':	case 'V':	case 'X':
	case 'Y':	case 'a':	case 'd':	case 'f':	case 'h':	case 'j':	case 'm':
	case 'n':
	case 'o':	case 's':
	case 't':	case 'w':	case 'y':	goto yy1042;
	case '-':	goto yy1039;
	case '.':	goto yy1045;
	case '/':	goto yy1040;
	case '0':	goto yy1058;
	case '1':	goto yy1059;
	case '2':	goto yy1060;
	case '3':	goto yy1061;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy79;
	case 'W':	goto yy1062;
	default:	goto yy1038;
	}
yy1038:
	YYDEBUG(1038, *YYCURSOR);

{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy1039:
	YYDEBUG(1039, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case '0':	goto yy1199;
	case '1':	goto yy1200;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy910;
	case 'A':	case 'a':	goto yy1194;
	case 'D':	case 'd':	goto yy1198;
	case 'F':	case 'f':	goto yy1192;
	case 'J':	case 'j':	goto yy1191;
	case 'M':	case 'm':	goto yy1193;
	case 'N':	case 'n':	goto yy1197;
	case 'O':	case 'o':	goto yy1196;
	case 'S':	case 's':	goto yy1195;
	default:	goto yy1044;
	}
yy1040:
	YYDEBUG(1040, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '0')	goto yy1177;
	if(yych <= '1')	goto yy1178;
	if(yych <= '9')	goto yy1179;
	goto yy56;
yy1041:
	YYDEBUG(1041, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	goto yy1042;
yy1042:
	YYDEBUG(1042, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	goto yy1041;
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy1043;
	case 'A':	case 'a':	goto yy1053;
	case 'D':	case 'd':	goto yy1057;
	case 'F':	case 'f':	goto yy1051;
	case 'H':	case 'h':	goto yy73;
	case 'I':	goto yy1046;
	case 'J':	case 'j':	goto yy1050;
	case 'M':	case 'm':	goto yy1052;
	case 'N':	case 'n':	goto yy1056;
	case 'O':	case 'o':	goto yy1055;
	case 'S':	case 's':	goto yy1054;
	case 'T':	case 't':	goto yy78;
	case 'V':	goto yy1048;
	case 'W':	case 'w':	goto yy75;
	case 'X':	goto yy1049;
	case 'Y':	case 'y':	goto yy77;
	default:	goto yy56;
	}
yy1043:
	YYDEBUG(1043, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	goto yy1044;
yy1044:
	YYDEBUG(1044, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy1043;
	case 'A':	case 'a':	goto yy1053;
	case 'D':	case 'd':	goto yy1169;
	case 'F':	case 'f':	goto yy1166;
	case 'I':	goto yy1046;
	case 'J':	case 'j':	goto yy1050;
	case 'M':	case 'm':	goto yy1167;
	case 'N':	case 'n':	goto yy1056;
	case 'O':	case 'o':	goto yy1055;
	case 'S':	case 's':	goto yy1168;
	case 'V':	goto yy1048;
	case 'X':	goto yy1049;
	default:	goto yy56;
	}
yy1045:
	YYDEBUG(1045, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy1044;
	if(yych <= '0')	goto yy1163;
	if(yych <= '2')	goto yy1164;
	if(yych <= '3')	goto yy1165;
	goto yy1044;
yy1046:
	YYDEBUG(1046, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= 'U'){
		if(yych == 'I')	goto yy1162;
		goto yy1047;
	} else {
		if(yych == 'W')	goto yy1047;
		if(yych <= 'X')	goto yy1116;
		goto yy1047;
	}
yy1047:
	YYDEBUG(1047, *YYCURSOR);

{
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy1048:
	YYDEBUG(1048, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1160;
	goto yy1047;
yy1049:
	YYDEBUG(1049, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1159;
	goto yy1047;
yy1050:
	YYDEBUG(1050, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'A')	goto yy1152;
		if(yych <= 'T')	goto yy56;
		goto yy1151;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy56;
			goto yy1152;
		} else {
			if(yych == 'u')	goto yy1151;
			goto yy56;
		}
	}
yy1051:
	YYDEBUG(1051, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'R'){
		if(yych <= 'N'){
			if(yych == 'E')	goto yy1145;
			goto yy56;
		} else {
			if(yych <= 'O')	goto yy99;
			if(yych <= 'Q')	goto yy56;
			goto yy98;
		}
	} else {
		if(yych <= 'n'){
			if(yych == 'e')	goto yy1145;
			goto yy56;
		} else {
			if(yych <= 'o')	goto yy99;
			if(yych == 'r')	goto yy98;
			goto yy56;
		}
	}
yy1052:
	YYDEBUG(1052, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'O'){
		if(yych <= 'H'){
			if(yych == 'A')	goto yy1142;
			goto yy56;
		} else {
			if(yych <= 'I')	goto yy126;
			if(yych <= 'N')	goto yy56;
			goto yy125;
		}
	} else {
		if(yych <= 'h'){
			if(yych == 'a')	goto yy1142;
			goto yy56;
		} else {
			if(yych <= 'i')	goto yy126;
			if(yych == 'o')	goto yy125;
			goto yy56;
		}
	}
yy1053:
	YYDEBUG(1053, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'P')	goto yy1136;
		if(yych <= 'T')	goto yy56;
		goto yy1135;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy56;
			goto yy1136;
		} else {
			if(yych == 'u')	goto yy1135;
			goto yy56;
		}
	}
yy1054:
	YYDEBUG(1054, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych <= 'D'){
			if(yych == 'A')	goto yy134;
			goto yy56;
		} else {
			if(yych <= 'E')	goto yy1128;
			if(yych <= 'T')	goto yy56;
			goto yy135;
		}
	} else {
		if(yych <= 'd'){
			if(yych == 'a')	goto yy134;
			goto yy56;
		} else {
			if(yych <= 'e')	goto yy1128;
			if(yych == 'u')	goto yy135;
			goto yy56;
		}
	}
yy1055:
	YYDEBUG(1055, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1123;
	if(yych == 'c')	goto yy1123;
	goto yy56;
yy1056:
	YYDEBUG(1056, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy1117;
	if(yych == 'o')	goto yy1117;
	goto yy56;
yy1057:
	YYDEBUG(1057, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'E'){
		if(yych == 'A')	goto yy122;
		if(yych <= 'D')	goto yy56;
		goto yy1110;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy56;
			goto yy122;
		} else {
			if(yych == 'e')	goto yy1110;
			goto yy56;
		}
	}
yy1058:
	YYDEBUG(1058, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy70;
	if(yych <= '0')	goto yy1108;
	if(yych <= '9')	goto yy1109;
	goto yy70;
yy1059:
	YYDEBUG(1059, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy70;
	if(yych <= '2')	goto yy1075;
	if(yych <= '9')	goto yy1074;
	goto yy70;
yy1060:
	YYDEBUG(1060, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy70;
	if(yych <= '9')	goto yy1074;
	goto yy70;
yy1061:
	YYDEBUG(1061, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy70;
	if(yych <= '5')	goto yy1070;
	if(yych <= '6')	goto yy1071;
	if(yych <= '9')	goto yy79;
	goto yy70;
yy1062:
	YYDEBUG(1062, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '5'){
		if(yych <= '/')	goto yy56;
		if(yych <= '0')	goto yy1063;
		if(yych <= '4')	goto yy1064;
		goto yy1065;
	} else {
		if(yych <= 'E'){
			if(yych <= 'D')	goto yy56;
			goto yy114;
		} else {
			if(yych == 'e')	goto yy114;
			goto yy56;
		}
	}
yy1063:
	YYDEBUG(1063, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '0')	goto yy56;
	if(yych <= '9')	goto yy1066;
	goto yy56;
yy1064:
	YYDEBUG(1064, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '9')	goto yy1066;
	goto yy56;
yy1065:
	YYDEBUG(1065, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= '4')	goto yy56;
	goto yy1066;
yy1066:
	YYDEBUG(1066, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '/')	goto yy1067;
	if(yych <= '7')	goto yy1068;
	goto yy1067;
yy1067:
	YYDEBUG(1067, *YYCURSOR);

{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy1068:
	YYDEBUG(1068, *YYCURSOR);
	++YYCURSOR;
	goto yy1069;
yy1069:
	YYDEBUG(1069, *YYCURSOR);

{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy1070:
	YYDEBUG(1070, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy70;
	if(yych <= '9')	goto yy1072;
	goto yy70;
yy1071:
	YYDEBUG(1071, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy70;
	if(yych <= '6')	goto yy1072;
	if(yych <= '9')	goto yy79;
	goto yy70;
yy1072:
	YYDEBUG(1072, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 32) {
		goto yy79;
	}
	if(yych <= 'X'){
		if(yych <= 'G'){
			if(yych <= 'C'){
				if(yych == ' ')	goto yy70;
				goto yy1073;
			} else {
				if(yych == 'E')	goto yy1073;
				if(yych <= 'F')	goto yy70;
				goto yy1073;
			}
		} else {
			if(yych <= 'R'){
				if(yych <= 'H')	goto yy70;
				if(yych == 'M')	goto yy70;
				goto yy1073;
			} else {
				if(yych <= 'T')	goto yy70;
				if(yych == 'W')	goto yy70;
				goto yy1073;
			}
		}
	} else {
		if(yych <= 'l'){
			if(yych <= 'e'){
				if(yych <= 'Y')	goto yy70;
				if(yych == 'd')	goto yy70;
				goto yy1073;
			} else {
				if(yych == 'g')	goto yy1073;
				if(yych <= 'h')	goto yy70;
				goto yy1073;
			}
		} else {
			if(yych <= 'v'){
				if(yych <= 'm')	goto yy70;
				if(yych <= 'r')	goto yy1073;
				if(yych <= 't')	goto yy70;
				goto yy1073;
			} else {
				if(yych == 'x')	goto yy1073;
				if(yych <= 'y')	goto yy70;
				goto yy1073;
			}
		}
	}
yy1073:
	YYDEBUG(1073, *YYCURSOR);

{
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
yy1074:
	YYDEBUG(1074, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy70;
	if(yych <= '9')	goto yy1072;
	goto yy70;
yy1075:
	YYDEBUG(1075, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '2'){
		if(yych <= '/')	goto yy70;
		if(yych >= '1')	goto yy1077;
		goto yy1076;
	} else {
		if(yych <= '3')	goto yy1078;
		if(yych <= '9')	goto yy1072;
		goto yy70;
	}
yy1076:
	YYDEBUG(1076, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy70;
	case '0':	goto yy79;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1079;
	default:	goto yy1073;
	}
yy1077:
	YYDEBUG(1077, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy70;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1079;
	default:	goto yy1073;
	}
yy1078:
	YYDEBUG(1078, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy70;
	case '0':
	case '1':	goto yy1079;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy79;
	default:	goto yy1073;
	}
yy1079:
	YYDEBUG(1079, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 16) {
		goto yy69;
	}
	YYDEBUG(-1, yych);
	switch(yych){
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy79;
	case 'D':	case 'd':	goto yy74;
	case 'F':	case 'f':	goto yy76;
	case 'H':	case 'h':	goto yy73;
	case 'M':	case 'm':	goto yy72;
	case 'S':	case 's':	goto yy71;
	case 'T':	goto yy1081;
	case 'W':	case 'w':	goto yy75;
	case 'Y':	case 'y':	goto yy77;
	case 't':	goto yy1082;
	default:	goto yy1080;
	}
yy1080:
	YYDEBUG(1080, *YYCURSOR);

{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
yy1081:
	YYDEBUG(1081, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'H'){
		if(yych <= '2'){
			if(yych <= '/')	goto yy56;
			if(yych <= '1')	goto yy1098;
			goto yy1099;
		} else {
			if(yych <= '9')	goto yy1100;
			if(yych <= 'G')	goto yy56;
			goto yy81;
		}
	} else {
		if(yych <= 'g'){
			if(yych == 'U')	goto yy82;
			goto yy56;
		} else {
			if(yych <= 'h')	goto yy81;
			if(yych == 'u')	goto yy82;
			goto yy56;
		}
	}
yy1082:
	YYDEBUG(1082, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'H'){
		if(yych <= '2'){
			if(yych <= '/')	goto yy56;
			if(yych >= '2')	goto yy1084;
			goto yy1083;
		} else {
			if(yych <= '9')	goto yy1085;
			if(yych <= 'G')	goto yy56;
			goto yy81;
		}
	} else {
		if(yych <= 'g'){
			if(yych == 'U')	goto yy82;
			goto yy56;
		} else {
			if(yych <= 'h')	goto yy81;
			if(yych == 'u')	goto yy82;
			goto yy56;
		}
	}
yy1083:
	YYDEBUG(1083, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy1092;
	if(yych <= '9')	goto yy1085;
	goto yy56;
yy1084:
	YYDEBUG(1084, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '3')	goto yy1092;
	if(yych <= '5')	goto yy1086;
	goto yy56;
yy1085:
	YYDEBUG(1085, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= '6')	goto yy56;
	goto yy1086;
yy1086:
	YYDEBUG(1086, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= ':')	goto yy56;
	goto yy1087;
yy1087:
	YYDEBUG(1087, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy1088;
	if(yych <= '6')	goto yy1089;
	goto yy56;
yy1088:
	YYDEBUG(1088, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '9')	goto yy1090;
	goto yy56;
yy1089:
	YYDEBUG(1089, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '0')	goto yy56;
	goto yy1090;
yy1090:
	YYDEBUG(1090, *YYCURSOR);
	++YYCURSOR;
	goto yy1091;
yy1091:
	YYDEBUG(1091, *YYCURSOR);

{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
yy1092:
	YYDEBUG(1092, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy1093;
	if(yych <= '9')	goto yy1087;
	goto yy56;
yy1093:
	YYDEBUG(1093, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy1094;
	if(yych <= '6')	goto yy1095;
	if(yych <= '9')	goto yy1087;
	goto yy56;
yy1094:
	YYDEBUG(1094, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy1096;
	if(yych <= '6')	goto yy1097;
	if(yych <= '9')	goto yy1090;
	goto yy56;
yy1095:
	YYDEBUG(1095, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '0')	goto yy1096;
	if(yych <= '5')	goto yy1088;
	if(yych <= '6')	goto yy1089;
	goto yy56;
yy1096:
	YYDEBUG(1096, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy1091;
	if(yych <= '9')	goto yy1090;
	goto yy1091;
yy1097:
	YYDEBUG(1097, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '0')	goto yy1090;
	goto yy1091;
yy1098:
	YYDEBUG(1098, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy1107;
	if(yych <= '9')	goto yy1100;
	if(yych <= ':')	goto yy1101;
	goto yy56;
yy1099:
	YYDEBUG(1099, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '5'){
		if(yych <= '/')	goto yy56;
		if(yych <= '3')	goto yy1107;
		goto yy1086;
	} else {
		if(yych == ':')	goto yy1101;
		goto yy56;
	}
yy1100:
	YYDEBUG(1100, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy1086;
	if(yych != ':')	goto yy56;
	goto yy1101;
yy1101:
	YYDEBUG(1101, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= '6')	goto yy56;
	goto yy1102;
yy1102:
	YYDEBUG(1102, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= ':')	goto yy56;
	goto yy1103;
yy1103:
	YYDEBUG(1103, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy56;
	goto yy1104;
yy1104:
	YYDEBUG(1104, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy1105;
	if(yych <= '6')	goto yy1106;
	goto yy56;
yy1105:
	YYDEBUG(1105, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '9')	goto yy1090;
	goto yy56;
yy1106:
	YYDEBUG(1106, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '0')	goto yy1090;
	goto yy56;
yy1107:
	YYDEBUG(1107, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy1093;
	if(yych <= '9')	goto yy1087;
	if(yych <= ':')	goto yy1101;
	goto yy56;
yy1108:
	YYDEBUG(1108, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy70;
	if(yych <= '0')	goto yy79;
	if(yych <= '9')	goto yy1072;
	goto yy70;
yy1109:
	YYDEBUG(1109, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '2'){
		if(yych <= '/')	goto yy70;
		if(yych <= '0')	goto yy1076;
		goto yy1077;
	} else {
		if(yych <= '3')	goto yy1078;
		if(yych <= '9')	goto yy1072;
		goto yy70;
	}
yy1110:
	YYDEBUG(1110, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1111;
	if(yych != 'c')	goto yy56;
	goto yy1111;
yy1111:
	YYDEBUG(1111, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'E')	goto yy1112;
	if(yych != 'e')	goto yy1047;
	goto yy1112;
yy1112:
	YYDEBUG(1112, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy1113;
	if(yych != 'm')	goto yy56;
	goto yy1113;
yy1113:
	YYDEBUG(1113, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy1114;
	if(yych != 'b')	goto yy56;
	goto yy1114;
yy1114:
	YYDEBUG(1114, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1115;
	if(yych != 'e')	goto yy56;
	goto yy1115;
yy1115:
	YYDEBUG(1115, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1116;
	if(yych != 'r')	goto yy56;
	goto yy1116;
yy1116:
	YYDEBUG(1116, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1047;
yy1117:
	YYDEBUG(1117, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy1118;
	if(yych != 'v')	goto yy56;
	goto yy1118;
yy1118:
	YYDEBUG(1118, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'E')	goto yy1119;
	if(yych != 'e')	goto yy1047;
	goto yy1119;
yy1119:
	YYDEBUG(1119, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy1120;
	if(yych != 'm')	goto yy56;
	goto yy1120;
yy1120:
	YYDEBUG(1120, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy1121;
	if(yych != 'b')	goto yy56;
	goto yy1121;
yy1121:
	YYDEBUG(1121, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1122;
	if(yych != 'e')	goto yy56;
	goto yy1122;
yy1122:
	YYDEBUG(1122, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1116;
	if(yych == 'r')	goto yy1116;
	goto yy56;
yy1123:
	YYDEBUG(1123, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1124;
	if(yych != 't')	goto yy56;
	goto yy1124;
yy1124:
	YYDEBUG(1124, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'O')	goto yy1125;
	if(yych != 'o')	goto yy1047;
	goto yy1125;
yy1125:
	YYDEBUG(1125, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy1126;
	if(yych != 'b')	goto yy56;
	goto yy1126;
yy1126:
	YYDEBUG(1126, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1127;
	if(yych != 'e')	goto yy56;
	goto yy1127;
yy1127:
	YYDEBUG(1127, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1116;
	if(yych == 'r')	goto yy1116;
	goto yy56;
yy1128:
	YYDEBUG(1128, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych == 'C')	goto yy137;
		if(yych <= 'O')	goto yy56;
		goto yy1129;
	} else {
		if(yych <= 'c'){
			if(yych <= 'b')	goto yy56;
			goto yy137;
		} else {
			if(yych != 'p')	goto yy56;
			goto yy1129;
		}
	}
yy1129:
	YYDEBUG(1129, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1130;
	if(yych != 't')	goto yy1047;
	goto yy1130;
yy1130:
	YYDEBUG(1130, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'E')	goto yy1131;
	if(yych != 'e')	goto yy1047;
	goto yy1131;
yy1131:
	YYDEBUG(1131, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'M')	goto yy1132;
	if(yych != 'm')	goto yy56;
	goto yy1132;
yy1132:
	YYDEBUG(1132, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy1133;
	if(yych != 'b')	goto yy56;
	goto yy1133;
yy1133:
	YYDEBUG(1133, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1134;
	if(yych != 'e')	goto yy56;
	goto yy1134;
yy1134:
	YYDEBUG(1134, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1116;
	if(yych == 'r')	goto yy1116;
	goto yy56;
yy1135:
	YYDEBUG(1135, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy1139;
	if(yych == 'g')	goto yy1139;
	goto yy56;
yy1136:
	YYDEBUG(1136, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1137;
	if(yych != 'r')	goto yy56;
	goto yy1137;
yy1137:
	YYDEBUG(1137, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'I')	goto yy1138;
	if(yych != 'i')	goto yy1047;
	goto yy1138;
yy1138:
	YYDEBUG(1138, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'L')	goto yy1116;
	if(yych == 'l')	goto yy1116;
	goto yy56;
yy1139:
	YYDEBUG(1139, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'U')	goto yy1140;
	if(yych != 'u')	goto yy1047;
	goto yy1140;
yy1140:
	YYDEBUG(1140, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'S')	goto yy1141;
	if(yych != 's')	goto yy56;
	goto yy1141;
yy1141:
	YYDEBUG(1141, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1116;
	if(yych == 't')	goto yy1116;
	goto yy56;
yy1142:
	YYDEBUG(1142, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych == 'R')	goto yy1143;
		if(yych <= 'X')	goto yy56;
		goto yy1116;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy56;
			goto yy1143;
		} else {
			if(yych == 'y')	goto yy1116;
			goto yy56;
		}
	}
yy1143:
	YYDEBUG(1143, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'C')	goto yy1144;
	if(yych != 'c')	goto yy1047;
	goto yy1144;
yy1144:
	YYDEBUG(1144, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'H')	goto yy1116;
	if(yych == 'h')	goto yy1116;
	goto yy56;
yy1145:
	YYDEBUG(1145, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy1146;
	if(yych != 'b')	goto yy56;
	goto yy1146;
yy1146:
	YYDEBUG(1146, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'R')	goto yy1147;
	if(yych != 'r')	goto yy1047;
	goto yy1147;
yy1147:
	YYDEBUG(1147, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'U')	goto yy1148;
	if(yych != 'u')	goto yy56;
	goto yy1148;
yy1148:
	YYDEBUG(1148, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1149;
	if(yych != 'a')	goto yy56;
	goto yy1149;
yy1149:
	YYDEBUG(1149, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1150;
	if(yych != 'r')	goto yy56;
	goto yy1150;
yy1150:
	YYDEBUG(1150, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy1116;
	if(yych == 'y')	goto yy1116;
	goto yy56;
yy1151:
	YYDEBUG(1151, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'L')	goto yy1158;
		if(yych <= 'M')	goto yy56;
		goto yy1157;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy56;
			goto yy1158;
		} else {
			if(yych == 'n')	goto yy1157;
			goto yy56;
		}
	}
yy1152:
	YYDEBUG(1152, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy1153;
	if(yych != 'n')	goto yy56;
	goto yy1153;
yy1153:
	YYDEBUG(1153, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 'U')	goto yy1154;
	if(yych != 'u')	goto yy1047;
	goto yy1154;
yy1154:
	YYDEBUG(1154, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1155;
	if(yych != 'a')	goto yy56;
	goto yy1155;
yy1155:
	YYDEBUG(1155, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1156;
	if(yych != 'r')	goto yy56;
	goto yy1156;
yy1156:
	YYDEBUG(1156, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy1116;
	if(yych == 'y')	goto yy1116;
	goto yy56;
yy1157:
	YYDEBUG(1157, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1116;
	if(yych == 'e')	goto yy1116;
	goto yy1047;
yy1158:
	YYDEBUG(1158, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'Y')	goto yy1116;
	if(yych == 'y')	goto yy1116;
	goto yy1047;
yy1159:
	YYDEBUG(1159, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1116;
	goto yy1047;
yy1160:
	YYDEBUG(1160, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != 'I')	goto yy1047;
	goto yy1161;
yy1161:
	YYDEBUG(1161, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1116;
	goto yy1047;
yy1162:
	YYDEBUG(1162, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'I')	goto yy1116;
	goto yy1047;
yy1163:
	YYDEBUG(1163, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '0')	goto yy1176;
	if(yych <= '9')	goto yy1175;
	goto yy56;
yy1164:
	YYDEBUG(1164, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '9')	goto yy1174;
	goto yy56;
yy1165:
	YYDEBUG(1165, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy1172;
	if(yych <= '6')	goto yy1171;
	goto yy56;
yy1166:
	YYDEBUG(1166, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1145;
	if(yych == 'e')	goto yy1145;
	goto yy56;
yy1167:
	YYDEBUG(1167, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1142;
	if(yych == 'a')	goto yy1142;
	goto yy56;
yy1168:
	YYDEBUG(1168, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1170;
	if(yych == 'e')	goto yy1170;
	goto yy56;
yy1169:
	YYDEBUG(1169, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1110;
	if(yych == 'e')	goto yy1110;
	goto yy56;
yy1170:
	YYDEBUG(1170, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy1129;
	if(yych == 'p')	goto yy1129;
	goto yy56;
yy1171:
	YYDEBUG(1171, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '6')	goto yy1173;
	goto yy56;
yy1172:
	YYDEBUG(1172, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= ':')	goto yy56;
	goto yy1173;
yy1173:
	YYDEBUG(1173, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1073;
yy1174:
	YYDEBUG(1174, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '9')	goto yy1173;
	goto yy56;
yy1175:
	YYDEBUG(1175, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '9')	goto yy1173;
	goto yy56;
yy1176:
	YYDEBUG(1176, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '0')	goto yy56;
	if(yych <= '9')	goto yy1173;
	goto yy56;
yy1177:
	YYDEBUG(1177, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '.')	goto yy56;
	if(yych <= '/')	goto yy1180;
	if(yych <= '0')	goto yy1179;
	if(yych <= '9')	goto yy1185;
	goto yy56;
yy1178:
	YYDEBUG(1178, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '.')	goto yy56;
	if(yych <= '/')	goto yy1180;
	if(yych <= '2')	goto yy1185;
	goto yy56;
yy1179:
	YYDEBUG(1179, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '/')	goto yy56;
	goto yy1180;
yy1180:
	YYDEBUG(1180, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '2')	goto yy1181;
	if(yych <= '3')	goto yy1183;
	if(yych <= '9')	goto yy1184;
	goto yy56;
yy1181:
	YYDEBUG(1181, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '/')	goto yy1182;
	if(yych <= '9')	goto yy1184;
	goto yy1182;
yy1182:
	YYDEBUG(1182, *YYCURSOR);

{
		DEBUG_OUTPUT("iso8601date | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy1183:
	YYDEBUG(1183, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy1182;
	if(yych >= '2')	goto yy1182;
	goto yy1184;
yy1184:
	YYDEBUG(1184, *YYCURSOR);
	yych = *++YYCURSOR;
	goto yy1182;
yy1185:
	YYDEBUG(1185, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '/')	goto yy56;
	goto yy1186;
yy1186:
	YYDEBUG(1186, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '2'){
		if(yych <= '/')	goto yy56;
		if(yych >= '1')	goto yy1188;
		goto yy1187;
	} else {
		if(yych <= '3')	goto yy1189;
		if(yych <= '9')	goto yy1184;
		goto yy56;
	}
yy1187:
	YYDEBUG(1187, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy1182;
	if(yych <= '0')	goto yy1184;
	if(yych <= '9')	goto yy1190;
	goto yy1182;
yy1188:
	YYDEBUG(1188, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy1182;
	if(yych <= '9')	goto yy1190;
	goto yy1182;
yy1189:
	YYDEBUG(1189, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy1182;
	if(yych >= '2')	goto yy1182;
	goto yy1190;
yy1190:
	YYDEBUG(1190, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '/')	goto yy1184;
	goto yy1182;
yy1191:
	YYDEBUG(1191, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'A')	goto yy1255;
		if(yych <= 'T')	goto yy56;
		goto yy1254;
	} else {
		if(yych <= 'a'){
			if(yych <= '`')	goto yy56;
			goto yy1255;
		} else {
			if(yych == 'u')	goto yy1254;
			goto yy56;
		}
	}
yy1192:
	YYDEBUG(1192, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1252;
	if(yych == 'e')	goto yy1252;
	goto yy56;
yy1193:
	YYDEBUG(1193, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'A')	goto yy1249;
	if(yych == 'a')	goto yy1249;
	goto yy56;
yy1194:
	YYDEBUG(1194, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'U'){
		if(yych == 'P')	goto yy1246;
		if(yych <= 'T')	goto yy56;
		goto yy1245;
	} else {
		if(yych <= 'p'){
			if(yych <= 'o')	goto yy56;
			goto yy1246;
		} else {
			if(yych == 'u')	goto yy1245;
			goto yy56;
		}
	}
yy1195:
	YYDEBUG(1195, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1242;
	if(yych == 'e')	goto yy1242;
	goto yy56;
yy1196:
	YYDEBUG(1196, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1240;
	if(yych == 'c')	goto yy1240;
	goto yy56;
yy1197:
	YYDEBUG(1197, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'O')	goto yy1238;
	if(yych == 'o')	goto yy1238;
	goto yy56;
yy1198:
	YYDEBUG(1198, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'E')	goto yy1236;
	if(yych == 'e')	goto yy1236;
	goto yy56;
yy1199:
	YYDEBUG(1199, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/'){
		if(yych == '-')	goto yy947;
		goto yy56;
	} else {
		if(yych <= '0')	goto yy910;
		if(yych <= '9')	goto yy1201;
		goto yy56;
	}
yy1200:
	YYDEBUG(1200, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '-')	goto yy947;
	if(yych <= '/')	goto yy56;
	if(yych >= '3')	goto yy56;
	goto yy1201;
yy1201:
	YYDEBUG(1201, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '-')	goto yy56;
	goto yy1202;
yy1202:
	YYDEBUG(1202, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '2'){
		if(yych <= '/')	goto yy56;
		if(yych >= '1')	goto yy1204;
		goto yy1203;
	} else {
		if(yych <= '3')	goto yy1205;
		if(yych <= '9')	goto yy951;
		goto yy56;
	}
yy1203:
	YYDEBUG(1203, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy949;
	if(yych <= '0')	goto yy951;
	if(yych <= '9')	goto yy1206;
	goto yy949;
yy1204:
	YYDEBUG(1204, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy949;
	if(yych <= '9')	goto yy1206;
	goto yy949;
yy1205:
	YYDEBUG(1205, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy949;
	if(yych >= '2')	goto yy949;
	goto yy1206;
yy1206:
	YYDEBUG(1206, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych != 'T')	goto yy1182;
	goto yy1207;
yy1207:
	YYDEBUG(1207, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '1')	goto yy1208;
	if(yych <= '2')	goto yy1209;
	if(yych <= '9')	goto yy1210;
	goto yy56;
yy1208:
	YYDEBUG(1208, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '9')	goto yy1217;
	if(yych <= ':')	goto yy1211;
	goto yy56;
yy1209:
	YYDEBUG(1209, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '3')	goto yy1217;
	if(yych == ':')	goto yy1211;
	goto yy56;
yy1210:
	YYDEBUG(1210, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy56;
	goto yy1211;
yy1211:
	YYDEBUG(1211, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= '6')	goto yy56;
	goto yy1212;
yy1212:
	YYDEBUG(1212, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= ':')	goto yy56;
	goto yy1213;
yy1213:
	YYDEBUG(1213, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy56;
	goto yy1214;
yy1214:
	YYDEBUG(1214, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy1215;
	if(yych <= '6')	goto yy1216;
	goto yy56;
yy1215:
	YYDEBUG(1215, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '9')	goto yy1090;
	goto yy56;
yy1216:
	YYDEBUG(1216, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '0')	goto yy1090;
	goto yy56;
yy1217:
	YYDEBUG(1217, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy56;
	goto yy1218;
yy1218:
	YYDEBUG(1218, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= '6')	goto yy56;
	goto yy1219;
yy1219:
	YYDEBUG(1219, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= ':')	goto yy56;
	goto yy1220;
yy1220:
	YYDEBUG(1220, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != ':')	goto yy56;
	goto yy1221;
yy1221:
	YYDEBUG(1221, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy1222;
	if(yych <= '6')	goto yy1223;
	goto yy56;
yy1222:
	YYDEBUG(1222, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '9')	goto yy1224;
	goto yy56;
yy1223:
	YYDEBUG(1223, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '0')	goto yy56;
	goto yy1224;
yy1224:
	YYDEBUG(1224, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych != '.')	goto yy1091;
	goto yy1225;
yy1225:
	YYDEBUG(1225, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= ':')	goto yy56;
	goto yy1226;
yy1226:
	YYDEBUG(1226, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	goto yy1227;
yy1227:
	YYDEBUG(1227, *YYCURSOR);
	if(yych <= ','){
		if(yych != '+')	goto yy56;
		goto yy1228;
	} else {
		if(yych <= '-')	goto yy1228;
		if(yych <= '/')	goto yy56;
		if(yych <= '9')	goto yy1226;
		goto yy56;
	}
yy1228:
	YYDEBUG(1228, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '1')	goto yy1229;
	if(yych <= '2')	goto yy1230;
	if(yych <= '9')	goto yy1231;
	goto yy56;
yy1229:
	YYDEBUG(1229, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy1091;
	if(yych <= '5')	goto yy1234;
	if(yych <= '9')	goto yy1231;
	if(yych <= ':')	goto yy1232;
	goto yy1091;
yy1230:
	YYDEBUG(1230, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '5'){
		if(yych <= '/')	goto yy1091;
		if(yych <= '3')	goto yy1234;
		goto yy1233;
	} else {
		if(yych == ':')	goto yy1232;
		goto yy1091;
	}
yy1231:
	YYDEBUG(1231, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/')	goto yy1091;
	if(yych <= '5')	goto yy1233;
	if(yych != ':')	goto yy1091;
	goto yy1232;
yy1232:
	YYDEBUG(1232, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/')	goto yy1091;
	if(yych >= '6')	goto yy1091;
	goto yy1233;
yy1233:
	YYDEBUG(1233, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '9')	goto yy1090;
	goto yy56;
yy1234:
	YYDEBUG(1234, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy1091;
	if(yych <= '5')	goto yy1235;
	if(yych <= '9')	goto yy1090;
	if(yych <= ':')	goto yy1232;
	goto yy1091;
yy1235:
	YYDEBUG(1235, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy1091;
	if(yych <= '9')	goto yy1090;
	goto yy1091;
yy1236:
	YYDEBUG(1236, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'C')	goto yy1237;
	if(yych != 'c')	goto yy56;
	goto yy1237;
yy1237:
	YYDEBUG(1237, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych == '-')	goto yy1021;
		goto yy1047;
	} else {
		if(yych <= 'E')	goto yy1112;
		if(yych == 'e')	goto yy1112;
		goto yy1047;
	}
yy1238:
	YYDEBUG(1238, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'V')	goto yy1239;
	if(yych != 'v')	goto yy56;
	goto yy1239;
yy1239:
	YYDEBUG(1239, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych == '-')	goto yy1021;
		goto yy1047;
	} else {
		if(yych <= 'E')	goto yy1119;
		if(yych == 'e')	goto yy1119;
		goto yy1047;
	}
yy1240:
	YYDEBUG(1240, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'T')	goto yy1241;
	if(yych != 't')	goto yy56;
	goto yy1241;
yy1241:
	YYDEBUG(1241, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'N'){
		if(yych == '-')	goto yy1021;
		goto yy1047;
	} else {
		if(yych <= 'O')	goto yy1125;
		if(yych == 'o')	goto yy1125;
		goto yy1047;
	}
yy1242:
	YYDEBUG(1242, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'P')	goto yy1243;
	if(yych != 'p')	goto yy56;
	goto yy1243;
yy1243:
	YYDEBUG(1243, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'S'){
		if(yych == '-')	goto yy1021;
		goto yy1047;
	} else {
		if(yych <= 'T')	goto yy1244;
		if(yych != 't')	goto yy1047;
		goto yy1244;
	}
yy1244:
	YYDEBUG(1244, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych == '-')	goto yy1021;
		goto yy1047;
	} else {
		if(yych <= 'E')	goto yy1131;
		if(yych == 'e')	goto yy1131;
		goto yy1047;
	}
yy1245:
	YYDEBUG(1245, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'G')	goto yy1248;
	if(yych == 'g')	goto yy1248;
	goto yy56;
yy1246:
	YYDEBUG(1246, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'R')	goto yy1247;
	if(yych != 'r')	goto yy56;
	goto yy1247;
yy1247:
	YYDEBUG(1247, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'H'){
		if(yych == '-')	goto yy1021;
		goto yy1047;
	} else {
		if(yych <= 'I')	goto yy1138;
		if(yych == 'i')	goto yy1138;
		goto yy1047;
	}
yy1248:
	YYDEBUG(1248, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych == '-')	goto yy1021;
		goto yy1047;
	} else {
		if(yych <= 'U')	goto yy1140;
		if(yych == 'u')	goto yy1140;
		goto yy1047;
	}
yy1249:
	YYDEBUG(1249, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Y'){
		if(yych == 'R')	goto yy1250;
		if(yych <= 'X')	goto yy56;
		goto yy1251;
	} else {
		if(yych <= 'r'){
			if(yych <= 'q')	goto yy56;
			goto yy1250;
		} else {
			if(yych == 'y')	goto yy1251;
			goto yy56;
		}
	}
yy1250:
	YYDEBUG(1250, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'B'){
		if(yych == '-')	goto yy1021;
		goto yy1047;
	} else {
		if(yych <= 'C')	goto yy1144;
		if(yych == 'c')	goto yy1144;
		goto yy1047;
	}
yy1251:
	YYDEBUG(1251, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '-')	goto yy1021;
	goto yy1047;
yy1252:
	YYDEBUG(1252, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'B')	goto yy1253;
	if(yych != 'b')	goto yy56;
	goto yy1253;
yy1253:
	YYDEBUG(1253, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'Q'){
		if(yych == '-')	goto yy1021;
		goto yy1047;
	} else {
		if(yych <= 'R')	goto yy1147;
		if(yych == 'r')	goto yy1147;
		goto yy1047;
	}
yy1254:
	YYDEBUG(1254, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'N'){
		if(yych == 'L')	goto yy1258;
		if(yych <= 'M')	goto yy56;
		goto yy1257;
	} else {
		if(yych <= 'l'){
			if(yych <= 'k')	goto yy56;
			goto yy1258;
		} else {
			if(yych == 'n')	goto yy1257;
			goto yy56;
		}
	}
yy1255:
	YYDEBUG(1255, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 'N')	goto yy1256;
	if(yych != 'n')	goto yy56;
	goto yy1256;
yy1256:
	YYDEBUG(1256, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'T'){
		if(yych == '-')	goto yy1021;
		goto yy1047;
	} else {
		if(yych <= 'U')	goto yy1154;
		if(yych == 'u')	goto yy1154;
		goto yy1047;
	}
yy1257:
	YYDEBUG(1257, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'D'){
		if(yych == '-')	goto yy1021;
		goto yy1047;
	} else {
		if(yych <= 'E')	goto yy1116;
		if(yych == 'e')	goto yy1116;
		goto yy1047;
	}
yy1258:
	YYDEBUG(1258, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'X'){
		if(yych == '-')	goto yy1021;
		goto yy1047;
	} else {
		if(yych <= 'Y')	goto yy1116;
		if(yych == 'y')	goto yy1116;
		goto yy1047;
	}
yy1259:
	YYDEBUG(1259, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'P'){
		if(yych == 'C')	goto yy137;
		if(yych <= 'O')	goto yy56;
		goto yy883;
	} else {
		if(yych <= 'c'){
			if(yych <= 'b')	goto yy56;
			goto yy137;
		} else {
			if(yych == 'p')	goto yy883;
			goto yy56;
		}
	}
yy1260:
	YYDEBUG(1260, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '.'){
		if(yych <= ',')	goto yy1262;
		if(yych <= '-')	goto yy789;
		goto yy1263;
	} else {
		if(yych <= '/')	goto yy1264;
		if(yych <= '9')	goto yy1009;
		goto yy1262;
	}
yy1261:
	YYDEBUG(1261, *YYCURSOR);
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
	goto yy1262;
yy1262:
	YYDEBUG(1262, *YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	goto yy1261;
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':
	case '-':
	case '.':	goto yy790;
	case 'A':	case 'a':	goto yy873;
	case 'D':	case 'd':	goto yy785;
	case 'F':	case 'f':	goto yy786;
	case 'H':	case 'h':	goto yy73;
	case 'I':	goto yy793;
	case 'J':	case 'j':	goto yy797;
	case 'M':	case 'm':	goto yy784;
	case 'N':	case 'n':	goto yy800;
	case 'O':	case 'o':	goto yy799;
	case 'S':	case 's':	goto yy783;
	case 'T':	case 't':	goto yy78;
	case 'V':	goto yy795;
	case 'W':	case 'w':	goto yy75;
	case 'X':	goto yy796;
	case 'Y':	case 'y':	goto yy77;
	default:	goto yy56;
	}
yy1263:
	YYDEBUG(1263, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy791;
	if(yych <= '0')	goto yy1265;
	if(yych <= '1')	goto yy1266;
	if(yych <= '9')	goto yy1267;
	goto yy791;
yy1264:
	YYDEBUG(1264, *YYCURSOR);
	yych = *++YYCURSOR;
	YYDEBUG(-1, yych);
	switch(yych){
	case 'A':	case 'a':	goto yy959;
	case 'D':	case 'd':	goto yy963;
	case 'F':	case 'f':	goto yy957;
	case 'J':	case 'j':	goto yy956;
	case 'M':	case 'm':	goto yy958;
	case 'N':	case 'n':	goto yy962;
	case 'O':	case 'o':	goto yy961;
	case 'S':	case 's':	goto yy960;
	default:	goto yy56;
	}
yy1265:
	YYDEBUG(1265, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '.')	goto yy1268;
	if(yych <= '/')	goto yy56;
	if(yych <= '9')	goto yy1267;
	goto yy56;
yy1266:
	YYDEBUG(1266, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '.')	goto yy1268;
	if(yych <= '/')	goto yy56;
	if(yych >= '3')	goto yy56;
	goto yy1267;
yy1267:
	YYDEBUG(1267, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != '.')	goto yy56;
	goto yy1268;
yy1268:
	YYDEBUG(1268, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych >= ':')	goto yy56;
	goto yy1269;
yy1269:
	YYDEBUG(1269, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy903;
	if(yych <= '9')	goto yy902;
	goto yy903;
yy1270:
	YYDEBUG(1270, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/'){
		if(yych <= ',')	goto yy1262;
		if(yych <= '-')	goto yy789;
		if(yych >= '/')	goto yy1264;
		goto yy1271;
	} else {
		if(yych <= '5')	goto yy1273;
		if(yych <= '9')	goto yy1009;
		if(yych <= ':')	goto yy1272;
		goto yy1262;
	}
yy1271:
	YYDEBUG(1271, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '1'){
		if(yych <= '/')	goto yy791;
		if(yych <= '0')	goto yy1295;
		goto yy1296;
	} else {
		if(yych <= '5')	goto yy1297;
		if(yych <= '9')	goto yy1298;
		goto yy791;
	}
yy1272:
	YYDEBUG(1272, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy1290;
	if(yych <= '9')	goto yy1291;
	goto yy56;
yy1273:
	YYDEBUG(1273, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == '-')	goto yy1010;
	if(yych <= '/')	goto yy70;
	if(yych >= ':')	goto yy70;
	goto yy1274;
yy1274:
	YYDEBUG(1274, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':
	case '!':
	case '"':
	case '#':
	case '$':
	case '%':
	case '&':
	case '\'':
	case '(':
	case ')':
	case '*':
	case '+':
	case ',':	case 'A':	case 'D':	case 'F':	case 'H':
	case 'I':
	case 'J':	case 'M':
	case 'N':
	case 'O':	case 'S':
	case 'T':	case 'V':	case 'X':
	case 'Y':	case 'a':	case 'd':	case 'f':	case 'h':	case 'j':	case 'm':
	case 'n':
	case 'o':	case 's':
	case 't':	case 'w':	case 'y':	goto yy1042;
	case '-':	goto yy1039;
	case '.':	goto yy1045;
	case '/':	goto yy1040;
	case '0':	goto yy1276;
	case '1':	goto yy1277;
	case '2':	goto yy1278;
	case '3':	goto yy1279;
	case '4':
	case '5':	goto yy1280;
	case '6':	goto yy1281;
	case '7':
	case '8':
	case '9':	goto yy79;
	case 'W':	goto yy1062;
	default:	goto yy1275;
	}
yy1275:
	YYDEBUG(1275, *YYCURSOR);

{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
yy1276:
	YYDEBUG(1276, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy70;
	if(yych <= '0')	goto yy1288;
	if(yych <= '9')	goto yy1289;
	goto yy70;
yy1277:
	YYDEBUG(1277, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy70;
	if(yych <= '2')	goto yy1287;
	if(yych <= '9')	goto yy1286;
	goto yy70;
yy1278:
	YYDEBUG(1278, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy70;
	if(yych <= '9')	goto yy1286;
	goto yy70;
yy1279:
	YYDEBUG(1279, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy70;
	if(yych <= '5')	goto yy1284;
	if(yych <= '6')	goto yy1285;
	if(yych <= '9')	goto yy1282;
	goto yy70;
yy1280:
	YYDEBUG(1280, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy70;
	if(yych <= '9')	goto yy1282;
	goto yy70;
yy1281:
	YYDEBUG(1281, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy70;
	if(yych <= '0')	goto yy1282;
	if(yych <= '9')	goto yy79;
	goto yy70;
yy1282:
	YYDEBUG(1282, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 32) {
		goto yy79;
	}
	if(yych <= 'X'){
		if(yych <= 'G'){
			if(yych <= 'C'){
				if(yych == ' ')	goto yy70;
				goto yy1283;
			} else {
				if(yych == 'E')	goto yy1283;
				if(yych <= 'F')	goto yy70;
				goto yy1283;
			}
		} else {
			if(yych <= 'R'){
				if(yych <= 'H')	goto yy70;
				if(yych == 'M')	goto yy70;
				goto yy1283;
			} else {
				if(yych <= 'T')	goto yy70;
				if(yych == 'W')	goto yy70;
				goto yy1283;
			}
		}
	} else {
		if(yych <= 'l'){
			if(yych <= 'e'){
				if(yych <= 'Y')	goto yy70;
				if(yych == 'd')	goto yy70;
				goto yy1283;
			} else {
				if(yych == 'g')	goto yy1283;
				if(yych <= 'h')	goto yy70;
				goto yy1283;
			}
		} else {
			if(yych <= 'v'){
				if(yych <= 'm')	goto yy70;
				if(yych <= 'r')	goto yy1283;
				if(yych <= 't')	goto yy70;
				goto yy1283;
			} else {
				if(yych == 'x')	goto yy1283;
				if(yych <= 'y')	goto yy70;
				goto yy1283;
			}
		}
	}
yy1283:
	YYDEBUG(1283, *YYCURSOR);

{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			s->errors += tz_not_found;
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
yy1284:
	YYDEBUG(1284, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy70;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1072;
	default:	goto yy1283;
	}
yy1285:
	YYDEBUG(1285, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy70;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':	goto yy1072;
	case '7':
	case '8':
	case '9':	goto yy79;
	default:	goto yy1283;
	}
yy1286:
	YYDEBUG(1286, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy70;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1072;
	default:	goto yy1283;
	}
yy1287:
	YYDEBUG(1287, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy70;
	case '0':	goto yy1076;
	case '1':
	case '2':	goto yy1077;
	case '3':	goto yy1078;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1072;
	default:	goto yy1283;
	}
yy1288:
	YYDEBUG(1288, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy70;
	case '0':	goto yy79;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1072;
	default:	goto yy1283;
	}
yy1289:
	YYDEBUG(1289, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	YYDEBUG(-1, yych);
	switch(yych){
	case ' ':	case 'D':	case 'F':	case 'H':	case 'M':	case 'S':
	case 'T':	case 'W':	case 'Y':	case 'd':	case 'f':	case 'h':	case 'm':	case 's':
	case 't':	case 'w':	case 'y':	goto yy70;
	case '0':	goto yy1076;
	case '1':
	case '2':	goto yy1077;
	case '3':	goto yy1078;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1072;
	default:	goto yy1283;
	}
yy1290:
	YYDEBUG(1290, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy1292;
		goto yy808;
	} else {
		if(yych <= '9')	goto yy1291;
		if(yych <= ':')	goto yy1292;
		goto yy808;
	}
yy1291:
	YYDEBUG(1291, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy1292;
	if(yych != ':')	goto yy808;
	goto yy1292;
yy1292:
	YYDEBUG(1292, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy1293;
	if(yych <= '6')	goto yy1294;
	if(yych <= '9')	goto yy813;
	goto yy56;
yy1293:
	YYDEBUG(1293, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy814;
	if(yych <= '/')	goto yy808;
	if(yych <= '9')	goto yy813;
	goto yy808;
yy1294:
	YYDEBUG(1294, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy814;
	if(yych == '0')	goto yy813;
	goto yy808;
yy1295:
	YYDEBUG(1295, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy1299;
		goto yy808;
	} else {
		if(yych <= '9')	goto yy1298;
		if(yych <= ':')	goto yy1292;
		goto yy808;
	}
yy1296:
	YYDEBUG(1296, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy1299;
		goto yy808;
	} else {
		if(yych <= '2')	goto yy1298;
		if(yych <= '9')	goto yy1291;
		if(yych <= ':')	goto yy1292;
		goto yy808;
	}
yy1297:
	YYDEBUG(1297, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy1299;
		goto yy808;
	} else {
		if(yych <= '9')	goto yy1291;
		if(yych <= ':')	goto yy1292;
		goto yy808;
	}
yy1298:
	YYDEBUG(1298, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy1299;
	if(yych == ':')	goto yy1292;
	goto yy808;
yy1299:
	YYDEBUG(1299, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/')	goto yy56;
	if(yych <= '5')	goto yy1300;
	if(yych <= '6')	goto yy1301;
	if(yych <= '9')	goto yy901;
	goto yy56;
yy1300:
	YYDEBUG(1300, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy814;
	if(yych <= '/')	goto yy808;
	if(yych <= '9')	goto yy1302;
	goto yy808;
yy1301:
	YYDEBUG(1301, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/'){
		if(yych == '.')	goto yy814;
		goto yy808;
	} else {
		if(yych <= '0')	goto yy1302;
		if(yych <= '9')	goto yy902;
		goto yy808;
	}
yy1302:
	YYDEBUG(1302, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '.')	goto yy814;
	if(yych <= '/')	goto yy808;
	if(yych <= '9')	goto yy904;
	goto yy808;
yy1303:
	YYDEBUG(1303, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/'){
		if(yych <= ',')	goto yy782;
		if(yych <= '-')	goto yy789;
		if(yych <= '.')	goto yy792;
		goto yy788;
	} else {
		if(yych <= '5')	goto yy1273;
		if(yych <= '9')	goto yy1009;
		if(yych <= ':')	goto yy801;
		goto yy782;
	}
yy1304:
	YYDEBUG(1304, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '/'){
		if(yych <= ',')	goto yy1262;
		if(yych <= '-')	goto yy789;
		if(yych <= '.')	goto yy1271;
		goto yy788;
	} else {
		if(yych <= '5')	goto yy1273;
		if(yych <= '9')	goto yy1009;
		if(yych <= ':')	goto yy1272;
		goto yy1262;
	}
yy1305:
	YYDEBUG(1305, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '0')	goto yy56;
	if(yych >= ':')	goto yy56;
	goto yy1306;
yy1306:
	YYDEBUG(1306, *YYCURSOR);
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	goto yy1307;
yy1307:
	YYDEBUG(1307, *YYCURSOR);
	if(yych <= '/')	goto yy1308;
	if(yych <= '9')	goto yy1306;
	goto yy1308;
yy1308:
	YYDEBUG(1308, *YYCURSOR);

{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1309:
	YYDEBUG(1309, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '`'){
		if(yych <= ')'){
			if(yych <= '(')	goto yy3;
			goto yy49;
		} else {
			if(yych <= '@')	goto yy3;
			if(yych <= 'Z')	goto yy51;
			goto yy3;
		}
	} else {
		if(yych <= 'l'){
			if(yych != 'd')	goto yy51;
			goto yy1310;
		} else {
			if(yych <= 'm')	goto yy1311;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy1310:
	YYDEBUG(1310, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Z'){
		if(yych == ')')	goto yy49;
		if(yych <= '@')	goto yy3;
		goto yy52;
	} else {
		if(yych <= '`')	goto yy3;
		if(yych <= 'a')	goto yy1318;
		if(yych <= 'z')	goto yy52;
		goto yy3;
	}
yy1311:
	YYDEBUG(1311, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Z'){
		if(yych == ')')	goto yy49;
		if(yych <= '@')	goto yy3;
		goto yy52;
	} else {
		if(yych <= 'n'){
			if(yych <= '`')	goto yy3;
			goto yy52;
		} else {
			if(yych <= 'o')	goto yy1312;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy1312:
	YYDEBUG(1312, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == ')')	goto yy49;
	if(yych != 'r')	goto yy3;
	goto yy1313;
yy1313:
	YYDEBUG(1313, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != 'r')	goto yy56;
	goto yy1314;
yy1314:
	YYDEBUG(1314, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != 'o')	goto yy56;
	goto yy1315;
yy1315:
	YYDEBUG(1315, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != 'w')	goto yy56;
	goto yy1316;
yy1316:
	YYDEBUG(1316, *YYCURSOR);
	++YYCURSOR;
	goto yy1317;
yy1317:
	YYDEBUG(1317, *YYCURSOR);

{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1318:
	YYDEBUG(1318, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == ')')	goto yy49;
	if(yych != 'y')	goto yy3;
	goto yy1319;
yy1319:
	YYDEBUG(1319, *YYCURSOR);
	++YYCURSOR;
	goto yy1320;
yy1320:
	YYDEBUG(1320, *YYCURSOR);

{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1321:
	YYDEBUG(1321, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Z'){
		if(yych == ')')	goto yy49;
		if(yych <= '@')	goto yy3;
		goto yy51;
	} else {
		if(yych <= 'c'){
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 'd')	goto yy1322;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy1322:
	YYDEBUG(1322, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Z'){
		if(yych == ')')	goto yy49;
		if(yych <= '@')	goto yy3;
		goto yy52;
	} else {
		if(yych <= 'm'){
			if(yych <= '`')	goto yy3;
			goto yy52;
		} else {
			if(yych <= 'n')	goto yy1323;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy1323:
	YYDEBUG(1323, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == ')')	goto yy49;
	if(yych != 'i')	goto yy3;
	goto yy1324;
yy1324:
	YYDEBUG(1324, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != 'g')	goto yy56;
	goto yy1325;
yy1325:
	YYDEBUG(1325, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != 'h')	goto yy56;
	goto yy1326;
yy1326:
	YYDEBUG(1326, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych == 't')	goto yy1319;
	goto yy56;
yy1327:
	YYDEBUG(1327, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= '`'){
		if(yych <= '@'){
			if(yych == ')')	goto yy49;
			goto yy3;
		} else {
			if(yych == 'V')	goto yy618;
			if(yych <= 'Z')	goto yy51;
			goto yy3;
		}
	} else {
		if(yych <= 'u'){
			if(yych == 'o')	goto yy1330;
			goto yy51;
		} else {
			if(yych <= 'v')	goto yy618;
			if(yych <= 'w')	goto yy1328;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy1328:
	YYDEBUG(1328, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) <= '@'){
		if(yych == ')')	goto yy49;
		goto yy1329;
	} else {
		if(yych <= 'Z')	goto yy52;
		if(yych <= '`')	goto yy1329;
		if(yych <= 'z')	goto yy52;
		goto yy1329;
	}
yy1329:
	YYDEBUG(1329, *YYCURSOR);

{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1330:
	YYDEBUG(1330, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Z'){
		if(yych == ')')	goto yy49;
		if(yych <= '@')	goto yy3;
		goto yy52;
	} else {
		if(yych <= 'm'){
			if(yych <= '`')	goto yy3;
			goto yy52;
		} else {
			if(yych <= 'n')	goto yy1331;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy1331:
	YYDEBUG(1331, *YYCURSOR);
	++YYCURSOR;
	if((yych = *YYCURSOR) == ')')	goto yy49;
	goto yy1332;
yy1332:
	YYDEBUG(1332, *YYCURSOR);

{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1333:
	YYDEBUG(1333, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Z'){
		if(yych == ')')	goto yy49;
		if(yych <= '@')	goto yy3;
		goto yy51;
	} else {
		if(yych <= 'r'){
			if(yych <= '`')	goto yy3;
			goto yy51;
		} else {
			if(yych <= 's')	goto yy1334;
			if(yych <= 'z')	goto yy51;
			goto yy3;
		}
	}
yy1334:
	YYDEBUG(1334, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych <= 'Z'){
		if(yych == ')')	goto yy49;
		if(yych <= '@')	goto yy3;
		goto yy52;
	} else {
		if(yych <= 's'){
			if(yych <= '`')	goto yy3;
			goto yy52;
		} else {
			if(yych <= 't')	goto yy1335;
			if(yych <= 'z')	goto yy52;
			goto yy3;
		}
	}
yy1335:
	YYDEBUG(1335, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == ')')	goto yy49;
	if(yych != 'e')	goto yy3;
	goto yy1336;
yy1336:
	YYDEBUG(1336, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != 'r')	goto yy56;
	goto yy1337;
yy1337:
	YYDEBUG(1337, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != 'd')	goto yy56;
	goto yy1338;
yy1338:
	YYDEBUG(1338, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != 'a')	goto yy56;
	goto yy1339;
yy1339:
	YYDEBUG(1339, *YYCURSOR);
	yych = *++YYCURSOR;
	if(yych != 'y')	goto yy56;
	goto yy1340;
yy1340:
	YYDEBUG(1340, *YYCURSOR);
	++YYCURSOR;
	goto yy1341;
yy1341:
	YYDEBUG(1341, *YYCURSOR);

{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
}
}

}

#define YYMAXFILL 26


timelib_time* timelib_strtotime(char *s, int *errors, timelib_tzdb *tzdb)
{
	Scanner in;
	int t;

	memset(&in, 0, sizeof(in));
	in.str = malloc(strlen(s) + YYMAXFILL);
	memset(in.str, 0, strlen(s) + YYMAXFILL);
	memcpy(in.str, s, strlen(s));
	in.lim = in.str + strlen(s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = -1;
	in.time->d = -1;
	in.time->m = -1;
	in.time->h = -1;
	in.time->i = -1;
	in.time->s = -1;
	in.time->f = -1;
	in.time->z = -1;
	in.time->dst = -1;
	in.errors = 0;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	do {
		t = scan(&in);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	free(in.str);
	*errors = in.errors;
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options && TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == -1) parsed->y = now->y != -1 ? now->y : 0;
	if (parsed->d == -1) parsed->d = now->d != -1 ? now->d : 0;
	if (parsed->m == -1) parsed->m = now->m != -1 ? now->m : 0;
	if (parsed->h == -1) parsed->h = now->h != -1 ? now->h : 0;
	if (parsed->i == -1) parsed->i = now->i != -1 ? now->i : 0;
	if (parsed->s == -1) parsed->s = now->s != -1 ? now->s : 0;
	if (parsed->f == -1) parsed->f = now->f != -1 ? now->f : 0;
	if (parsed->z == -1) parsed->z = now->z != -1 ? now->z : 0;
	if (parsed->dst == -1) parsed->dst = now->dst != -1 ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, long gmtoffset, int isdst)
{
	timelib_tz_lookup_table *tp;

	tp = zone_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS", 
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;				
}
#endif

/*
 * vim: syntax=c
 */
