# Copyright 2001-2004 Six Apart. This code cannot be redistributed without
# permission from www.movabletype.org.
#
# $Id: ja.pm,v 1.36 2004/10/19 01:47:18 hirata Exp $

package MT::L10N::ja;   # Japanese
use strict;
use MT::L10N;
use vars qw( @ISA %Lexicon );
@ISA = qw( MT::L10N::en_us );

sub encoding { "UTF-8" }   # UTF-8
## Change this if you need a different encoding.

## The following is the translation table.
%Lexicon = (
	## tmpl/cms/bm_entry.tmpl
	'Select' => '選択',
	'You must choose a weblog in which to post the new entry.' => '新しいエントリーを投稿するウェブログを選んでください。',
	'Ping TrackBack URL:' => 'トラックバックを送るURL:',
	'Select a TrackBack entry to ping:' => 'トラックバックするエントリーを選んでください:',
	'None' => 'なし',
	'Select a weblog for this post:' => '投稿先のウェブログ: ',
	'Select a weblog' => 'ウェブログを選択',
	'Post Status' => '投稿の状態',
	'Draft' => '下書き',
	'Publish' => '公開',
	'Title' => 'タイトル',
	'Primary Category' => '主カテゴリー',
	'Allow Comments' => 'コメントを受けいれる',
	'Open' => 'オープン',
	'Closed' => 'クローズ',
	'Allow TrackBack Pings' => 'トラックバックを許可する',
	'Text Formatting' => 'テキストフォーマット',
	'Bold' => '太字',
	'Italic' => 'イタリック',
	'Underline' => 'アンダーライン',
	'Insert Link' => 'ハイパーリンク',
	'Entry Body' => 'エントリーの内容(body)',
	'Extended Entry' => '追記(extend)',
	'Excerpt' => '概要(excerpt)',
	'Keywords' => 'キーワード',
	'Cancel' => '取り消し',
	'Post' => '投稿',

	## tmpl/cms/bm_posted.tmpl
	'Your new entry has been saved to [_1]' => '[_1] に新しいエントリーを保存しました',
	', and it has been posted to your site' => ', そして投稿されました',
	'View your site' => 'サイトの確認',
	'Edit this entry' => 'エントリーの編集',
	'Close' => '閉じる',

	## tmpl/cms/bookmarklets.tmpl
	'QuickPost' => 'クイックポスト',
	'_USAGE_BOOKMARKLET_3' => 'Movable Type の bookmarklet をインストールするため、このリンクを、ブラウザのリンクか、お気に入りにドラッグしてください :',
	'_USAGE_BOOKMARKLET_4' => 'bookmarklet をインストールした後は、ウェブを見ているときはいつでも 投稿できます。ブログしたいページを見ているときに bookmarklet をクリックすると、編集ウィンドウが開きます。ウィンドウでウェブログを選んで「投稿」を押すだけで、エントリーを作成できます。',
	'_USAGE_BOOKMARKLET_5' => '他にも、Windows でインターネットエキスプローラを使っているなら、「MT It!」を右クリックメニューに追加することができます。下のリンクをクリックし、ウィンドウが開いたら、「Open」を押してください。その後、ブラウザを再起動すると、右クリックで使えるようになります。',
	'Add QuickPost to Windows right-click menu' => 'クイックポストを右クリックメニューに追加する',
	'_USAGE_BOOKMARKLET_1' => '普通の Movable Type のインターフェイスを使わずに、クリックするだけで投稿、公開できるように bookmarklet を設定します',
	'_USAGE_BOOKMARKLET_2' => 'Movable Type の bookmarklet ウィンドウを使うときのレイアウトをカスタマイズできます。例えば、bookmarklet でも概要を追加できます。bookmarkletのウィンドウでは、標準では、投稿するウェブログを選択するプルダウンメニュー、投稿の状態 (下書きか公開) を選択するプルダウンメニュー、タイトル、エントリーの内容を設定できます。',
	'Include:' => '追加項目:',
	'TrackBack items' => 'トラックバックする',
	'Category' => 'カテゴリー',
	# 'Allow Comments' => 'コメントを受けいれる',
	'Allow Pings' => 'トラックバックを受けいれる',
	# 'Text Formatting' => 'テキストフォーマット',
	# 'Excerpt' => '概要(excerpt)',
	# 'Extended Entry' => '追記(extend)',
	# 'Keywords' => 'キーワード',
	'Create' => '作成',

	## tmpl/cms/category_add.tmpl
	'Add A Category' => 'カテゴリーを追加',
	'To create a new category, enter a title in the field below, select a parent category, and click the Add button.' => 'カテゴリーを追加するときは、タイトルを入力した後、親カテゴリーを選択して「追加」を押してください。',
	'Category Title:' => 'カテゴリー・タイトル:',
	'Parent Category:' => '親カテゴリー',
	'Top Level' => 'トップ・レベル',
	# 'Cancel' => '取り消し',
	'Add' => '追加',

	## tmpl/cms/cfg_archives.tmpl
	'Core Setup' => '基本設定',
	'Preferences' => 'ウェブログの設定',
	'Archive Files' => 'アーカイブの設定',
	'IP Banning' => '禁止IP',
	'Your weblog\'s archive configuration has been saved.' => 'アーカイブの設定を保存しました。',
	'You have successfully added a new archive-template association.' => 'アーカイブとテンプレートの関連づけが追加されました。',
	'The selected archive-template associations have been deleted.' => '選択したテンプレートは削除されました',
	'This screen allows you to enable or disable archive types and assign one or more templates to each archive. For example, you may want to create two different views of your monthly archives: one in which the entries for a particular month are presented as a list, and the other representing the entries in a calendar view of that month.' => 'この画面では、アーカイブの種類を有効にしたり、それぞれのアーカイブに複数のテンプレートを設定したりすることができます。月別のアーカイブを二つ作り、例えば、一つは一月分のエントリーのリストにして、もうひとつは、カレンダーのようにエントリーを見られるようにする、などといったことができます。',
	'Create A New Template/Archive Type Association' => '新しく、テンプレートとアーカイブを関連付ける。',
	'Select the type of archive you want to create, then choose which template to associate with that archive type. Finally, click the Add button. The new archive will be shown in the table below.' => '作成したいアーカイブの種類を選んで、そのアーカイブに関連付けたいテンプレートを選んでください。「追加」を押すと、新しいアーカイブがリストに表示されます。',
	'Archive Type:' => 'アーカイブの種類:',
	'Individual' => '個別',
	'Daily' => '日別',
	'Weekly' => '週別',
	'Monthly' => '月別',
	# 'Category' => 'カテゴリー',
	'Template:' => 'テンプレート:',
	# 'Add' => '追加',
	'Archives' => 'アーカイブ',
	'In the table below you can enable or disable each archive type, customize the output path for each archive template, select a preferred template for each archive type, or delete any template from an archive type.' => 'それぞれのアーカイブの種類ごとに、利用する/しないを設定し、アーカイブのテンプレート毎に、出力パス名をカスタマイズしてください。また、それぞれのアーカイブの種類に対して、優先させるテンプレートを選んでください。もしくは削除することもできます。',
	'Archive Types' => 'アーカイブの種類',
	'Template' => 'テンプレート',
	'Archive File Template' => 'アーカイブ・ファイルのテンプレート',
	'Preferred' => '優先',
	'Delete' => '削除',
	'Save Changes' => '変更を保存',

	## tmpl/cms/cfg_archives_add.tmpl
	'_USAGE_ARCHIVING_3' => '新しいアーカイブテンプレートを追加したいアーカイブの種類を選択し、その後、アーカイブの種類に関連づけたいテンプレートを選んでください。',
	'Archive Type' => 'アーカイブの種類',
	# 'Individual' => '個別',
	# 'Daily' => '日別',
	# 'Weekly' => '週別',
	# 'Monthly' => '月別',
	# 'Category' => 'カテゴリー',
	# 'Template' => 'テンプレート',
	# 'Cancel' => '取り消し',
	# 'Add' => '追加',

	## tmpl/cms/cfg_banlist.tmpl
	# 'Core Setup' => '基本設定',
	# 'Preferences' => 'ウェブログの設定',
	# 'Archive Files' => 'アーカイブの設定',
	# 'IP Banning' => '禁止IP',
	'You have added [_1] to your list of banned IP addresses.' => '[_1] をリストに追加しました。',
	'You have successfully deleted the selected IP addresses from the list.' => '選択したIPアドレスを削除しました',
	'This screen allows you to ban IP addresses from commenting or sending TrackBack pings to your weblog.' => 'この画面では、コメントやトラックバックの送信元IPアドレスを制限することができます。',
	'Add an IP Address to the Ban List' => 'IPアドレスを禁止リストに追加する',
	'Enter the IP address in the field below and click Add.' => 'IPアドレスを入力して、「追加」を押してください。',
	'Example:' => '例:',
	'IP Address:' => 'IPアドレス',
	# 'Add' => '追加',
	'IP Ban List' => '禁止IPアドレスリスト',
	'To delete a banned IP address, check the Delete box in the table below and click the Delete button.' => '禁止したIPアドレスを削除したいときは、チェックして「削除」を押してください。',
	'You have [quant,_1,IP] in your list of banned addresses.' => '現在、[quant,_1,個,個,]の IP アドレスが設定されています。',
	'IP Address' => 'IPアドレス',
	'Date Added' => '作成日',
	# 'Delete' => '削除',

	## tmpl/cms/cfg_prefs.tmpl
	# 'Core Setup' => '基本設定',
	# 'Preferences' => 'ウェブログの設定',
	# 'Archive Files' => 'アーカイブの設定',
	# 'IP Banning' => '禁止IP',
	'Your blog preferences have been saved.' => 'ウェブログの設定を保存しました。',
	'_USAGE_PREFS' => 'この画面では、ウェブログのアーカイブ、コメント、広報と通知についてのオプションを設定できます。新しいウェブログを作ったときには、デフォルトの設定になります。',
	'General Settings' => '一般的な設定',
	'Archiving Preferences' => 'アーカイブの設定',
	'Publicity / Remote Interfaces / TrackBack' => '広報 / リモートインターフェイス / トラックバック',
	'Comment Configuration' => 'コメントの設定',
	'Description:' => 'ウェブログの説明: ',
	'Enter a description for your blog.' => 'ウェブログの説明を入力してください',
	'Number of Days Displayed:' => '表示する日数',
	'Enter the number of days\' entries you would like displayed on your index.' => 'エントリーをインデックスに表示しておきたい日数を入力してください。',
	'Language for Date Display:' => '日付用の言語:',
	'Czech' => 'チェコ語',
	'Danish' => 'デンマーク語',
	'Dutch' => 'オランダ語',
	'English' => '英語',
	'Estonian' => 'エストニア語',
	'French' => 'フランス語',
	'German' => 'ドイツ語',
	'Icelandic' => 'アイスランド語',
	'Italian' => 'イタリア語',
	'Japanese' => '日本語',
	'Norwegian' => 'ノルウェー語',
	'Polish' => 'ポーランド語',
	'Portuguese' => 'ポルトガル語',
	'Slovak' => 'スロヴァキア語',
	'Slovenian' => 'スロヴェニア語',
	'Spanish' => 'スペイン語',
	'Suomi' => 'フィンランド語',
	'Swedish' => 'スウェーデン語',
	'Select the language in which you would like dates on your blog displayed.' => '日付を表示するときの言語を選んでください',
	'Order of Entries Displayed:' => 'エントリーの表示順',
	'Ascending' => '古いものが上',
	'Descending' => '新しいものが上',
	'Select whether you want your posts displayed in ascending (oldest at top) or descending (newest at top) order.' => 'エントリーが表示される順を新しいもの順か、古いもの順か選んでください',
	'Default Text Formatting for New Entries:' => '新規エントリーのデフォルトのテキストフォーマット',
	'Specifies the default Text Formatting option when creating a new entry.' => '新しいエントリーを作るときのデフォルトのテキストフォーマット設定',
	'Default Post Status:' => 'デフォルトの投稿の状態',
	# 'Draft' => '下書き',
	# 'Publish' => '公開',
	'Specifies the default Post Status when creating a new entry.' => '新しいエントリーを投稿したときの投稿 の状態のデフォルトの設定',
	'Number of Words in Excerpt:' => '概要に載せる文字数',
	'Enter the number of words that should appear in an auto-generated excerpt:' => '概要を自動生成するときに表示する文字数を入力してください',
	'Sanitize Spec:' => '除去機能',
	'Specifies the list of HTML tags allowed by default when cleaning an HTML string (a comment, for example).' => 'HTMLタグを(コメントなどで)取り除くとき、デフォルトで許可するHTMLタグを指定してください',
	'Use defaults' => '標準の設定',
	'Use my settings:' => 'カスタマイズ',
	'Welcome Message:' => '表示されるメッセージ',
	'Enter a welcome message to be displayed on the Editing Menu to authors of your blog.' => 'ウェブログのメニューに表示されるメッセージを入力してください',
	'Creative Commons License:' => 'クリエイティブ・コモンズ・ライセンス:',
	'Select a Creative Commons license for the posts on your blog (optional).' => 'ウェブログの記事のクリエイティブ・コモンズ・ライセンスを選んでください (登録しなくてもよい)',
	'Be sure that you understand these licenses before applying them to your own work.' => 'ライセンスを設定する前に、これらのライセンスを利用することは、あなたの責任になることを理解した上で設定してください。',
	'Read more.' => '詳しくはこちら。',
	'Your weblog is currently licensed under:' => '現在のライセンス:',
	'Change your license' => 'ライセンスの変更する',
	'Remove this license' => 'このライセンスを取り除く',
	'Your weblog does not have an explicit Creative Commons license.' => 'クリエイティブ・コモンズ・ライセンスを表示していません。',
	'Create a license now' => 'ライセンスを設定する',
	'Preferred Archive Type:' => '優先するアーカイブのタイプ',
	'No Archives' => 'アーカイブはない',
	# 'Individual' => '個別',
	# 'Daily' => '日別',
	# 'Weekly' => '週別',
	# 'Monthly' => '月別',
	# 'Category' => 'カテゴリー',
	'When linking to an archived entry&#8212;for a permalink, for example&#8212;you must link to a particular archive type, even if you have chosen multiple archive types.' => 'パーマリンクに利用するアーカイブタイプを選んでください。複数選んでいたとしても、特定のアーカイブを選ぶ必要があります。',
	'File Extension for Archive Files:' => 'アーカイブ・ファイルの拡張子',
	'Enter the archive file extension. This can take the form of \'html\', \'shtml\', \'php\', etc. Note: Do not enter the leading period (\'.\').' => 'アーカイブのファイルの拡張子を入力してください。「html」「shtml」「php」などをを設定できます。頭の.(ピリオド)」は入力しないでください。',
	'Use Old-Style Archive Links' => '以前の形式の個別アーカイブへのリンクをつかう',
	'Use backward-compatible links for individual archive pages?' => '個別のアーカイブへのリンクに以前の形式(id)を利用しますか?',
	'Notify the following sites when I update my blog:' => 'ウェブログが更新されたときに通知する',
	'When you update your blog, Movable Type will automatically notify the selected sites.' => 'ウェブログが更新されたときに、Movable Type が自動的に通知するサイト',
	'Others: (Separate URLs with a carriage return.)' => '他のサイト(複数のURLを入れるときは、改行してください。)',
	'Recently Updated Key:' => 'Recent Updaed キー:',
	'If you have received a recently updated key (by virtue of your purchase or donation), enter it here.' => 'Recent Update Key を受けとっていたら(ドネーションしたか、購入したら手にはいります) ここに入力してください。',
	'Google API Key:' => 'Google API キー:',
	'If you wish to use any of the Google API functionality, you will need a Google API key. Paste it in here.' => 'Google API を利用したいときは、ここにキーを入力してください',
	'&quot;Allow TrackBack Pings&quot; On by Default' => 'トラックバックをデフォルトで受け付ける',
	'Specifies whether Allow Pings is checked or unchecked by default when creating a new entry.' => '新しいエントリーを作るときに、トラックバックを受けつけるかどうかのデフォルトの設定',
	'Email New TrackBack Pings' => 'トラックバックをメールを通知する',
	'Would you like to be notified via email when someone sends a TrackBack ping to your site?' => 'トラックバックを受け取ったら、メールで通知してほしいですか',
	'Enable TrackBack Auto-Discovery' => 'トラックバック先の自動検出を動作させる',
	'If you turn on auto-discovery, when you write a new post, any external links will be extracted and the appropriate sites automatically sent TrackBack pings.' => 'auto-discovery を動作させると、新しいエントリーを作るとき、すべての外部へのリンクを調べて、適切なサイトには自動的にトラックバックを送ります。',
	'Accept Comments from Unregistered Visitors' => '未登録の読者からのコメントを受けつける',
	'Should visitors to your site be able to post comments without registering first&#8212;that is, without choosing a password?' => '先に登録することなく訪問者がコメントを投稿できるようにしますか?',
	'Require Name and Email Address Information' => '名前とメールアドレスを必須にしますか?',
	'Should visitors to your site be required to submit a name and email address in order to post comments?' => '名前とメールアドレスを通知しないとコメントが投稿できないように設定しますか?',
	'Enable Unregistered Comment Moderation' => 'コメントの事前確認を有効にする。',
	'If you enable moderation, unregistered comments will not be displayed on the site until you have the chance to approve them.' => 'コメントの事前承認を設定すると、未登録コメンターからのコメントが表示される前に、承認することができます。',
	'Accept Comments from Registered Visitors' => '登録されたコメンターのコメントは許可する',
	'Should visitors to your site be able to post comments with a registered identity?' => 'すでに登録されたIDを持っているコメンターはコメントを投稿できるようにしますか?',
	'To enable this option, enter your TypeKey Token in the box below.' => 'この設定を有効にするためには、TypeKey トークンを入力してください。',
	'TypeKey Token:' => 'TypeKey トークン:',
	'To enable comment registration, enter your TypeKey site token.' => 'コメントレジストレーション機能を有効にするため、TypeKey のサイト・トークンを入力してください',
	'To sign up for a TypeKey token, visit the ' => 'TypeKey トークンを取得するために、登録してください。',
	'website' => 'ウェブサイト',
	'Automatically Approve Registered Commenters' => 'コメンターを自動的に登録する',
	'Do you want to automatically approve registered commenters the first time they comment? You can always change their status later.' => '初めてコメントしてくれた人を自動的に登録しますか? この設定は後で変更することができます。',
	'Require Email Addresses From TypeKey' => 'TypeKey からメールアドレスを取得する',
	'Commenters who have verified their identity can choose whether to reveal their email address to you, the weblog author. Do you want to require that commenters pass their email address, in order to be allowed to comment?' => 'TypeKey に登録しているコメンターへ、ウェブログの投稿者にメールアドレスを送信するかどうか、選択することができます。コメントを自動的に許可するために、メールアドレスを送信するように要求しますか?',
	'&quot;Allow Comments&quot; Default:' => 'デフォルトでの「コメントを受けつける」の設定',
	# 'None' => 'なし',
	# 'Open' => 'オープン',
	# 'Closed' => 'クローズ',
	'Specifies the default Allow Comments setting when creating a new entry. Note: This option is ignored if you are not accepting comments.' => '新しいエントリーが登録されたときに利用するデフォルトの「コメントを受けつける」の状態を設定してください。このオプションはコメントを受けつけないときは無視されます。',
	'Comment Listing Order:' => 'コメントを並べる順番',
	'Select whether you want visitor comments displayed in ascending (oldest at top) or descending (newest at top) order.' => 'コメントの表示順を、古いもの順か新しいもの順か選んでください',
	'Text Formatting for Comments:' => 'コメントのテキストフォーマット',
	'Specifies the Text Formatting option to use for formatting visitor comments.' => 'コメントに適用するテキストフォーマットの設定',
	'Allow HTML in Comments' => 'コメントでのHTMLの利用を許可する',
	'Should visitors be able to include HTML in their comments? If not, all HTML entered will be stripped out.' => 'コメントにHTMLコードの入力を許可するか、もしくは無効にします',
	'Auto-Link URLs' => 'URLを自動的にリンクにする',
	'If enabled, all web URLs will be transformed into links to that web URL. Note: If you have enabled Allow HTML in comments, this option is ignored.' => 'URL が入力されたときに、自動的にリンクにします。(注意: 「コメントでのHTMLの利用を許可する」をチェックしていれば、このオプションは無視されます)',
	'Email New Comments' => 'コメントが登録されたら通知する',
	'Would you liked to be notified via email when someone posts comments to your site?' => 'コメントが登録されたときにメールで通知しますか',
	# 'Save Changes' => '変更を保存',

	## tmpl/cms/copyright.tmpl

	## tmpl/cms/delete_confirm.tmpl
	'Are you sure you want to permanently delete the [quant,_1,author] from the system?' => '[quant,_1,人,人]の投稿者を Movable Type から完全に削除していいですか?',
	'Are you sure you want to delete the [quant,_1,comment]?' => '[quant,_1,個,,個] のコメントを削除していいですか?',
	'Are you sure you want to delete the [quant,_1,ping]?' => '[quant,_1,個,個]のトラックバックを削除していいですか?',
	'Are you sure you want to delete the [quant,_1,entry,entries]?' => '[quant,_1,個,個]のエントリーを削除していいですか',
	'Are you sure you want to delete the [quant,_1,template]?' => '[quant,_1,個,個]のテンプレートを削除していいですか？',
	'Are you sure you want to delete the [quant,_1,category,categories]? When you delete a category, all entries assigned to that category will be unassigned from that category.' => '[quant,_1,個,個] のカテゴリーを削除していいですか？ カテゴリーを削除すると、そのカテゴリーを設定されたエントリーは、カテゴリーが設定されていない状態になります。',
	'Are you sure you want to delete the [quant,_1,template] from the particular archive type(s)?' => 'このアーカイブの種類の[quant,_1,個,個]のテンプレートを削除していいですか?',
	'Are you sure you want to delete the [quant,_1,IP address,IP addresses] from your Banned IP List?' => 'Banned IP リストから、[quant,_1,個,個]のIPアドレス を削除していいですか',
	'Are you sure you want to delete the [quant,_1,notification address,notification addresses]?' => '[quant,_1,個,個]の通知先メールアドレスを削除していいですか?',
	'Are you sure you want to delete the [quant,_1,weblog]? When you delete a weblog, all of the entries, comments, templates, notifications, and author permissions are deleted along with the weblog itself. Make sure that this is what you want, because this action is permanent.' => '[quant,_1,個,個]のウェブログを削除していいですか? ウェブログを削除すると、すべてのエントリー、コメント、テンプレート、通知先のアドレス帳、投稿者の権限の情報も一緒に削除されます。削除すると元に戻せませんから、よく確かめてください。',
	# 'Cancel' => '取り消し',
	# 'Delete' => '削除',

	## tmpl/cms/edit_author.tmpl
	'_USAGE_PROFILE' => 'プロフィールを編集します。ユーザ名、パスワードが編集されたときには、ログイン権限は自動的に更新されます。いいかえると、変更後、ログインしなおさなくても大丈夫です。',
	'Your profile has been updated.' => 'プロフィールを変更しました',
	'Username' => 'ユーザ名',
	'Nickname' => 'ニックネーム',
	'Email Address' => 'メールアドレス',
	'Website URL (optional)' => 'あなたのサイトのURL(あれば)',
	'Preferred Language' => '表示する言語',
	'Remote Authentication' => '外部認証',
	'TypeKey site token:' => 'TypeKey トークン',
	'TypeKey username:' => 'TypeKey ユーザ名',
	'Atom authentication token:' => 'Atom API 認証用トークン',
	'Change your password' => 'パスワードの変更',
	'Password' => 'パスワード',
	'Password confirm' => '変更の確認',
	'For Password Recovery' => 'パスワードを回復させるためのキーワード',
	'Birthplace' => '出生地',
	'Save' => '保存',

	## tmpl/cms/edit_blog.tmpl
	'You must set your Local Site Path.' => 'ローカル・サイト・パスを設定してください',
	'You must set your Site URL.' => 'サイトの URL を設定してください',
	'You did not select a timezone.' => '時間帯を選んでください',
	# 'Core Setup' => '基本設定',
	# 'Preferences' => 'ウェブログの設定',
	# 'Archive Files' => 'アーカイブの設定',
	# 'IP Banning' => '禁止IP',
	'Your weblog configuration has been saved.' => 'ウェブログの設定を保存しました',
	'Weblog Name:' => 'ウェブログの名前',
	'Name your weblog. The weblog name can be changed at any time.' => 'ウェブログに名前をつけてください。つけた名前はいつでも変更できます。',
	'Local Site Path:' => 'ローカル・サイト・パス:',
	'Enter the path where your main index file will be located. An absolute path (starting with \'/\') is preferred, but you can also use a path relative to the Movable Type directory.' => 'メインのインデックスファイルを置くパス名を入力してください。絶対パス(「/」で始まる)をお勧めしますが、Movable Type がインストールされた場所からの相対も使えます。',
	# 'Example:' => '例:',
	'Site URL:' => 'サイトのURL:',
	'Enter the URL of your public website. Do not include a filename (i.e. exclude index.html).' => 'このウェブログを公開するウェブの URL を入力してください。ファイル名(index.html など) は入力しないでください。',
	'Local Archive Path:' => 'ローカル・アーカイブ・パス:',
	'Enter the path where your archive files will be located (this can be the same as your Local Site Path).' => 'アーカイブ・ファイルを置く、サーバ上のディレクトリ(ローカル・アーカイブ・パス)を設定してください。(ローカル・サイト・パスと一緒でも大丈夫です)',
	'Archive URL:' => 'アーカイブのURL:',
	'Enter the URL of the archives section of your website.' => 'ウェブサイトでアーカイブ・ファイルにアクセスするためのURLを入力してください',
	'Timezone:' => '時間帯:',
	'Time zone not selected' => '時間帯は選択されていません',
	'UTC+13 (New Zealand Daylight Savings Time)' => 'ニュージーランド・夏時間',
	'UTC+12 (International Date Line East)' => 'UTC+12 (日付変更線の東)',
	'UTC+11' => 'UTC+11',
	'UTC+10 (East Australian Time)' => 'UTC+10 (東オーストラリア)',
	'UTC+9.5 (Central Australian Time)' => 'UTC+9.5 (中央オーストラリア)',
	'UTC+9 (Japan Time)' => 'UTC+9 (日本時間)',
	'UTC+8 (China Coast Time)' => 'UTC+8 (中国海岸部)',
	'UTC+7 (West Australian Time)' => 'UTC+7 (西オーストラリア)',
	'UTC+6.5 (North Sumatra)' => 'UTC+6.5 (北スマトラ)',
	'UTC+6 (Russian Federation Zone 5)' => 'UTC+6 (ロシア連邦ゾーン5)',
	'UTC+5.5 (Indian)' => 'UTC+5.5 (インド)',
	'UTC+5 (Russian Federation Zone 4)' => 'UTC+5 (ロシア連邦ゾーン4)',
	'UTC+4 (Russian Federation Zone 3)' => 'UTC+4 (ロシア連邦ゾーン3)',
	'UTC+3.5 (Iran)' => 'UTC+3.5 (イラン)',
	'UTC+3 (Baghdad Time/Moscow Time)' => 'UTC+3 (バグダッド/モスクワ)',
	'UTC+2 (Eastern Europe Time)' => 'UTC+2 (東ヨーロッパ)',
	'UTC+1 (Central European Time)' => 'UTC+1 (中央ヨーロッパ)',
	'UTC+0 (Universal Time Coordinated)' => 'UTC+0 (世界標準時)',
	'UTC-1 (West Africa Time)' => 'UTC-1 (西アフリカ)',
	'UTC-2 (Azores Time)' => 'UTC-2 (アゾレス諸島)',
	'UTC-3 (Atlantic Time)' => 'UTC-3 (大西洋)',
	'UTC-3.5 (Newfoundland)' => 'UTC-3.5 (ニューファンドランド)',
	'UTC-4 (Atlantic Time)' => 'UTC-4 (大西洋)',
	'UTC-5 (Eastern Time)' => 'UTC-5 (米国東部標準時)',
	'UTC-6 (Central Time)' => 'UTC-6 (米国中部標準時)',
	'UTC-7 (Mountain Time)' => 'UTC-7 (米国山岳部標準時)',
	'UTC-8 (Pacific Time)' => 'UTC-8 (米国太平洋標準時)',
	'UTC-9 (Alaskan Time)' => 'UTC-9 (アラスカ)',
	'UTC-10 (Aleutians-Hawaii Time)' => 'UTC-10 (アリューシャン列島、ハワイ)',
	'UTC-11 (Nome Time)' => 'UTC-11 (ノーム)',
	'Select your timezone from the pulldown menu.' => '時間帯をプルダウンメニューから選んでください',
	# 'Save Changes' => '変更を保存',

	## tmpl/cms/edit_categories.tmpl
	'Categories' => 'カテゴリー',
	'_USAGE_CATEGORIES' => 'エントリーをわかりやすく関連づけたり、アーカイブやウェブログの画面で見やすくするために、カテゴリーを使いましょう。エントリーを作ったり、編集するときに、カテゴリーを設定することができます。すでにあるカテゴリーの名前を変更するには、新しい名前に書き換えて「保存」を押してください。',
	'Your category changes and additions have been made.' => 'カテゴリーの変更と追加を行いました',
	'You have successfully deleted the selected categories.' => 'カテゴリーの削除ができました',
	'Create new top level category' => 'トップレベル・カテゴリーを作成する',
	'Actions' => '操作',
	'Entries' => 'エントリー',
	'TrackBacks' => 'トラックバック',
	# 'Delete' => '削除',
	'Create Category' => 'カテゴリーの作成',
	# 'Cancel' => '取り消し',
	'Top Level' => 'トップレベル',
	'Collapse' => '折りたたむ',
	'Expand' => '展開',
	'Create Subcategory' => 'サブカテゴリーの作成',
	# 'Create' => '作成',
	'Move Category' => 'カテゴリーの移動',
	'Move' => '移動',
	'[quant,_1,entry,entries]' => '[quant,_1,個,個]',
	'[quant,_1,ping]' => '[quant,_1,個,個]',

	## tmpl/cms/edit_category.tmpl
	'Category: [_1]' => 'カテゴリー: [_1]',
	'Use this page to edit the attributes of the category [_1]. You can set a description for your category to be used in your public pages, as well as configuring the TrackBack options for this category.' => 'カテゴリー [_1] の設定を編集できます。サイトに掲載するカテゴリーの説明や、このカテゴリーへのトラックバックの設定ができます。',
	'Your category changes have been made.' => '変更を保存しました',
	'Category Title' => 'カテゴリーのタイトル',
	'Category Description' => 'カテゴリーの説明',
	'TrackBack Settings' => 'トラックバックの設定',
	'Outgoing Pings' => 'トラックバックの発信',
	'TrackBack URLs to ping' => 'トラックバック先URL',
	'Enter the URL(s) of the websites that you would like to ping each time you post an entry in this category. (Separate URLs with a carriage return.)' => 'このカテゴリーにエントリーが追加されたときにトラックバックするURLを入力してください。(複数あるときは、改行で区切ってください)',
	'Incoming Pings' => 'トラックバックの受信',
	'Accept incoming TrackBack pings?' => 'トラックバックを受けつけます',
	'View TrackBack pings for this category' => 'このカテゴリーへのトラックバックを確認する',
	'On' => 'On',
	'Off' => 'Off',
	'Passphrase Protection (Optional)' => 'パスフレーズを利用する(オプション)',
	'TrackBack URL for this category' => 'このカテゴリーのトラックバックURL',
	'This is the URL that others will use to ping your weblog. If you wish for anyone to ping your weblog when they have a post specific to this category, post this URL publicly. If you choose to only allow a select group of individuals to ping, send this URL to them privately.' => 'これは、他のサイトからこのサイトへトラックバックするためのURLです。このカテゴリーへのトラックバックを受けつけるのなら、このURLをサイトで公開してください。限られた人にだけトラックバックを許可したいなら、このURLは、その人たちだけにこっそり教えてください',
	'To include a list of incoming pings in your Main Index Template, look here for sample code:' => '受け付けたトラックバックのリストをメイン・インデックスのテンプレートで利用したいときは、サンプルコードを参照してください: ',
	# 'Save' => '保存',

	## tmpl/cms/edit_comment.tmpl
	'Add a new comment' => '新しくコメントを追加する',
	'Your changes have been saved.' => '変更を保存しました。',
	'Pending Approval' => '保留',
	'Post title:' => 'タイトル',
	'Entry no longer exists' => 'エントりーはすでにありません',
	'No title' => 'タイトルがありません',
	'View all comments on this entry' => 'このエントリーへのコメントをすべて見る',
	'Author:' => '投稿者:',
	'Approved' => '承諾済',
	'(this author is approved)' => '(このコメンターは許可されています)',
	'Ban&nbsp;User' => '停止',
	'Blocked' => 'ブロック',
	'(this author is banned from commenting)' => '(このコメンターはコメントを禁止されています)',
	'Approve&nbsp;User' => '承認',
	'Pending' => '保留',
	'(this author needs to be approved)' => '(このコメンターは許可なくコメントできせん)',
	'Approve' => '掲載許可',
	'Reject' => '掲載不可',
	'View all comments by this person' => 'この人のコメントをすべて見る',
	# 'IP Address:' => 'IPアドレス',
	'View all comments from this IP address' => 'この IP アドレスからのコメントをすべて見る',
	'URL:' => 'URL:',
	'Email:' => 'メールアドレス:',
	'View all comments from this email address' => 'このメールアドレスからのコメントをすべて見る',
	'Comment:' => 'コメント:',
	# 'Delete' => '削除',
	# 'Save' => '保存',

	## tmpl/cms/edit_entry.tmpl
	'Add new category...' => '新しいカテゴリーを追加...',
	'Create New Entry' => 'エントリーの投稿',
	'Edit Entry' => 'エントリーの編集',
	'Your entry has been saved. You can now make any changes to the entry itself, edit the authored-on date, edit comments, or send a notification.' => 'エントリーを保存しました。エントリーの変更、作成日、コメントの編集、通知の送信ができます',
	# 'Your changes have been saved.' => '変更を保存しました。',
	'One or more errors occurred when sending update or TrackBack pings.' => 'トラックバックか、アップデート情報の送信でエラーがありました',
	'_USAGE_VIEW_LOG' => 'エラーのときは<a href="#" onclick="doViewLog()">ログ</a>をチェックしてください',
	'Your customization preferences have been saved, and are visible in the form below.' => 'カスタマイズの設定を変更しました。下のフォームを確認してください。',
	'Your changes to the comment have been saved.' => 'コメントの変更を保存しました',
	'Your notification has been sent.' => '通知を送りました',
	'You have successfully deleted the checked comment(s).' => 'チェックしたコメントは削除しました',
	'You have successfully deleted the checked TrackBack ping(s).' => 'チェックしたトラックバックは削除しました',
	'Previous' => '前のエントリー',
	'List &amp; Edit Entries' => 'エントリーのリストと編集',
	'Next' => '次のエントリー',
	'View Entry' => 'エントリーの確認',
	'Preview' => '確認',
	# 'Save' => '保存',
	'Delete Entry' => 'エントリーを削除',
	# 'Title' => 'タイトル',
	# 'Post Status' => '投稿の状態',
	# 'Draft' => '下書き',
	# 'Publish' => '公開',
	# 'Future' => '指定日',
	# 'Primary Category' => '主カテゴリー',
	'Assign Multiple Categories' => '複数のカテゴリーを設定する',
	# 'Bold' => '太字',
	# 'Italic' => 'イタリック',
	# 'Underline' => 'アンダーライン',
	# 'Insert Link' => 'ハイパーリンク',
	# 'Entry Body' => 'エントリーの内容(body)',
	# 'Extended Entry' => '追記(extend)',
	# 'Excerpt' => '概要(excerpt)',
	# 'Keywords' => 'キーワード',
	'Authored On' => '作成日時',
	'Comments' => 'コメント',
	# 'None' => 'なし',
	# 'Open' => 'オープン',
	# 'Closed' => 'クローズ',
	# 'Text Formatting' => 'テキストフォーマット',
	'Accept TrackBack Pings' => 'トラックバックを受けつける',
	'URLs to Ping' => 'トラックバック先のURL',
	'View Previously Sent Pings' => 'これまでに送ったトラックバックを見る',
	'Customize the display of this page.' => 'この画面の表示をカスタマイズする',
	'Manage Comments' => 'コメントの管理',
	'Click on the author\'s name to edit the comment. To delete a comment, check the box to its right and then click the Delete button.' => 'コメントを編集するには、コメンターの名前をクリックしてください。削除するには、右のボックスにチェックを入れて「削除」を押してください。',
	'Author' => '投稿者',
	# 'Date Added' => '作成日',
	# 'Delete' => '削除',
	'Manage TrackBack Pings' => 'トラックバックの設定',
	'Click on the ping title to view the page. To delete a ping, check the box to its right and then click the Delete button.' => 'トラックバックのタイトルをクリックすると、そのページを確認できます。削除するには、右のボックスにチェックを入れて「削除」を押してください。',
	'Send a Notification' => 'おしらせを送信する',
	'You can send a notification message to your group of readers. Just enter the email message that you would like to insert below the weblog entry\'s link. You have the option of including the excerpt indicated above or the entry in its entirety.' => '読者にお知らせを送ることができます。エントリーへのリンクの下に添えるメールの文章を入力してください。概要やエントリーの本文を送るように設定することもできます。',
	'Include excerpt' => '概要も送る',
	'Include entire entry body' => '本文も送る',
	'Note: If you chose to send the weblog entry, all added HTML will be included in the email.' => '注意: エントリーの本文を送ると、中に書かれているHTMLコードも一緒に送信されてしまいます',
	'Send' => '送信',

	## tmpl/cms/edit_permissions.tmpl
	'_USAGE_PERMISSIONS_1' => '<b>[_1]</b> の権限を変更します。編集権限のあるウェブログのリストのそれぞれのウェブログについて <b>[_1]</b> にアクセス権限を与えたいボックスにチェックを入れてください。',
	'_USAGE_PERMISSIONS_2' => '他のユーザの権限を編集するには、プルダウンメニューでユーザを選んで、「編集」を押してください。',
	'Your changes to [_1]\'s permissions have been saved. You can select another author to edit or return to the main Author menu.' => '[_1]さんの権限が保存されました。続けて設定するなら、他のユーザーを選んでください。',
	'[_1] has been successfully added to [_2].' => '[_1] をウェブログ: [_2] の投稿者として追加しました',
	'_USAGE_PERMISSIONS_3' => '投稿者を編集して、アクセス権限を追加/削除するには、二つの方法があります。簡単に編集するには、ユーザをメニューから選んで「編集」を押します。もう一つは、投稿者全員のリストから選んで、編集、または削除する方法です。',
	'Select an author to edit:' => '編集する投稿者を選んでください',
	'Edit' => '編集',
	'View complete list of authors' => '投稿者全員のリストを見る',
	'Delete, view, and edit authors via a complete list of authors in the system.' => 'システム全体の投稿者全員のリストを見て、編集や削除ができます',
	'General Permissions' => 'システム全体の権限',
	'User can create new weblogs' => '新しいウェブログの作成を許可する',
	'User can view activity log' => 'システムログを見ることを許可する',
	'Weblog:' => 'ウェブログ:',
	# 'Save' => '保存',
	'Add user to an additional weblog:' => '別のウェブログに登録する',
	# 'Select a weblog' => 'ウェブログを選択',
	# 'Add' => '追加',
	'Add an author' => '投稿者の追加',
	'_USAGE_PERMISSIONS_4' => 'それぞれのウェブログには、複数の投稿者を割りあてることができます。投稿者を追加するには、下のフォームから、ユーザ情報を選んでください。それから追加したいウェブログを選びます。保存を押すと、そのユーザの編集権限を編集できます。',
	# 'Username' => 'ユーザ名',
	# 'Email Address' => 'メールアドレス',
	# 'Website URL (optional)' => 'あなたのサイトのURL(あれば)',
	# 'Password' => 'パスワード',
	# 'Password confirm' => '変更の確認',
	'This user will be associated with:' => 'このユーザ',

	## tmpl/cms/edit_placements.tmpl
	'_USAGE_PLACEMENTS' => 'エントリーに副カテゴリーを設定できます。リストの左側は、エントリーに主/副どちらとも設定されていないカテゴリー、右側は副として設定されているカテゴリーです。',
	'The secondary categories for this entry have been updated. You will need to SAVE the entry for these changes to be reflected on your public site.' => '副カテゴリーを更新しました。サイトへ変更を反映させるには、エントリーを保存してください',
	'Categories in your weblog:' => 'ウェブログのカテゴリー:',
	'Secondary categories:' => '副カテゴリー:',
	# 'Close' => '閉じる',
	# 'Save' => '保存',

	## tmpl/cms/edit_template.tmpl
	'Edit Template' => 'テンプレートの編集',
	'Your template changes have been saved.' => '変更したテンプレートを保存しました。',
	'Rebuild this template' => 'このテンプレートを再構築する',
	'Template Name' => 'テンプレートの名前',
	'Comment Listing Template' => 'コメント・リストのテンプレート',
	'Comment Preview Template' => 'コメント・プレビューのテンプレート',
	'Comment Error Template' => 'コメント・エラーのテンプレート',
	'Comment Pending Template' => 'コメント・保留のテンプレート',
	'Commenter Registration Template' => 'コメンター・レジストレーションのテンプレート',
	'TrackBack Listing Template' => 'トラックバック・リストのテンプレート',
	'Uploaded Image Popup Template' => '画像のポップアップウィンドウのテンプレート',
	'Dynamic Pages Error Template' => 'ダイナミック・ページのエラー・テンプレート',
	'Output File' => '出力ファイル名',
	'Link this template to a file' => 'このテンプレートにリンクするファイル',
	'Build Options' => '再構築オプション',
	'Enable dynamic building for this template' => 'このテンプレートをダイナミック・ページにする',
	'Rebuild this template automatically when rebuilding index templates' => 'インデックス・テンプレートを再構築するときにこのテンプレートを自動的に再構築する',
	'Module Body' => 'モジュールの中身',
	'Template Body' => 'テンプレートの中身',
	# 'Save' => '保存',
	'Rebuild' => '再構築',

	## tmpl/cms/entry_prefs.tmpl
	'Your entry screen preferences have been saved.' => 'エントリーの入力画面の設定を保存しました',
	'Field Configuration' => '画面の設定',
	'_USAGE_ENTRYPREFS' => 'エントリーの編集画面に表示されるフィールドの設定を行います。標準的な設定(Basic か Advanced)、もしくは自分で必要なフィールドを設定できるCustom を選択してください。',
	'(Help?)' => '(ヘルプ?)',
	'Basic' => 'Basic',
	'Advanced' => 'Advanced',
	'Custom: show the following fields:' => 'カスタム: 以下のフィールドを表示する',
	# 'Category' => 'カテゴリー',
	# 'Extended Entry' => '追記(extend)',
	# 'Excerpt' => '概要(excerpt)',
	# 'Keywords' => 'キーワード',
	# 'Allow Comments' => 'コメントを受けいれる',
	# 'Text Formatting' => 'テキストフォーマット',
	# 'Allow Pings' => 'トラックバックを受けいれる',
	'Editable Authored On Date' => '日付の編集',
	# 'URLs to Ping' => 'トラックバック先のURL',
	'Button Bar Position' => 'ボタンの表示場所',
	'Top of the page' => 'ページの上',
	'Bottom of the page' => 'ページの下',
	# 'Cancel' => '取り消し',
	# 'Save' => '保存',

	## tmpl/cms/error.tmpl
	'An error occurred:' => 'エラーが発生しました:',
	# 'Close' => '閉じる',
	'Go Back' => '戻る',

	## tmpl/cms/footer-popup.tmpl

	## tmpl/cms/footer.tmpl

	## tmpl/cms/header-popup.tmpl
	'Movable Type Publishing Platform' => 'Movable Type Publishing Platform',

	## tmpl/cms/header.tmpl
	# 'Movable Type Publishing Platform' => 'Movable Type Publishing Platform',
	'Main Menu' => 'メインメニュー',
	'Help' => 'ヘルプ',
	'Logout' => 'ログアウト',
	'View&nbsp;Site' => 'サイトの確認',
	'User:' => 'ユーザ:',
	'Search' => '検索',
	'Go' => 'Go',
	# 'Post' => '投稿',
	# 'Create New Entry' => 'エントリーの投稿',
	'New Entry' => '新しいエントリー',
	'List Entries' => 'エントリーの一覧',
	# 'Entries' => 'エントリー',
	'Upload File' => 'アップロード',
	'List Comments' => 'コメントの一覧',
	# 'Comments' => 'コメント',
	'List TrackBack Pings' => 'トラックバックの一覧',
	# 'TrackBacks' => 'トラックバック',
	'Manage' => '管理',
	'List &amp; Edit Templates' => 'テンプレートの編集',
	'Templates' => 'テンプレート',
	'Edit Categories' => 'カテゴリーの編集',
	# 'Categories' => 'カテゴリー',
	'Edit Notification List' => '通知リストの編集',
	'Notifications' => '通知',
	'Manage Comment Authors' => 'コメンターの管理',
	'Commenters' => 'コメンター',
	'Edit Weblog Configuration' => 'ウェブログの設定',
	'Weblog Config' => 'ウェブログの設定',
	'Utilities' => 'ユーティリティー',
	'Search &amp; Replace' => '検索と置換',
	'Import &amp; Export Entries' => 'エントリーの書き出し・読み込み',
	'Import / Export' => '読み込み/書き出し',
	'Rebuild Site' => 'サイトの再構築',
	'View Site' => 'サイトの確認',

	## tmpl/cms/import.tmpl
	# 'Import &amp; Export Entries' => 'エントリーの書き出し・読み込み',
	'Import Entries' => 'エントリーの読み込み',
	'_USAGE_IMPORT' => '他のウェブログ・コンテンツ・マネージメント・システム (Blogger, Greymatter など) からエンリーを読み込むために、「エントリーの読み込み」を使います。この仕組みを使った読み込みの方法は、マニュアルでわかりやすく説明しています。下のフォームを利用して、他のコンテンツ・マネージメント・システムで書き出したエントリーを読み込みできます。書き出したファイルをマニュアルに記載されている正しい場所に置くと、Movable Type は自動的に見つけて読み込み処理をします。このフォームを利用する前に、マニュアルを良く読んで、全てのオプションが正しいか確認してください。',
	'Import entries as me' => 'エントリーの投稿者を自分にする',
	'Password (required if creating new authors):' => 'パスワード(新しい投稿者を作るなら必要)',
	'Default category for entries (optional):' => 'デフォルトのカテゴリー(必要なら)',
	'Select a category' => 'Category を選ぶ',
	'Default post status for entries (optional):' => 'デフォルトの投稿の状態(必要なら)',
	'Select a post status' => '投稿の状態を選ぶ',
	# 'Draft' => '下書き',
	# 'Publish' => '公開',
	'Start title HTML (optional):' => '最初のタイトル HTML (必要なら)',
	'End title HTML (optional):' => '最後のタイトル HTML (必要なら）',
	'Export Entries' => 'エントリーを書き出す',
	'_USAGE_EXPORT_1' => 'Movable Type から書き出すと、自分のエントリーの <b>個人的なバックアップ</b> を安全のために作ることができます。書き出されるデータのフォーマットは、Movable Type で読み込みしやすいものになっています。また、バックアップに加えて、この仕組みは、<b>あなたのコンテンツを新しいウェブログに移す</b> ときにも利用できます。',
	'_USAGE_EXPORT_2' => 'エントリーを書き出すには、下のリンク ("Export Entries From [_1]") をクリックしてください。書き出したデータをファイルに保存するためには、Mac の場合は <code>option</code> キー、WIndwos の場合は <code>Shift<//code> を押しながら、リンクをクリックしてください。表示されたデータをコピー、ペーストしてもいいです。(<a href="#" onclick="openManual(\'export_ie\')">Internet Explorer を使っての書き出しについて?</a>)',
	'Export Entries From [_1]' => '[_1] からエントリーを書き出す',
	'Export Entries to Tangent' => 'Tangent にエントリーを書き出す',
	'_USAGE_EXPORT_3' => 'このリンクをクリックすると、Tangentサーバにこのウェブログのエントリーをすべて書き出せます。Movable Type にTangent Add-onをインストールしていれば、一回押すだけでエントリーを移すことができ、必要なときにいつでも実行可能です。',

	## tmpl/cms/list_author.tmpl
	'Weblog Authors' => 'ウェブログの投稿者',
	'_USAGE_AUTHORS' => 'MovableTypeの投稿者全員のリストです。名前をクリックすると、それぞれの投稿者の権限を編集できます。<b>削除</b>にチェックしてから「削除」を押すと完全にユーザを削除できます。特定のウェブログからユーザを外したいのであれば、投稿者の権限を編集して、権限をすべて外してください。「削除」を使うと投稿者がシステムから完全に削除されてしまいます。',
	'You have successfully deleted the authors from the Movable Type system.' => '投稿者を Movable Type のシステムから削除しました',
	# 'Username' => 'ユーザ名',
	# 'Email Address' => 'メールアドレス',
	'Created By' => '作成者:',
	# 'Delete' => '削除',

	## tmpl/cms/list_blog.tmpl
	'Movable Type News' => 'Movable Type ニュース',
	'More news about ' => '続きはこちら:',
	'Shortcuts' => 'ショートカット',
	'Create new Weblog' => '新しいウェブログの作成',
	'Set up a new weblog' => '新しいウェブログを作成',
	'Add/Edit Weblog authors' => 'ウェブログの投稿者を追加、編集',
	'Add authors, set permissions' => '投稿者の追加、権限の設定',
	'Edit your profile' => 'プロフィールの編集',
	'Change password, contact info, select language' => 'パスワード、アドレスの変更、言語の選択',
	'View Activity Log' => 'Movable Type のログの確認',
	'System activity, logins' => 'システムの状態やログイン履歴の確認',
	'Set up QuickPost' => 'クイックポストの作成',
	'QuickPost enables one-click publishing' => 'クイックポストでワン・クリック投稿',
	'Movable Type System Stats' => 'Movable Type システムの状態',
	'Total Blogs:' => 'ウェブログ:',
	'Total Authors:' => '投稿者:',
	'Your selected weblog has been deleted.' => '指定したウェブログを削除しました',
	'Maintain Your Existing Weblogs' => 'ウェブログの管理',
	'Total Posts:' => 'エントリー:',
	'Total Comments:' => 'コメント:',
	# 'URL:' => 'URL:',
	'Create Entry' => 'エントリーの投稿',
	# 'Entries' => 'エントリー',
	# 'Comments' => 'コメント',
	# 'Templates' => 'テンプレート',
	'Configuration' => '設定',
	'Delete Weblog' => 'ウェブログの削除',
	'Configure Active Plugins' => '利用可能なプラグインの設定',
	'Documentation' => 'ドキュメント',

	## tmpl/cms/list_comment.tmpl
	'List &amp; Edit Comments' => 'コメントの一覧と編集',
	'_USAGE_COMMENTS_LIST' => '[_1] のコメント一覧です。コメントの本文をクリックすると編集できます。フィルターを変更するには、それぞれの項目をクリックしてください。',
	# 'Your changes have been saved.' => '変更を保存しました。',
	'The selected comment(s) has been deleted from the database.' => 'コメントをデータベースから削除しました。',
	'Filter Options' => 'フィルタ・オプション',
	'Show comments where' => 'コメントフィルタ: ',
	'Email' => 'メールアドレス',
	'Name' => '名前',
	# 'IP Address' => 'IPアドレス',
	'is' => 'が',
	'Filter' => 'フィルタ',
	'Currently showing comments where' => '現在表示中のコメント: ',
	'Reset Filter' => 'フィルタをリセット',
	'Status' => '投稿の状態',
	'Commenter' => 'コメンター',
	'Comment' => 'コメント',
	'Entry' => 'エントリー',
	'Date' => '日付',
	'IP' => 'IP アドレス',
	# 'Delete' => '削除',
	# 'Approved' => '承諾済',
	'Banned' => '停止中',
	# 'Pending' => '保留',
	'View all comments from this registered commenter' => 'このコメンターからのコメントをすべて表示',
	'Registered Commenter' => '登録されているコメンター',
	'Ban this user from commenting' => 'このユーザからのコメントを停止',
	'Ban User' => '停止する',
	'Approve comments from this user' => 'このユーザからのコメントを受けつける',
	'Approve User' => 'コメンターを承認する',
	'View all comments from this unregistered commenter' => 'この未登録のコメンターからのコメントをすべて表示する',
	'Anonymous' => '匿名',
	'Unregistered Commenter' => '未登録のコメンター',
	'Approve this comment' => 'このコメントを掲載する',
	'Approve Comment' => 'コメントを掲載する',
	# 'View all comments on this entry' => 'このエントリーへのコメントをすべて見る',
	# 'View all comments from this IP address' => 'この IP アドレスからのコメントをすべて見る',
	'Mark all comments from this IP address as spam' => 'このIPアドレスからのコメントをすべてスパムにする',
	'Mark as Spam' => 'スパム',
	'Ban This IP' => 'このIPアドレスを禁止する',
	'Check All' => 'すべてチェックする',
	'Uncheck All' => 'すべてチェックを外す',
	'Previous [_1]' => '前の[_1]',
	'[quant,_1,comment,comments]' => '[_1]個のコメント',
	'all comments' => 'すべてのコメント',
	'Next [_1]' => '次の[_1]',

	## tmpl/cms/list_commenters.tmpl
	'Registered Commenters' => '登録されているコメンター',
	# 'Status' => '投稿の状態',
	# 'Commenter' => 'コメンター',
	'Identity' => 'ID',
	# 'Actions' => '操作',
	# 'Approved' => '承諾済',
	# 'Banned' => '停止中',
	# 'Pending' => '保留',
	'View all comments from this registered commenter' => 'このコメンターからのコメントをすべて見る',
	'View Profile' => 'プロフィールを見る',
	'Ban comments from this user' => 'このユーザからのコメントを禁止する',
	# 'Ban User' => '停止する',
	'Approve comments from this user' => 'このユーザからのコメントを受けつける',
	# 'Approve User' => 'コメンターを登録する',
	# 'Previous [_1]' => '前の[_1]',
	'[quant,_1,commenter,commenters]' => '[_1] 個のコメント',
	# 'Next [_1]' => '次の[_1]',

	## tmpl/cms/list_entry.tmpl
	# 'List &amp; Edit Entries' => 'エントリーのリストと編集',
	# 'Draft' => '下書き',
	# 'Publish' => '公開',
	'Future' => '指定日',
	# 'Select' => '選択',
	'_USAGE_LIST_POWER' => '[_1] のエントリーの一括編集画面です。下のフォームを使うと、画面に表示されているどのエントリーの設定でも変更できます。変更が終わったら、「保存」を押してください。通常のエントリー編集画面と同様に、フィルタや一画面に表示されるエントリー数を設定することもできます。',
	'_USAGE_LIST' => '[_1] のエントリーのリストです。エントリーのタイトルをクリックすると編集できます。エントリーのフィルタは、最初のプルダウンメニューで、カテゴリー、投稿者、投稿の状態を選んでから、次のプルダウンメニューを選んでください。画面右下のプルダウンを使うと一度に表示されるエントリーの数を設定できます。',
	'Open power-editing mode' => '一括編集モード',
	# 'Your changes have been saved.' => '変更を保存しました。',
	'Your entry has been deleted from the database.' => 'エントリーをデータベースから削除しました',
	'Filter Options' => 'フィルタ・オプション',
	'Show entries where' => '以下の条件のエントリーを表示:',
	# 'Category' => 'カテゴリー',
	# 'Author' => '投稿者',
	# 'Post Status' => '投稿の状態',
	# 'is' => 'が',
	# 'Filter' => 'フィルター',
	'or' => 'か',
	# 'Reset Filter' => 'フィルタをリセット',
	# 'Title' => 'タイトル',
	# 'Date' => '日付',
	# 'Status' => '投稿の状態',
	# 'Delete' => '削除',
	# 'None' => 'なし',
	# 'Save' => '保存',
	# 'Check All' => 'すべてチェックする',
	# 'Uncheck All' => 'すべてチェックを外す',
	# 'Previous [_1]' => '前の[_1]',
	# '[quant,_1,entry,entries]' => '[quant,_1,個,個]のエントリー',
	'all entries' => '全てのエントリー',
	# 'Next [_1]' => '次の[_1]',

	## tmpl/cms/list_notification.tmpl
	'Notification List' => '通知リスト',
	'You have added [_1] to your notification list.' => '[_1] を通知リストに追加しました',
	'You have successfully deleted the selected notifications from your notification list.' => '選んだ通知先をリストから削除しました',
	'Add an Email Address' => 'メールアドレスの追加',
	'To add a new address to your notification list, enter the email address in the form below. The URL field is optional. Then press the Add button.' => 'メールアドレスを入力して「追加」を押すと、通知リストに追加できます。URLは入力しなくてもかまいません。',
	'Email Address:' => 'メールアドレス',
	'URL (Optional):' => 'URL (あれば)',
	# 'Add' => '追加',
	'Below is the list of people who wish to be notified when you post to your site. To delete an address, check the Delete box and press the Delete button.' => '通知希望者のリストです。削除するには、チェックを入れて「削除」を押してください。',
	'You have [quant,_1,user,users,no users] in your notification list.' => 'リストには [quant,_1,人設定されています,人設定されています,一人も設定されていません]。',
	# 'Email Address' => 'メールアドレス',
	'URL' => 'URL',
	# 'Date Added' => '作成日',
	# 'Delete' => '削除',

	## tmpl/cms/list_ping.tmpl
	'TrackBack Pings' => 'トラックバック',
	'_USAGE_PING_LIST' => '[_1] のトラックバック一覧です。',
	# 'Your changes have been saved.' => '変更を保存しました。',
	# 'Your entry has been deleted from the database.' => 'エントリーをデータベースから削除しました',
	'Filter Options' => 'フィルタ・オプション',
	'Show pings where' => '以下の条件のトラックバックを表示:',
	# 'Title' => 'タイトル',
	'Source' => '送信元',
	# 'Excerpt' => '概要(excerpt)',
	# 'is' => 'が',
	'Currently showing pings where' => '現在表示中のトラックバック: ',
	# 'Reset Filter' => 'フィルタをリセット',
	# 'Date' => '日付',
	# 'Delete' => '削除',
	# 'Ban This IP' => 'このIPアドレスを禁止する',
	# 'Check All' => 'すべてチェックする',
	# 'Uncheck All' => 'すべてチェックを外す',
	# 'Previous [_1]' => '前の[_1]',
	# '[quant,_1,ping]' => 'トラックバック数: [_1] ',
	'all pings' => 'すべてのトラックバック',
	# 'Next [_1]' => '次の[_1]',

	## tmpl/cms/list_template.tmpl
	'You did not select any templates to delete.' => '削除するテンプレートを選んでください',
	# 'Templates' => 'テンプレート',
	'You have successfully deleted the checked template(s).' => '選択したテンプレートを削除しました。',
	'_USAGE_TEMPLATES' => 'サイトのデザインやレイアウトに使われているテンプレートのリストです。このページからテンプレートを編集することができます。また、新しいインデックス・テンプレートを作ったり、すでにあるテンプレートを削除することもできます。',
	'Templates can be built statically (a manual or semi-automatic process) or dynamically whenever a page is requested (a fully-automatic process). There are some benefits and drawbacks to either option.' => 'テンプレートは通常のスタティック(手動、もしくは半自動的に作成されます)か、ページを表示するたびに作成するダイナミック(自動)から選べます。どちらにも長所と短所があります。',
	'Build Options' => '再構築オプション',
	'Build All Templates Statically' => 'すべてスタティック',
	'Build Only Archive Templates Dynamically' => 'アーカイブのみダイナミック',
	'Set Each Template\'s Build Options Separately' => 'テンプレート毎に個別に選択',
	# 'Save' => '保存',
	'Index Templates' => 'インデックス・テンプレート',
	'Create new index template' => '新しいインデックス・テンプレートを作る',
	# 'Template Name' => 'テンプレートの名前',
	# 'Output File' => '出力ファイル名',
	'Build w/Indexes' => 'インデックスと一緒に再構築',
	# 'Delete' => '削除',
	'Yes' => 'はい',
	'No' => 'いいえ',
	'Archive-Related Templates' => 'アーカイブに関連したテンプレート',
	'Create new archive template' => '新しいアーカイブ・テンプレートを作る',
	'Edit Archive File Options' => 'アーカイブ・ファイルのオプションを編集',
	'Special Templates' => '特別なテンプレート',
	# 'Comment Listing Template' => 'コメント・リストのテンプレート',
	# 'Comment Preview Template' => 'コメント・プレビューのテンプレート',
	# 'Comment Error Template' => 'コメント・エラーのテンプレート',
	# 'Comment Pending Template' => 'コメント・保留のテンプレート',
	# 'TrackBack Listing Template' => 'トラックバック・リストのテンプレート',
	# 'Uploaded Image Popup Template' => '画像のポップアップウィンドウのテンプレート',
	'Dynamic Pages Error Template' => 'ダイナミックページ・エラー表示テンプレート',
	'Template Modules' => 'テンプレート・モジュール',
	'Create new template module' => '新しいテンプレート・モジュールを作る',

	## tmpl/cms/login.tmpl
	'Your Movable Type session has ended. If you wish to log in again, you can do so below.' => 'Movable Type からログアウトしました。ログインしたいときには、この画面からログインしてください',
	# 'Username' => 'ユーザ名',
	# 'Password' => 'パスワード',
	'Remember me?' => '情報を登録する?',
	'Log In' => 'ログイン',
	'Forgot your password?' => 'パスワードを忘れたときは...',

	## tmpl/cms/menu.tmpl
	'Five Most Recent Entries' => '最近のエントリー',
	'View all Entries' => 'すべてのエントリーを表示',
	'Five Most Recent Comments' => '最近のコメント',
	'Anonymous' => '匿名',
	'View all Comments' => 'すべてのコメントを表示',
	'Five Most Recent TrackBacks' => '最新5件のトラックバック',
	'View all TrackBacks' => 'すべてのトラックバックを表示',
	'Welcome to [_1].' => '[_1] へようこそ',
	'You can post and maintain your weblog by selecting an option from the menu located to the left of this message.' => '左側のメニューからウェブログに投稿したり、管理することができます',
	'If you need assistance, try:' => 'わからなくなったときは、次のリンクを参照してください。',
	'Movable Type User Manual' => 'Movable Type のユーザマニュアル',
	'Movable Type Support Forum' => 'Movable Type のサポートフォーラム',
	'This welcome message is configurable.' => 'このメッセージは変更できます',
	'Change this message.' => 'このメッセージを変更する',
	'Plugin actions' => 'ブラグイン',

	## tmpl/cms/pending_commenter.tmpl

	## tmpl/cms/pinged_urls.tmpl
	'Here is a list of the previous TrackBack pings that were successfully sent:' => '送信できたトラックバックの一覧',
	# 'Close' => '閉じる',

	## tmpl/cms/pinging.tmpl
	'Pinging sites...' => 'トラックバック/アップデートping中...',

	## tmpl/cms/preview_entry.tmpl
	'Re-Edit this entry' => '編集画面に戻る',
	'Save this entry' => 'このエントリーを保存する',

	## tmpl/cms/rebuild-stub.tmpl
	'To see the changes reflected on your public site, you should rebuild your site now.' => 'すぐにサイトに変更を反映するためには、再構築してください。',
	'Rebuild my site' => 'サイトの再構築',

	## tmpl/cms/rebuild_confirm.tmpl
	'Rebuilding [_1]' => '[_1] を再構築中',
	'Select the type of rebuild you would like to perform. (Click the Cancel button if you do not want to rebuild any files.)' => '再構築するものを選択してください。「キャンセル」を押すとなにもしません。',
	'Rebuild All Files' => 'すべてを再構築する',
	'Index Template: [_1]' => 'インデックス: [_1]',
	'Rebuild Indexes Only' => 'インデックスだけ',
	'Rebuild [_1] Archives Only' => '[_1] アーカイブだけ',
	# 'Cancel' => '取り消し',
	# 'Rebuild' => '再構築',

	## tmpl/cms/rebuilding.tmpl
	# 'Rebuilding [_1]' => '[_1] を再構築中',
	'Rebuilding [_1] pages [_2]' => '[_1] ページの [_2] まで再構築中',
	'Rebuilding [_1] pages' => '[_1] ページを再構築中',

	## tmpl/cms/rebuilt.tmpl
	'All of your files have been rebuilt.' => 'すべて再構築できました',
	'Your [_1] has been rebuilt.' => '[_1] を再構築しました',
	'Your [_1] pages have been rebuilt.' => '[_1] ページを再構築しました',
	# 'View your site' => 'サイトの確認',
	'View this page' => 'できたページを見る',
	# 'Close' => '閉じる',
	'Rebuild Again' => 'もう一度再構築する',

	## tmpl/cms/recover.tmpl
	'Your password has been changed, and the new password has been sent to your email address ([_1]).' => 'パスワードを変更しました。新しいパスワードは、メールで送りました。([_1])',
	# 'Close' => '閉じる',
	'Enter your Movable Type username:' => 'Movable Type のユーザ名を入力してください。',
	'Enter your birthplace:' => '出生地を入力してください',
	# 'Cancel' => '取り消し',
	'Recover' => 'パスワードを再設定',

	## tmpl/cms/reload_opener.tmpl

	## tmpl/cms/search_replace.tmpl
	# 'Search &amp; Replace' => '検索と置換',
	'_USAGE_SEARCH' => 'エントリーの検索、置換ツールを使って、エントリー全体を検索したり、言葉を置き換えたりすることができます。<b>重要</b>: 置換するときは注意して使ってください。なぜなら、<b>やりなおしできない</b>からです。置換する前に、エントリーの書き出し機能を使ってバックアップしたほうがいいでしょう。',
	'Search for:' => '検索: ',
	# 'Search' => '検索',
	'Case Sensitive' => '大文字/小文字を区別する',
	'Regular Expression Match' => '正規表現で検索',
	'Search fields:' => '探すフィールド:',
	# 'Title' => 'タイトル',
	# 'Entry Body' => 'エントリーの内容(body)',
	# 'Extended Entry' => '追記(extend)',
	# 'Keywords' => 'キーワード',
	'Replace with:' => '置換: ',
	'Replace' => '置換',
	'Search Results' => '検索の結果',
	'The following entries match the search string [_1]' => '[_1]の検索結果のエントリー',
	'; that search string has been replaced by [_1]' => '; [_1] に置換されました。',
	# 'Authored On' => '作成日時',

	## tmpl/cms/show_upload_html.tmpl
	'Copy and paste this HTML into your entry.' => 'このHTMLをコピー&amp;ペーストしてエントリーに貼りつけてください',
	# 'Close' => '閉じる',
	'Upload Another' => '他のイメージをアップロードする',

	## tmpl/cms/spam_confirm.tmpl
	'Are you sure you want to ban the IP address [_1] and delete delete the [quant,_2,comment] received from that address?' => 'IP アドレス [_1] を禁止して、このIPアドレスからの [_2] 個のコメントを削除していいですか?',
	# 'Cancel' => '取り消し',
	# 'Delete' => '削除',

	## tmpl/cms/tb_cat_pings.tmpl
	'Click on the title to view the corresponding entry on the original site. To delete a ping, check the box to the right, then click the Delete Checked button.' => '元のサイトの対応するタイトルをクリックしてください。トラックバックを削除するには、右側の箱にチェックを入れて「削除」を押してください。',
	'You have successfully deleted the checked TrackBack pings from this category.' => 'チェックされたトラックバックを削除しました。',
	# 'Title' => 'タイトル',
	# 'Date Added' => '作成日',
	# 'IP Address' => 'IPアドレス',
	# 'Delete' => '削除',
	# 'Close' => '閉じる',
	'Delete Checked' => 'チェックしたものを削除',

	## tmpl/cms/upload.tmpl
	'Choose A File' => 'ファイルを選んでください',
	'To upload a file to your server, click on the browse button to locate the file on your hard drive.' => 'ファイルをアップロードするには、「参照」ボタンを押して、ファイルを指定してください。',
	'File:' => 'ファイル: ',
	'Choose A Destination' => 'アップロード先を選んでください',
	'_USAGE_UPLOAD' => 'サーバのディレクトリ<a href="javascript:alert(\'[_1]\')">(?)</a>、もしくはサーバのアーカイブディレクトリ<a href="javascript:alert(\'[_1]\')">(?)</a> にファイルをアップロードすることができます。右側のフォームに書き足せば、それぞれのディレクトリの下に置くこともできます (例えば <i>images</i> )。もし、そのディレクトリがなかったら、自動的に作られます。',
	'Upload Into:' => 'アップロード先:',
	'(Optional)' => '(追加で)',
	'Local Archive Path' => 'ローカル・アーカイブ・パス',
	'Local Site Path' => 'ローカル・サイト・パス',
	# 'Cancel' => '取り消し',
	'Upload' => 'アップロード',

	## tmpl/cms/upload_complete.tmpl
	'Your file has been uploaded. Size: [quant,_1,byte].' => 'ファイルをアップロードしました。(サイズ: [quant,_1,byte]) ',
	'Create a new entry using this uploaded file' => 'アップロードしたファイルを使って、新しいエントリーを作る',
	'Show me the HTML' => 'アップロードしたファイルのHTMLを表示',
	'Image Thumbnail' => 'サムネイル',
	'Create a thumbnail for this image' => 'このイメージのサムネイルを作る',
	'Width:' => '幅:',
	'Pixels' => 'ピクセル',
	'Percent' => 'パーセント',
	'Height:' => '高さ:',
	'Constrain proportions' => '縦横比を固定する',
	'Would you like this file to be a:' => 'ファイルの表示方法を選んでください',
	'Popup Image' => 'ポップアップ',
	'Embedded Image' => '埋め込み',
	'Link' => 'リンク',

	## tmpl/cms/upload_confirm.tmpl
	'A file named \'[_1]\' already exists. Do you want to overwrite this file?' => 'ファイル [_1] はすでにあります。上書きしてもよろしいですか?',
	# 'No' => 'いいえ',
	# 'Yes' => 'はい',

	## tmpl/cms/view_log.tmpl
	'The Movable Type activity log contains a record of notable actions in the system. All times are displayed in GMT.' => 'ログにはシステムの利用記録が保存されています。時間はすべて GMT で表示されています',
	'The activity log has been reset.' => 'ログを消去しました',
	# 'Date' => '日付',
	# 'IP Address' => 'IPアドレス',
	'Log Message' => 'ログ・メッセージ',
	'Reset Activity Log' => 'ログの消去',

	## tmpl/email/new-comment.tmpl
	'An unapproved user has posted a comment on [_1], on entry #[_2] ([_3]). You need to approve this commenter before the comments will appear on your site.' => '未承認のユーザーがウェブログ [_1] のエントリー #[_2] ([_3]) にコメントしました。コメンターを承認するまでは、サイトには掲載されません',
	'Approve this commenter:' => 'コメントを受け入れる',
	'A new comment has been posted on your blog [_1], on entry #[_2] ([_3]).' => '新しいコメントがウェブログ [_1] のエントリー #[_2] ([_3]) にありました',
	'View this comment:' => 'このコメントを見る',
	'Edit this comment:' => 'このコメントを編集する',
	# 'IP Address:' => 'IPアドレス',
	'Name:' => '名前:',
	# 'Email Address:' => 'メールアドレス',
	# 'URL:' => 'URL:',
	'Comments:' => 'コメント:',

	## tmpl/email/verify-subscribe.tmpl
	'Thanks for subscribing to notifications about updates to [_1]. Follow the link below to confirm your subscription:' => '登録してくれてありがとう。ウェブログ: [_1]の更新通知への登録は、以下の URL にアクセスすると完了します。',
	'If the link is not clickable, just copy and paste it into your browser.' => 'クリックできないときは、アドレスをブラウザにコピーしてください。',

	## lib/MT/Template/Context.pm
	'Thanks for signing in,' => 'サイン・インしてくれてありがとう',
	'Now you can comment.' => 'さん。コメントしてください。',
	'sign out' => 'サイン・アウト',
	'(If you haven\'t left a comment here before, you may need to be approved by the site owner before your comment will appear. Until then, it won\'t appear on the entry. Thanks for waiting.)' => '(いままで、ここでコメントしたとがないときは、コメントを表示する前にこのウェブログのオーナーの承認が必要になることがあります。承認されるまではコメントは表示されません。そのときはしばらく待ってください。)',
	# 'Remember me?' => '情報を登録する?',
	# 'Yes' => 'はい',
	# 'No' => 'いいえ',
	# 'Comments:' => 'コメント:',
	# 'Preview' => '確認',
	# 'Post' => '投稿',
	'You are not signed in. You need to be registered to comment on this site.' => 'サイン・インしていません。このサイトにコメントをする前に登録してください。',
	'Sign in' => 'サイン・イン',
	'. Now you can comment.' => 'さん。コメントしてください。',
	'If you have a TypeKey identity, you can ' => 'TypeKey の ID をもっていたら、',
	'sign in' => 'サイン・イン',
	'to use it here.' => 'してください。',
	# 'Name:' => '名前:',
	# 'Email Address:' => 'メールアドレス',
	# 'URL:' => 'URL:',

	## lib/MT/App/CMS.pm
	'Main Menu' => 'メイン・メニュー',
	'Convert Line Breaks' => '改行を変換する',
	'Password Recovery' => 'パスワードの回復',
	'No such author with name \'[_1]\'' => 'ユーザー「[_1]」が見付かりません。',
	'Author has not set birthplace; cannot recover password' => '出生地が設定されていないので、パスワードの回復ができません',
	'Birthplace \'[_1]\' does not match stored birthplace for this author' => '出生地「[_1]」が一致しません',
	'Author does not have email address' => 'メールアドレスが登録されていません',
	'_USAGE_FORGOT_PASSWORD_1' => 'Movable Type のパスワードを回復します。パスワードはシステム側で変更され、新しいパスワードはこちらになります:',
	'_USAGE_FORGOT_PASSWORD_2' => '新しいパスワードを使って Movable Type にログインし、すぐにパスワードを変更してください。',
	'Error sending mail ([_1]); please fix the problem, then try again to recover your password.' => 'メール送信のエラー([_1])が発生しました。メールの設定を確認してから、もう一度試してください。',
	'You are not authorized to log in to this blog.' => 'このブログにログインする権限がありません。',
	'No such blog [_1]' => 'ブログ [_1] はありません',
	'QuickPost' => 'クイックポスト',
	'Permission denied.' => '権限がありません。',
	'Activity Log' => 'ログ',
	'Import/Export' => '読み込み・書き出し',
	'No permissions' => '権限がありません',
	'Permission denied' => '権限がありません',
	'Load failed: [_1]' => '読み込みに失敗しました: [_1]',
	'Entries' => 'エントリー',
	'(untitled)' => '(タイトルなし)',
	'Categories' => 'カテゴリー',
	'Templates' => 'テンプレート',
	'Configuration' => '設定',
	'Preferences' => '設定',
	'Core Setup' => '基本設定',
	'None' => 'なし',
	'Comments' => 'コメント',
	'Edit Comment' => 'コメントの編集',
	'New Entry' => '新規エントリー',
	'New Template' => '新規テンプレート',
	'New Weblog' => '新規ウェブログ',
	'Select' => '選択',
	'The value you entered was not a valid email address' => '有効なメールアドレスを入力してください',
	'You did not enter an IP address to ban.' => '禁止IPアドレスの編集はできません',
	'You did not specify a weblog name.' => 'ウェブログの名前を設定してください。',
	'No categories with the same name can have the same parent' => '同じ名前のサブ・カテゴリーは設定できません',
	'Saving object failed: [_1]' => 'オブジェクトの保存に失敗しました: [_1]',
	'Can\'t find default template list; where is \'default-templates.pl\'?' => 'デフォルト・テンプレートのリスト「default-tempaltes.pl」が見つかりません。',
	'Populating blog with default templates failed: [_1]' => 'デフォルト・テンプレートの設定に失敗しました: [_1]',
	'Setting up mappings failed: [_1]' => 'テンプレート・マッピングの設定に失敗しました: [_1]',
	'Authors' => '投稿者',
	'Notification List' => '通知リスト',
	'IP Banning' => '禁止IP',
	'TrackBack Pings' => 'トラックバック',
	'Can\'t delete that way' => 'この方法では削除できません',
	'Unknown object type [_1]' => 'このオブジェクト[_1]には対応していません',
	'Loading object driver [_1] failed: [_2]' => 'オブジェクト・ドライバー [_1] の読み込みに失敗しました: [_2]',
	'Invalid filename \'[_1]\'' => 'このファイル名 [_1] は有効ではありません',
	'Reading \'[_1]\' failed: [_2]' => '「[_1]」の読み込みに失敗しました。',
	'Thumbnail failed: [_1]' => 'サムネイルの作成に失敗しました: [_1]',
	'Error writing to \'[_1]\': [_2]' => '[_1] への書き込みができません: [_2]',
	'Invalid basename \'[_1]\'' => 'ファイル名のベース [_1] が正しくありません',
	'No such commenter' => 'コメンターが見付かりません',
	'You don\'t have permission to approve this comment.' => 'コメントを承認する権限がありません。',
	'Registered Commenters' => '登録済みコメンター',
	'Invalid date \'[_1]\'; authored on dates must be in the format YYYY-MM-DD HH:MM:SS.' => '日付「[_1]」の形式が正しくありません。日付は YYYY-MM-DD HH:MM:SS の形式で設定してください。',
	'Saving entry \'[_1]\' failed: [_2]' => 'エントリー「[_1]」の保存に失敗しました: [_2]',
	'Removing placement failed: [_1]' => 'エントリーとウェブログの関連付けの削除に失敗しました: [_1]',
	'Saving placement failed: [_1]' => 'エントリーとウェブログの関連付けを保存に失敗しました: [_1]',
	'No such entry.' => 'エントリーが見付かりません',
	'Invalid date \'[_1]\'; authored on dates should be real dates.' => '日付「[_1]」が正しくありません。存在しない日付が設定されています。',
	'Saving entry failed: [_1]' => 'エントリーの保存に失敗しました: [_1]',
	'Edit Categories' => 'カテゴリーの編集',
	'You do not have permission to configure the blog' => 'ブログの設定を行う権限がありません。',
	'Archiving' => 'アーカイブ',
	'Saving blog failed: [_1]' => 'ブログの保存に失敗しました: [_1]',
	'Saving map failed: [_1]' => 'マッピングの保存に失敗しました: [_1]',
	'Parse error: [_1]' => '解析エラー: [_1]',
	'Build error: [_1]' => '構築エラー: [_1]',
	'Rebuild Site' => 'サイトの再構築',
	'Authors & Permissions' => '投稿者と権限',
	'No entry ID provided' => 'エントリーIDがありません',
	'No such entry \'[_1]\'' => 'エントリー「[_1」がありません',
	'No email address for author \'[_1]\'' => '投稿者「[_1]」にはメールアドレスが設定されていません',
	'[_1] Update: [_2]' => '[_1] 更新 : [_2]',
	'Error sending mail ([_1]); try another MailTransfer setting?' => 'メール送信のエラー([_1]); 別の MailTransfer 設定も試してみてください。',
	'Upload File' => 'ファイルのアップロード',
	'You did not choose a file to upload.' => 'アップロードするファイルを選択してください',
	'Invalid extra path \'[_1]\'' => '追加のパス名「[_1]」が正しくありません',
	'Can\'t make path \'[_1]\': [_2]' => 'パス「[_1]」を作成できません: [_2]',
	'Invalid temp file name \'[_1]\'' => '一時ファイルの名前「[_1]」が正しくありません',
	'Error opening \'[_1]\': [_2]' => 'ファイル [_1] を開けません: [_2]',
	'Error deleting \'[_1]\': [_2]' => 'ファイル [_2] を削除できません: [_2]',
	'File with name \'[_1]\' already exists. (Install File::Temp if you\'d like to be able to overwrite existing uploaded files.)' => 'ファイル名「[_1]」はすでに存在しています。(ファイルを上書きしたいときは、File::Temp をインストールしてください)',
	'File with name \'[_1]\' already exists; Tried to write to tempfile, but open failed: [_2]' => 'ファイル「[_1]」はすでに存在しています。一時ファイルへの書き込みができず、ファイルを開けません: [_2]',
	'Error writing upload to \'[_1]\': [_2]' => '[_1] の書き込みエラー: [_2]',
	'Perl module Image::Size is required to determine width and height of uploaded images.' => '画像のサイズを調べるために、Perl モジュール Image::Size が必要です。',
	'Search & Replace' => '検索・置換',
	'Saving entry failed: [_1]' => 'エントリーの保存ができません: [_1]',
	'No blog ID' => 'ブログIDがありません',
	'Load of blog \'[_1]\' failed: [_2]' => 'ブログ [_1] の読み込みに失敗しました: [_2]',
	'You do not have export permissions' => '書き出しの権限がありません。',
	'You do not have import permissions' => '読み込みの権限がありません。',
	'You need to provide a password if you are going to\ncreate new authors for each author listed in your blog.\n' => '読み込みのときに同時にブログの投稿者のアカウントを作成するためには、パスワードの入力が必要です。',
	'Import already in progress.' => '現在読み込みの処理を行っています。',
	'Can\'t open directory \'[_1]\': [_2]' => 'ディレクトリ「[_1]」が開けません: [_2]',
	'Can\'t open file \'[_1]\': [_2]' => 'ファイル「[_1]」が開けません: [_2]',
	'Saving author failed: [_1]' => '投稿者を保存できません: [_1]',
	'Saving permission failed: [_1]' => '権限を保存できません: [_1]',
	'Saving category failed: [_1]' => 'カテゴリーを本できません: [_1]',
	'Invalid status value \'[_1]\'' => 'エントリーの状態の値 [_1] が正しくありません',
	'Saving comment failed: [_1]' => 'コメントの保存に失敗しました: [_1]',
	'Entry has no MT::Trackback object!' => 'このエントリーにはトラックバックがありません',
	'Saving ping failed: [_1]' => 'トラックバックの保存に失敗しました: [_1]',
	'Invalid date format \'[_1]\'; must be \'MM/DD/YYYY HH:MM:SS AM|PM\' (AM|PM is optional)' => '日付の形式「[_1]」が正しくありません。MM/DD/YYYY HH:MM:SS AM|PM (AM/PM はなくてもかまいません)',
	'Saving permissions failed: [_1]' => '権限の保存に失敗しました: [_1]',
	'Add a Category' => 'カテゴリーの追加',
	'Category Archive' => 'カテゴリー・アーカイブ',
	'Date-Based Archive' => '日付アーカイブ',
	'Individual Entry Archive' => '個別エントリーアーカイブ',
	'Atom Index' => 'Atomフィード',
	'Main Index' => 'メインページ',
	'Master Archive Index' => 'アーカイブページ',
	'RSD' => 'RSD',
	'RSS 1.0 Index' => 'RSS 1.0',
	'RSS 2.0 Index' => 'RSS 2.0',
	'Stylesheet' => 'スタイルシート',
	'Dynamic Site Bootstrapper' => 'ダイナミック・テンプレート用起動スクリプト',	'(skipping)' => '(スキップ)',
	'index' => 'インデックス',
	'index template' => 'インデックス・テンプレート',
	'entry' => 'エントリー',

	## lib/MT/App/Comments.pm
	'IP Banned Due to Excessive Comments' => '大量のコメントのため、この IP アドレスからのコメントの受けつけを停止しています。',
	'_THROTTLED_COMMENT_EMAIL' => 'あなたのウェブログ[_1]へのコメントが指定された[_2]秒間に複数回行われたため、自動的にそのIPアドレスを禁止IPアドレスに追加しました。[_3] がその IP アドレスです。必要であれば、このIPアドレス [_4] をリストから取り除いてください。',
	'No such entry \'[_1]\'.' => 'エントリー [_1] が見つかりません。',
	'You are not allowed to post comments.' => 'コメントの投稿が許可されていません。',
	'_THROTTLED_COMMENT' => '不必要なコメントの投稿を防ぐために、連続した投稿を受けつけないように設定しています。しばらくしてから、もう一度試してみてください。',
	'Comments are not allowed on this entry.' => 'このエントリーへのコメントは受けつけていません。',
	'Comment text is required.' => 'コメントの本文を入力してください。',
	'Registration is required.' => 'コメントを行うためには登録が必要です。',
	'Name and email address are required.' => '名前とメールアドレスを入力してください。',
	'Invalid email address \'[_1]\'' => 'メールアドレスを正しく入力してください: [_1]',
	'Invalid URL \'[_1]\'' => 'URL [_1] が正しくありません',
	'Rebuild failed: [_1]' => '再構築に失敗しました: [_1]',
	'New Comment Posted to \'[_1]\'' => '新しいコメントが「[_1]」に投稿されました',
	'No public key could be found to validate registration.' => '公開鍵が取得できませんでした',
	'Sign in requires a secure signature; logout requires the logout=1 parameter' => '署名が正しくありません。ログアウトのときは logout=1 のパラメータが必要です。',
	'The sign-in attempt was not successful; please try again.' => 'サイン・インに失敗しました。もう一度試してください。',
	'The sign-in validation was not successful. Please make sure your weblog is properly configured and try again.' => 'サイン・インに失敗しました。ウェブログの設定を確認してから試してください。',
	'No such entry ID \'[_1]\'' => 'エントリーID「[_1]」は存在しません',
	'You must define an Individual template in order to display dynamic comments.' => 'ダイナミックにコメントを表示するために個別・テンプレートを設定してください',
	'You must define a Comment Listing template in order to display dynamic comments.' => 'コメントをダイナミックに表示するためには、コメントリスト・テンプレートを設定してください。',
	'No entry was specified; perhaps there is a template problem?' => 'エントリーがありません。もしかすると、テンプレートの問題かもしれません。',
	'Somehow, the entry you tried to comment on does not exist' => 'コメントしようとしたエントリーが見付かりませんでした。',
	'You must define a Comment Pending template.' => 'コメント・保留のテンプレートを設定してください。',
	'You must define a Comment Error template.' => 'コメント・エラーのテンプレートを設定してください。',
	'You must define a Comment Preview template.' => 'コメント・プレビューのテンプレートを設定してください。',

	## lib/MT/App/NotifyList.pm
	'Please verify your email to subscribe' => 'メールアドレスの登録を確認してください',
	'_NOTIFY_REQUIRE_CONFIRMATION' => '確認のメールを [_1] 宛に送りました。登録するためには、メールに書かれている URL にアクセスしてください。このメールアドレスがあなたのものかを確認します。',
	'The address [_1] was not subscribed.' => 'メールアドレス [_1] は登録されていません。',
	'The address [_1] has been unsubscribed.' => 'メールアドレス [_1] の登録を解除しました。',

	## lib/MT/App/Search.pm
	'You are currently performing a search. Please wait until your search is completed.' => '現在検索中です。検索が終わるまでお待ちください。',
	'Search failed: [_1]' => '検索が失敗しました: [_1]',
	'Opening local file \'[_1]\' failed: [_2]' => 'ファイル [_1] を開けません: [_2]',
	'Building results failed: [_1]' => '結果の表示ができません: [_1]',
	'You used an [_1] tag outside of the proper context.' => 'コンテナ・タグの外側でタグ [_1] が使われています。',

	## lib/MT/App/Trackback.pm
	'Invalid entry ID \'[_1]\'' => 'エントリーID 「[_1]」が正しくありません。',
	'You must define a Ping template in order to display pings.' => 'トラックバックを表示するためには、トラックバック・テンプレートを設定してください。',
	'IP Banned Due to Excessive TrackBack Pings' => '大量のトラックバックのため、この IP アドレスからの受付を停止しています。',
	'Need a TrackBack ID (tb_id).' => 'トラックバック ID (tb_id) を指定してください。',
	'Invalid TrackBack ID \'[_1]\'' => 'トラックバック ID [_1] は有効ではありません。',
	'You are not allowed to send TrackBack pings.' => 'トラックバックの送信の権限がありません。',
	'You are pinging trackbacks too quickly. Please try again later.' => '連続してトラックバックを送信しています。しばらくして、もう一度試してください。',
	'Need a Source URL (url).' => '送信元の URL (url) が必要です。',
	'Invalid URL \'[_1]\'' => 'URL [_1] が正しくありません',
	'This TrackBack item is disabled.' => 'このトラックバックは停止しています。',
	'This TrackBack item is protected by a passphrase.' => 'このトラックバックURLには、パスフレーズが必要です。',
	'Rebuild failed: [_1]' => '再構築に失敗しました: [_1]',
	'Can\'t create RSS feed \'[_1]\': ' => 'RSSフィード [_1] が作成できません',
	'New TrackBack Ping to Entry [_1] ([_2])' => 'エントリー [_1] ([_2]) への新しいトラックバックです',
	'A new TrackBack ping has been sent to your weblog, on the entry [_1] ([_2]).' => 'エントリー [_1] ([_2]) へのトラックバックを受信しました。',
	'New TrackBack Ping to Category [_1] ([_2])' => 'カテゴリー [_1] ([_2]) への新しいトラックバックです',
	'A new TrackBack ping has been sent to your weblog, on the category [_1] ([_2]).' => 'カテゴリー [_1] ([_2]) へのトラックバックを受信しました。',
	'IP Address:' => 'IP アドレス:',
	'URL:' => 'URL:',
	'Title:' => 'タイトル:',
	'Weblog:' => 'ウェブログ:',
	'Excerpt:' => '概要:',

	## lib/MT/App/Viewer.pm

	## lib/MT/App.pm
	'Invalid login.' => 'ログインできません。',
	'The file you uploaded is too large.' => 'アップロードしようとしたファイルのサイズが大き過ぎます。',
	'Unknown action [_1]' => '[_1] はできません。',
	'Loading template \'[_1]\' failed: [_2]' => 'テンプレート「[_1]」の読み込みに失敗しました: [_2]',

	## lib/MT/Atom.pm

	## lib/MT/AtomServer.pm

	## lib/MT/Author.pm

	## lib/MT/Blog.pm

	## lib/MT/Builder.pm

	## lib/MT/Callback.pm

	## lib/MT/Category.pm

	## lib/MT/Comment.pm

	## lib/MT/ConfigMgr.pm
	'Error opening file \'[_1]\': [_2]' => 'ファイル「[_1]」を開けません: [_2]',
	'[_1]:[_2]: variable \'[_3]\' not defined' => '[_1]:[_2]: 変数「[_3]」が設定されていません。',
	'No such config variable \'[_1]\'' => '「[_1]」の設定はできません',

	## lib/MT/Entry.pm
	'Load of blog failed: [_1]' => 'ブログの読み込みに失敗しました: [_1]',
	'Load of blog \'[_1]\' failed: [_2]' => 'ブログ [_1] の読み込みに失敗しました: [_2]',

	## lib/MT/FileMgr/Local.pm
	'Opening local file \'[_1]\' failed: [_2]' => 'ファイル「[_1]」を開けません: [_2]',
	'Renaming \'[_1]\' to \'[_2]\' failed: [_3]' => 'ファイル名を「［_1]」から「[_2]」に変更できません: [_3]',

	## lib/MT/Image.pm
	'Can\'t load Image::Magick: [_1]' => 'Image::Magick が利用できません: [_1]',
	'Reading file \'[_1]\' failed: [_2]' => 'ファイル「[_1]」の読み込みに失敗しました: [_2]',
	'Reading image failed: [_1]' => '画像の読み込みに失敗しました: [_1]',
	'Scaling to [_1]x[_2] failed: [_3]' => 'サイズを [_1]x[_2] に変更できませんでした: [_3]',
	'Can\'t load IPC::Run: [_1]' => 'IPC::Run が利用できません: [_1]',
	'You do not have a valid path to the NetPBM tools on your machine.' => 'NetPBM の実行ファイルが見付かりません。',

	## lib/MT/ImportExport.pm
	'You need to provide a password if you are going to\ncreate new authors for each author listed in your blog.\n' => '読み込む記事に設定されている投稿者を新たに作成する場合は、パスワードを設定してください。',
	'Need either ImportAs or ParentAuthor' => '読み込みのときの投稿者を設定してください',
	'Saving author failed: [_1]' => '投稿者の設定ができません: [_1]',
	'Saving permission failed: [_1]' => '権限の設定ができません: [_1]',
	'Saving category failed: [_1]' => 'カテゴリーの設定ができません: [_1]',
	'Invalid status value \'[_1]\'' => '投稿の状態「[_1]」が正しくありません',
	'Saving entry failed: [_1]' => 'エントリーの保存に失敗しました: [_1]',
	'Saving placement failed: [_1]' => 'エントリーとブログの関連付けができません: [_1]',
	'Saving comment failed: [_1]' => 'コメントの保存に失敗しました: [_1]',
	'Entry has no MT::Trackback object!' => 'エントリーに対応した MT::Trackback オブジェクトがありません',
	'Saving ping failed: [_1]' => 'トラックバックの保存に失敗しました: [_1]',
	'Export failed on entry \'[_1]\': [_2]' => 'エントリー「[_1]」の書き出しに失敗しました: [_2]',

	## lib/MT/Mail.pm
	'Unknown MailTransfer method \'[_1]\'' => 'サポートしてないメール転送方式「[_1]」が設定されています',
	'Sending mail via SMTP requires that your server have Mail::Sendmail installed: [_1]' => 'SMTP でのメールの送信には、Mail::Sendmail モジュールのインストールが必要です: [_1]',
	'Error sending mail: [_1]' => 'メールの送信エラー: [_1]',
	'You do not have a valid path to sendmail on your machine. Perhaps you should try using SMTP?' => 'sendmail が実行できません。SMTP を使ったほうがいいかもしれません。',
	'Exec of sendmail failed: [_1]' => 'sendmail の実行時にエラーが発生しました: [_1]',

	## lib/MT/ObjectDriver/DBI/mysql.pm
	'Connection error: [_1]' => '接続エラー: [_1]',

	## lib/MT/ObjectDriver/DBM.pm
	'Your DataSource directory (\'[_1]\') does not exist.' => 'データベースを格納するディレクトリ ([_1])がありません。',
	'Tie \'[_1]\' failed: [_2]' => 'Tie [_1] ができません: [_2]',
	'Failed to generate unique ID: [_1]' => 'ID の生成に失敗しました: [_1]',
	'Unlink of \'[_1]\' failed: [_2]' => '[_1] の削除に失敗しました: [_2]',

	## lib/MT/Template/Context.pm
	'Can\'t find included template module \'[_1]\'' => '読み込むモジュール「[_1]」が見付かりません',
	'Can\'t find included file \'[_1]\'' => '読み込むファイル「[_1]」が見付かりません',
	'Error opening included file \'[_1]\': [_2]' => '読み込むファイル「[_1]」を開けません: [_2]',
	'Can\'t find template \'[_1]\'' => 'テンプレート「[_1]」が見付かりません',
	'Can\'t find entry \'[_1]\'' => 'エントリー「[_1]」が見付かりません',
	'You used a [_1] tag without any arguments.' => 'タグ [_1] への設定がありません。',
	'You can\'t use both AND and OR in the same expression ([_1]).' => 'AND と OR を同時に利用できません。',
	'No such category \'[_1]\'' => 'カテゴリー「[_1]」は存在しません',
	'No such author \'[_1]\'' => '投稿者「[_1]」は存在しません',
	'You used an \'[_1]\' tag outside of the context of an entry; perhaps you mistakenly placed it outside of an \'MTEntries\' container?' => 'タグ [_1] をエントリー以外の場所では使えません。MTEntries コンテナ・タグの外で使っているのかもしれません。',
	'You used <$MTEntryFlag$> without a flag.' => '<$MTEntryFlag$> にはフラグの設定を行ってください。',
	'(You may use HTML tags for style)' => '(スタイル用の HTLM タグが使えます)',
	'To enable comment registration, you need to add a TypeKey token in your weblog config or author profile.' => 'コメント登録機能を使うには、TypeKey トークンをウェブログ、もしくは投稿者のプロフィールで設定する必要があります。',
	'You used an [_1] tag without a date context set up.' => '日付以外の場所では、タグ [_1] を利用できません。',
	'You used an \'[_1]\' tag outside of the context of a comment; perhaps you mistakenly placed it outside of an \'MTComments\' container?' => 'コメント以外の場所でタグ [_1] を利用できません。MTComment コンテナ・タグの外側で使っているのかもしれません',
	'You used an [_1] without a date context set up.' => '日付以外の場所では、タグ [_1] を利用できません。',
	'[_1] can be used only with Daily, Weekly, or Monthly archives.' => '[_1] は日別、週別、月別いずれかのアーカイブでのみ使えます。',
	'The archive type specified in MTArchiveList (\'[_1]\') is not one of the chosen archive types in your blog configuration.' => 'MTArchiveLit ([_1])で利用できるアーカイブの種別は、ブログの設定で指定されているものだけです。',
	'You used an [_1] tag outside of the proper context.' => 'タグ [_1] がコンテナ・タグの外側で使われています。',
	'You used an [_1] tag outside of a Daily, Weekly, or Monthly context.' => 'タグ [_1] は日付ベースのアーカイブでのみ使えます。',
	'Invalid month format: must be YYYYMM' => '月を指定する形式が正しくありません。 YYYYMM の形式で指定してください。',
	'[_1] can be used only if you have enabled Category archives.' => '[_1] はカテゴリー・アーカイブで利用できます。',
	'You used [_1] without a query.' => '[_1] を利用するときは query を指定してください。',
	'You need a Google API key to use [_1]' => '[_1] を利用するには、Google API key を設定してください。',
	'You used a non-existent property from the result structure.' => '存在していない項目を指定しています。',

	## lib/MT/Template.pm
	'Load of blog \'[_1]\' failed: [_2]' => 'ブログ [_1] の読み込みに失敗しました: [_2]',
	'Parse error in template \'[_1]\': [_2]' => 'テンプレート [_1] の解析に失敗しました: [_2]',
	'Build error in template \'[_1]\': [_2]' => 'テンプレート [_1] の再構築に失敗しました: [_2]',
	'You cannot use a [_1] extension for a linked file.' => 'リンク先のファイルには、拡張子 [_1] を指定できません。',
	'Opening linked file \'[_1]\' failed: [_2]' => 'リンク先ファイル [_1] を開けません: [_2]',

	## lib/MT/Util.pm
	'Invalid Archive Type setting \'[_1]\'' => 'アーカイブ種別の設定が正しくありません: [_1]',

	## lib/MT/XMLRPC.pm
	'No WeblogsPingURL defined in mt.cfg' => 'WeblogPingURL が mt.cfg に設定されていません',
	'No MTPingURL defined in mt.cfg' => 'MTPingURL が mt.cfg に設定されていません',
	'HTTP error: [_1]' => 'HTTP エラー: [_1]',
	'Ping error: [_1]' => 'Ping エラー: [_1]',

	## lib/MT.pm
	'Load of blog \'[_1]\' failed: [_2]' => 'ブログ [_1] の読み込みに失敗しました: [_2]',
	'Archive type \'[_1]\' is not a chosen archive type' => 'アーカイブの種類 [_1] はアーカイブの設定をされていません。',
	'Parameter \'[_1]\' is required' => 'パラメータ [_1] を設定してください。',
	'Building category archives, but no category provided.' => 'カテゴリー・アーカイブを構築しようとしましたが、カテゴリーがありません。',
	'You did not set your Local Archive Path' => 'ローカル・アーカイブパスを設定してください',
	'Building category \'[_1]\' failed: [_2]' => 'カテゴリー・アーカイブ「[_1]」の再構築に失敗しました: [_2]',
	'Building entry \'[_1]\' failed: [_2]' => '個別アーカイブ・エントリー「[_1]」の再構築に失敗しました: [_2]',
	'Building date-based archive \'[_1]\' failed: [_2]' => '日付ベースのアーカイブ「[_1]」の再構築に失敗しました: [_2]',
	'Error making path \'[_1]\': [_2]' => 'ディレクトリ [_1] の作成に失敗しました: [_2]',
	'You did not set your Local Site Path' => 'ローカル・サイトパスを設定してください',
	'Template \'[_1]\' does not have an Output File.' => 'テンプレート「[_1]」の出力ファイルが設定されていません。',

        ## lib/MT/Permission.pm
        'Edit All Posts' => 'エントリーの編集',
        'Edit Templates' => 'テンプレートの編集',
        # 'Edit Authors & Permissions' => '投稿者と権限の編集',
        'Edit Authors &amp; Permissions' => '投稿者と権限の編集',
        'Configure Weblog' => 'ウェブログの設定',
        'Rebuild Files' => 'サイトの再構築',
        'Send Notifications' => '通知の送信',
        'Edit Address Book' => 'アドレス帳の編集',

	## lib/MT/default-templates.pl
	'Continue reading' => '続きを読む',
	'Posted by' => '投稿者',
	'at' => ':',
	'Comments' => 'コメント',
	'TrackBack' => 'トラックバック',
	'Monthly calendar with links to each day\'s posts' => '投稿されたエントリーへのリンク付き月間カレンダー',
	'Sunday' => '日曜日',
	'Sun' => '日',
	'Monday' => '月曜日',
	'Mon' => '月',
	'Tuesday' => '火曜日',
	'Tue' => '火',
	'Wednesday' => '水曜日',
	'Wed' => '水',
	'Thursday' => '木曜日',
	'Thu' => '木',
	'Friday' => '金曜日',
	'Fri' => '金',
	'Saturday' => '土曜日',
	'Sat' => '土',
	'Search' => '検索',
	'Search this site:' => 'サイト内の検索',
	'Archives' => 'アーカイブ',
	'Recent Entries' => '最近のエントリー',
	'Syndicate this site' => 'Syndicate this site',
	'This weblog is licensed under a' => 'このウェブログのライセンス:',
	'Powered by' => 'Powered by',
	'Comment Preview' => 'コメントの確認',
	'Previewing your Comment' => 'コメントの確認',
	'Previous Comments' => '以前のコメント',
	'Thank You for Commenting' => 'コメントしてくれてありがとう! ',
	'Your comment has been received. To protect against malicious comments, I have enabled a feature that allows your comments to be held for approval the first time you post a comment. I\'ll approve your comment when convenient; there is no need to re-post your comment.' => 'コメントを受けつけました。不適切なコメントを防止するために、初回のコメントが掲載される前に確認しています。適切なコメントであれば掲載されるでしょう。もう一度投稿する必要はありません。',
	'Return to the comment page' => 'コメントのページに戻る',
	'Comment Submission Error' => 'コメントの登録エラー',
	'Your comment submission failed for the following reasons:' => 'コメントの登録が失敗しました:',
	'Comment on' => 'コメント:',
	'Comments:' => 'コメント:',
	'Post a comment' => 'コメントしてください',
	'Main' => 'メイン',
	'Trackback Pings' => 'トラックバック',
	'TrackBack URL for this entry:' => 'このエントリーのトラックバックURL:',
	'Listed below are links to weblogs that reference' => 'このリストは、次のエントリーを参照しています: ',
	'Read More' => '続きを読む',
	'Tracked on' => 'トラックバック時刻: ',
	'Posted by:' => '投稿者',
	'Thanks for signing in, ' => 'サイン・インを確認しました、',
	'Now you can comment.' => 'さん。コメントしてください。',
	'sign out' => 'サイン・アウト',
	'(If you haven\'t left a comment here before, you may need to be approved by the site owner before your comment will appear. Until then, it won\'t appear on the entry. Thanks for waiting.)' => '(いままで、ここでコメントしたとがないときは、コメントを表示する前にこのウェブログのオーナーの承認が必要になることがあります。承認されるまではコメントは表示されません。そのときはしばらく待ってください。)',
	'URL' => 'URL',
	'Remember me?' => '情報を登録する?',
	'Yes' => 'はい',
	'No' => 'いいえ',
	'Preview' => '確認',
	'Post' => '投稿',
	'You are not signed in. You need to be registered to comment on this site.' => 'サイン・インしていません。このサイトにコメントをする前に登録してください。',
	'Sign in' => 'サイン・イン',
	'&#xA1;Comment registration is required but no TypeKey token has been given in weblog configuration!' => 'コメント登録機能を利用するには、TypeKey トークンを設定してください。',
	'. Now you can comment.' => 'さん。コメントしてください。',
	'If you have a TypeKey identity, you can' => 'TypeKey ID を使って',
	'sign in' => 'サイン・イン',
	'to use it here.' => 'してください。',
	'Name' => '名前',
	'Email Address' => 'メールアドレス',
	'Remember Me?' => '保存しますか?',
	'(you may use HTML tags for style)' => '(書式を変更するような一部のHTMLタグを使うことができます)',
	'Discussion on' => 'トラックバック: ',
	'Continuing the discussion...' => 'トラックバック',
	'from' => ',',

	## search_templates/default.tmpl
	'Search Results' => '検索結果',
	'Search this site:' => 'このサイトの検索',
	'Search' => '検索',
	'Match case' => '大文字/小文字を区別',
	'Regex search' => '正規表現で検索',
	'Search Results from [_1]' => '「[_1]」の検索結果',
	'Searched for \'[_1]\'' => '「[_1]」の検索結果',
	'No pages were found containing \'[_1]\'.' => '「[_1]」が含まれるページが見付かりませんでした。',
	'Instructions' => '利用方法',
	'By default, this search engine looks for all words in any order. To search for an exact phrase, enclose the phrase in quotes:' => 'すべての言葉が含まれるページを検索します。言葉を検索するときは、引用符「"」で囲んでください。',
	'The search engine also supports AND, OR, and NOT keywords to specify boolean expressions:' => '以下のように検索条件を AND、OR、NOT を使って指定することもできます:',
	'personal OR publishing' => 'personal OR publishing',
	'publishing NOT personal' => 'publishing NOT personal',
	'Posted in ' => '投稿: ',
	' on ' => ' | ',

	## search_templates/comments.tmpl
	# 'Search Results' => '検索結果',
	'Search for new comments from:' => '新しいコメントから検索:',
	'the beginning' => '開始時点から',
	'one week back' => '一週間前',
	'two weeks back' => '二週間前',
	'one month back' => '一ヶ月前',
	'two months back' => '二ヶ月前',
	'three months back' => '三ヶ月前',
	'four months back' => '四ヶ月前',
	'five months back' => '五ヶ月前',
	'six months back' => '六ヶ月前',
	'one year back' => '一年前',
	'Find new comments' => 'コメントを検索',
	'No results found' => '見付かりませんでした。',
	'No new comments were found in the specified interval.' => '指定された期間にコメントは見付かりませんでした',
	'Instructions' => '使用方法',
	'Select the time interval that you\'d like to search in, then click \'Find new comments\'' => '検索したい期間を選択して「コメントを検索」をクリックしてください。',
);

1;
